/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.dist;

import org.renjin.invoke.annotations.Operand;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Euclidean1dDistanceMatrix
extends DoubleVector
implements DeferredComputation {
    @Operand
    private Vector vector;
    private int size;
    private int length;

    public Euclidean1dDistanceMatrix(Vector vector, AttributeMap attributes) {
        super(attributes);
        this.vector = vector;
        this.size = vector.length();
        this.length = this.size * this.size;
    }

    public Euclidean1dDistanceMatrix(Vector vector) {
        this(vector, AttributeMap.dim((int)vector.length(), (int)vector.length()));
    }

    protected SEXP cloneWithNewAttributes(AttributeMap attributes) {
        return new Euclidean1dDistanceMatrix(this.vector, attributes);
    }

    public double getElementAsDouble(int index) {
        int col;
        int size = this.vector.length();
        int row = index % size;
        if (row == (col = index / size)) {
            return 0.0;
        }
        double x = this.getOperandElementAsDouble(row);
        double y = this.getOperandElementAsDouble(col);
        return Math.abs(x - y);
    }

    public boolean isConstantAccessTime() {
        return false;
    }

    public boolean isDeferred() {
        return true;
    }

    public static double test(int index, int size) {
        return Math.sqrt(index % size);
    }

    private double getOperandElementAsDouble(int row) {
        return this.vector.getElementAsDouble(row);
    }

    public int length() {
        return this.getOperandLength() * this.getOperandLength();
    }

    private int getOperandLength() {
        return this.vector.length();
    }

    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    public String getComputationName() {
        return "dist";
    }
}

