/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.dist;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Euclidean1dDistanceTriangle
extends DoubleVector
implements DeferredComputation {
    private Vector vector;
    private int length;
    private int size;

    public Euclidean1dDistanceTriangle(Vector vector, AttributeMap attributes) {
        super(attributes);
        this.vector = vector;
        this.size = vector.length();
        this.length = this.size * (this.size - 1) / 2;
    }

    public Vector getVector() {
        return this.vector;
    }

    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    public String getComputationName() {
        return "dist";
    }

    protected SEXP cloneWithNewAttributes(AttributeMap attributes) {
        return new Euclidean1dDistanceTriangle(this.vector, attributes);
    }

    public double getElementAsDouble(int index) {
        int colStart = 0;
        int col = 0;
        while (true) {
            int colLength;
            if (index < colStart + (colLength = this.size - col - 1)) {
                int row = col + 1 + (index - colStart);
                return Math.abs(this.vector.getElementAsDouble(row) - this.vector.getElementAsDouble(col));
            }
            colStart += colLength;
            ++col;
        }
    }

    public boolean isConstantAccessTime() {
        return this.vector.isConstantAccessTime();
    }

    public boolean isDeferred() {
        return true;
    }

    public int length() {
        return this.length;
    }
}

