/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Arith;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rinternals2;
import org.renjin.gnur.api.Rmath;
import org.renjin.sexp.SEXP;

public class distance__ {
    private distance__() {
    }

    public static SEXP Cdist(SEXP x, SEXP smethod, SEXP attrs, SEXP p) {
        double rp$3;
        int method$2;
        int nc$1;
        int nr$0;
        double[] rp = new double[1];
        int[] diag = new int[1];
        int[] method = new int[1];
        int[] nc = new int[1];
        int[] nr = new int[1];
        SEXP names = (SEXP)BytePtr.of((int)0).getArray();
        SEXP ans = (SEXP)BytePtr.of((int)0).getArray();
        nr[0] = nr$0 = Rinternals.Rf_nrows((SEXP)x);
        nc[0] = nc$1 = Rinternals.Rf_ncols((SEXP)x);
        method[0] = method$2 = Rinternals.Rf_asInteger((SEXP)smethod);
        diag[0] = 0;
        rp[0] = rp$3 = Rinternals.Rf_asReal((SEXP)p);
        int n = nr[0] + -1;
        int nr$5 = nr[0];
        int N = n * nr$5 / 2;
        ans = Rinternals.Rf_allocVector((int)14, (int)N);
        Rinternals.Rf_protect((SEXP)ans);
        if (Rinternals.TYPEOF((SEXP)x) != 14) {
            x = Rinternals.Rf_coerceVector((SEXP)x, (int)14);
        }
        Rinternals.Rf_protect((SEXP)x);
        Ptr ptr = Rinternals2.REAL((SEXP)ans);
        distance__.R_distance(Rinternals2.REAL((SEXP)x), (Ptr)new IntPtr(nr, 0), (Ptr)new IntPtr(nc, 0), ptr, (Ptr)new IntPtr(diag, 0), (Ptr)new IntPtr(method, 0), (Ptr)new DoublePtr(rp, 0));
        SEXP R_NamesSymbol$6 = Rinternals.R_NamesSymbol;
        names = Rinternals.Rf_getAttrib((SEXP)attrs, (SEXP)R_NamesSymbol$6);
        int i = 0;
        while (Rinternals.LENGTH((SEXP)attrs) > i) {
            SEXP sEXP = Rinternals.VECTOR_ELT((SEXP)attrs, (int)i);
            SEXP sEXP2 = Rinternals.Rf_install((BytePtr)Rinternals.Rf_translateChar((SEXP)Rinternals.STRING_ELT((SEXP)names, (int)i)));
            Rinternals.Rf_setAttrib((SEXP)ans, (SEXP)sEXP2, (SEXP)sEXP);
            ++i;
        }
        Rinternals.Rf_unprotect((int)2);
        return ans;
    }

    public static void R_distance(Ptr x, Ptr nr, Ptr nc, Ptr d, Ptr diag, Ptr method, Ptr p) {
        MethodHandle distfun = BytePtr.of((int)0).toMethodHandle();
        int ij = 0;
        int j = 0;
        int dc = 0;
        distfun = BytePtr.of((int)0).toMethodHandle();
        switch (method.getInt()) {
            case 1: {
                distfun = cfr_ldc_0();
                break;
            }
            case 2: {
                distfun = cfr_ldc_1();
                break;
            }
            case 3: {
                distfun = cfr_ldc_2();
                break;
            }
            case 4: {
                distfun = cfr_ldc_3();
                break;
            }
            case 5: {
                distfun = cfr_ldc_4();
                break;
            }
            case 6: {
                if (Math.abs(p.getDouble()) <= Double.MAX_VALUE && !(p.getDouble() <= 0.0)) break;
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("distance(): invalid p\u0000".getBytes(), 0)), (Object[])new Object[0]);
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("distance(): invalid distance\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        dc = diag.getInt() != 0 ? 0 : 1;
        ij = 0;
        j = 0;
        while (nr.getInt() >= j) {
            int i = j + dc;
            while (nr.getInt() > i) {
                double iftmp$7;
                int n = ij * 8;
                Ptr ptr = d;
                int n2 = n;
                if (method.getInt() != 6) {
                    int n3 = nc.getInt();
                    int n4 = nr.getInt();
                    iftmp$7 = distfun.invoke(x, n4, n3, i, j);
                } else {
                    double d2 = p.getDouble();
                    int n5 = nc.getInt();
                    int n6 = nr.getInt();
                    iftmp$7 = distance__.R_minkowski(x, n6, n5, i, j, d2);
                }
                ptr.setDouble(n2, iftmp$7);
                ++ij;
                ++i;
            }
            ++j;
        }
    }

    public static double R_minkowski(Ptr x, int nr, int nc, int i1, int i2, double p) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d2;
            int n3;
            int n4;
            Ptr ptr2;
            double d3;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            double d4;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = n7;
            double d5 = ptr4.getDouble(n8);
            if ((Double.isNaN(d5) || Double.isNaN(d5)) ^ true && (Double.isNaN(d4 = (ptr3 = x).getDouble(n6 = (n5 = i2 * 8))) || Double.isNaN(d4)) ^ true && (Double.isNaN(dev = (d3 = (ptr2 = x).getDouble(n4 = (n3 = i1 * 8))) - (d2 = (ptr = x).getDouble(n2 = (n = i2 * 8)))) || Double.isNaN(dev)) ^ true) {
                dist = Rmath.R_pow((double)Math.abs(dev), (double)p) + dist;
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d6 = count;
                double d7 = nc;
                double d8 = d6 / d7;
                dist /= d8;
            }
            double d9 = 1.0 / p;
            d = Rmath.R_pow((double)dist, (double)d9);
        }
        return d;
    }

    public static double R_dist_binary(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int dist = 0;
        int count = 0;
        int total = 0;
        total = 0;
        count = 0;
        dist = 0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d2;
            Ptr ptr2 = x;
            int n3 = i1 * 8;
            int n4 = n3;
            double d3 = ptr2.getDouble(n4);
            if ((Double.isNaN(d3) || Double.isNaN(d3)) ^ true && (Double.isNaN(d2 = (ptr = x).getDouble(n2 = (n = i2 * 8))) || Double.isNaN(d2)) ^ true) {
                int n5;
                int n6;
                Ptr ptr3;
                Ptr ptr4 = x;
                int n7 = i1 * 8;
                int n8 = n7;
                if (!(Math.abs(ptr4.getDouble(n8)) <= Double.MAX_VALUE) || !(Math.abs((ptr3 = x).getDouble(n6 = (n5 = i2 * 8))) <= Double.MAX_VALUE)) {
                    Error.Rf_warning((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("treating non-finite values as NA\u0000".getBytes(), 0)), (Object[])new Object[0]);
                } else {
                    int n9;
                    int n10;
                    Ptr ptr5;
                    int n11 = i1 * 8;
                    Ptr ptr6 = x;
                    int n12 = n11;
                    if (ptr6.getDouble(n12) != 0.0 || (ptr5 = x).getDouble(n10 = (n9 = i2 * 8)) != 0.0) {
                        int n13;
                        int n14;
                        Ptr ptr7;
                        ++count;
                        Ptr ptr8 = x;
                        int n15 = i1 * 8;
                        int n16 = n15;
                        if (ptr8.getDouble(n16) == 0.0 || (ptr7 = x).getDouble(n14 = (n13 = i2 * 8)) == 0.0) {
                            ++dist;
                        }
                    }
                    ++total;
                }
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (total == 0) {
            d = Arith.R_NaReal;
        } else if (count == 0) {
            d = 0.0;
        } else {
            double d4 = dist;
            double d5 = count;
            d = d4 / d5;
        }
        return d;
    }

    public static double R_canberra(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            block7: {
                double dev;
                block8: {
                    int n;
                    int n2;
                    Ptr ptr;
                    double d2;
                    Ptr ptr2 = x;
                    int n3 = i1 * 8;
                    int n4 = n3;
                    double d3 = ptr2.getDouble(n4);
                    if (!((Double.isNaN(d3) || Double.isNaN(d3)) ^ true) || !((Double.isNaN(d2 = (ptr = x).getDouble(n2 = (n = i2 * 8))) || Double.isNaN(d2)) ^ true)) break block7;
                    int n5 = i1 * 8;
                    Ptr ptr3 = x;
                    int n6 = n5;
                    double d4 = Math.abs(ptr3.getDouble(n6));
                    int n7 = i2 * 8;
                    Ptr ptr4 = x;
                    int n8 = n7;
                    double d5 = Math.abs(ptr4.getDouble(n8));
                    double sum = d4 + d5;
                    int n9 = i1 * 8;
                    Ptr ptr5 = x;
                    int n10 = n9;
                    double d6 = ptr5.getDouble(n10);
                    int n11 = i2 * 8;
                    Ptr ptr6 = x;
                    int n12 = n11;
                    double d7 = ptr6.getDouble(n12);
                    double diff = Math.abs(d6 - d7);
                    if (!(sum > Double.MIN_NORMAL) && !(diff > Double.MIN_NORMAL)) break block7;
                    dev = diff / sum;
                    if ((Double.isNaN(dev) || Double.isNaN(dev)) ^ true) break block8;
                    if (Math.abs(diff) <= Double.MAX_VALUE || diff != sum) break block7;
                    dev = 1.0;
                }
                dist += dev;
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d8 = count;
                double d9 = nc;
                double d10 = d8 / d9;
                dist /= d10;
            }
            d = dist;
        }
        return d;
    }

    public static double R_manhattan(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d2;
            int n3;
            int n4;
            Ptr ptr2;
            double d3;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            double d4;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = n7;
            double d5 = ptr4.getDouble(n8);
            if ((Double.isNaN(d5) || Double.isNaN(d5)) ^ true && (Double.isNaN(d4 = (ptr3 = x).getDouble(n6 = (n5 = i2 * 8))) || Double.isNaN(d4)) ^ true && (Double.isNaN(dev = Math.abs((d3 = (ptr2 = x).getDouble(n4 = (n3 = i1 * 8))) - (d2 = (ptr = x).getDouble(n2 = (n = i2 * 8))))) || Double.isNaN(dev)) ^ true) {
                dist += dev;
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d6 = count;
                double d7 = nc;
                double d8 = d6 / d7;
                dist /= d8;
            }
            d = dist;
        }
        return d;
    }

    public static double R_maximum(Ptr x, int nr, int nc, int i1, int i2) {
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = -1.7976931348623157E308;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d;
            int n3;
            int n4;
            Ptr ptr2;
            double d2;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            double d3;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = n7;
            double d4 = ptr4.getDouble(n8);
            if ((Double.isNaN(d4) || Double.isNaN(d4)) ^ true && (Double.isNaN(d3 = (ptr3 = x).getDouble(n6 = (n5 = i2 * 8))) || Double.isNaN(d3)) ^ true && (Double.isNaN(dev = Math.abs((d2 = (ptr2 = x).getDouble(n4 = (n3 = i1 * 8))) - (d = (ptr = x).getDouble(n2 = (n = i2 * 8))))) || Double.isNaN(dev)) ^ true) {
                if (dev > dist) {
                    dist = dev;
                }
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        double d = count == 0 ? Arith.R_NaReal : dist;
        return d;
    }

    public static double R_euclidean(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d2;
            int n3;
            int n4;
            Ptr ptr2;
            double d3;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            double d4;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = n7;
            double d5 = ptr4.getDouble(n8);
            if ((Double.isNaN(d5) || Double.isNaN(d5)) ^ true && (Double.isNaN(d4 = (ptr3 = x).getDouble(n6 = (n5 = i2 * 8))) || Double.isNaN(d4)) ^ true && (Double.isNaN(dev = (d3 = (ptr2 = x).getDouble(n4 = (n3 = i1 * 8))) - (d2 = (ptr = x).getDouble(n2 = (n = i2 * 8)))) || Double.isNaN(dev)) ^ true) {
                double d6 = dev;
                dist = d6 * d6 + dist;
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d7 = count;
                double d8 = nc;
                double d9 = d7 / d8;
                dist /= d9;
            }
            d = Mathlib.sqrt((double)dist);
        }
        return d;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_euclidean", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_maximum", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_manhattan", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_canberra", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_4() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_dist_binary", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

