/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Arith;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rinternals2;
import org.renjin.gnur.api.Rmath;
import org.renjin.gnur.sort;
import org.renjin.sexp.SEXP;

public class lowess__ {
    private lowess__() {
    }

    public static SEXP lowess(SEXP x, SEXP y, SEXP sf, SEXP siter, SEXP sdelta) {
        if (Rinternals.TYPEOF((SEXP)x) != 14 || Rinternals.TYPEOF((SEXP)y) != 14) {
            Error.Rf_error((BytePtr)new BytePtr("invalid input\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        int nx = Rinternals.LENGTH((SEXP)x);
        int R_NaInt$0 = Arith.R_NaInt;
        if (nx == R_NaInt$0 || nx == 0) {
            Error.Rf_error((BytePtr)new BytePtr("invalid input\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        double f = Rinternals.Rf_asReal((SEXP)sf);
        if (!(Math.abs(f) <= Double.MAX_VALUE) || f <= 0.0) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("'f' must be finite and > 0\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        int iter = Rinternals.Rf_asInteger((SEXP)siter);
        int R_NaInt$1 = Arith.R_NaInt;
        if (iter == R_NaInt$1 || iter < 0) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("'iter' must be finite and >= 0\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        double delta = Rinternals.Rf_asReal((SEXP)sdelta);
        if (!(Math.abs(delta) <= Double.MAX_VALUE) || delta < 0.0) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("'delta' must be finite and > 0\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        SEXP ans = Rinternals.Rf_allocVector((int)14, (int)nx);
        Rinternals.Rf_protect((SEXP)ans);
        DoublePtr rw = DoublePtr.malloc((int)(nx * 8));
        DoublePtr res = DoublePtr.malloc((int)(nx * 8));
        Ptr ptr = Rinternals2.REAL((SEXP)ans);
        Ptr ptr2 = Rinternals2.REAL((SEXP)y);
        lowess__.clowess(Rinternals2.REAL((SEXP)x), ptr2, nx, f, iter, delta, ptr, (Ptr)rw, (Ptr)res);
        Rinternals.Rf_unprotect((int)1);
        return ans;
    }

    public static void clowess(Ptr x, Ptr y, int n, double f, int nsteps, double delta, Ptr ys, Ptr rw, Ptr res) {
        int[] ok = new int[1];
        double sc = 0.0;
        double denom = 0.0;
        double cut = 0.0;
        double cmad = 0.0;
        double c9 = 0.0;
        double c1 = 0.0;
        ok[0] = 0;
        int ns = 0;
        int nright = 0;
        int nleft = 0;
        int last = 0;
        int iter = 0;
        int i = 0;
        if (n <= 1) {
            double d = y.getDouble();
            ys.setDouble(d);
        } else {
            x = x.pointerPlus(-8);
            y = y.pointerPlus(-8);
            ys = ys.pointerPlus(-8);
            int n2 = (int)((double)n * f + 1.0E-7);
            int n3 = Rmath.Rf_imin2((int)n, (int)n2);
            ns = Rmath.Rf_imax2((int)2, (int)n3);
            iter = 1;
            while (nsteps + 1 >= iter) {
                nleft = 1;
                nright = ns;
                last = 0;
                i = 1;
                while (true) {
                    int n4;
                    int n5;
                    Ptr ptr;
                    double d;
                    int n6;
                    int n7;
                    Ptr ptr2;
                    double d2;
                    double d22;
                    int n8;
                    int n9;
                    Ptr ptr3;
                    double d3;
                    int n10;
                    int n11;
                    Ptr ptr4;
                    double d4;
                    double d1;
                    if (nright < n && (d1 = (d4 = (ptr4 = x).getDouble(n11 = (n10 = i * 8))) - (d3 = (ptr3 = x).getDouble(n9 = (n8 = nleft * 8)))) > (d22 = (d2 = (ptr2 = x).getDouble(n7 = (n6 = (nright + 1) * 8))) - (d = (ptr = x).getDouble(n5 = (n4 = i * 8))))) {
                        ++nleft;
                        ++nright;
                        continue;
                    }
                    int n12 = iter <= 1 ? 0 : 1;
                    int n13 = i * 8;
                    Ptr ptr5 = ys;
                    int n14 = n13;
                    int n15 = i * 8;
                    Ptr ptr6 = x;
                    int n16 = n15;
                    Ptr ptr7 = y;
                    lowess__.lowest(x.pointerPlus(8), ptr7.pointerPlus(8), n, ptr6.pointerPlus(n16), ptr5.pointerPlus(n14), nleft, nright, res, n12, rw, (Ptr)new IntPtr(ok, 0));
                    if (ok[0] == 0) {
                        int n17 = i * 8;
                        Ptr ptr8 = ys;
                        int n18 = n17;
                        int n19 = i * 8;
                        Ptr ptr9 = y;
                        int n20 = n19;
                        double d5 = ptr9.getDouble(n20);
                        ptr8.setDouble(n18, d5);
                    }
                    if (i + -1 > last) {
                        int n21 = i * 8;
                        Ptr ptr10 = x;
                        int n22 = n21;
                        double d6 = ptr10.getDouble(n22);
                        int n23 = last * 8;
                        Ptr ptr11 = x;
                        int n24 = n23;
                        double d7 = ptr11.getDouble(n24);
                        denom = d6 - d7;
                        int j = last + 1;
                        while (j < i) {
                            int n25 = j * 8;
                            Ptr ptr12 = x;
                            int n26 = n25;
                            double d8 = ptr12.getDouble(n26);
                            int n27 = last * 8;
                            Ptr ptr13 = x;
                            int n28 = n27;
                            double d9 = ptr13.getDouble(n28);
                            double alpha = (d8 - d9) / denom;
                            int n29 = j * 8;
                            Ptr ptr14 = ys;
                            int n30 = n29;
                            int n31 = i * 8;
                            Ptr ptr15 = ys;
                            int n32 = n31;
                            double d10 = ptr15.getDouble(n32) * alpha;
                            double d11 = 1.0 - alpha;
                            int n33 = last * 8;
                            Ptr ptr16 = ys;
                            int n34 = n33;
                            double d12 = ptr16.getDouble(n34);
                            double d13 = d11 * d12;
                            double d14 = d10 + d13;
                            ptr14.setDouble(n30, d14);
                            ++j;
                        }
                    }
                    last = i;
                    int n35 = last * 8;
                    Ptr ptr17 = x;
                    int n36 = n35;
                    cut = ptr17.getDouble(n36) + delta;
                    i = last + 1;
                    while (i <= n) {
                        Ptr ptr18 = x;
                        int n37 = i * 8;
                        int n38 = n37;
                        if (ptr18.getDouble(n38) > cut) break;
                        int n39 = i * 8;
                        Ptr ptr19 = x;
                        int n40 = n39;
                        double d15 = ptr19.getDouble(n40);
                        int n41 = last * 8;
                        Ptr ptr20 = x;
                        int n42 = n41;
                        double d16 = ptr20.getDouble(n42);
                        if (d15 == d16) {
                            int n43 = i * 8;
                            Ptr ptr21 = ys;
                            int n44 = n43;
                            int n45 = last * 8;
                            Ptr ptr22 = ys;
                            int n46 = n45;
                            double d17 = ptr22.getDouble(n46);
                            ptr21.setDouble(n44, d17);
                            last = i;
                        }
                        ++i;
                    }
                    int n47 = i + -1;
                    i = Rmath.Rf_imax2((int)(last + 1), (int)n47);
                    if (last >= n) break;
                }
                i = 0;
                while (i < n) {
                    int n48 = i * 8;
                    Ptr ptr = res;
                    int n49 = n48;
                    int n50 = (i + 1) * 8;
                    Ptr ptr23 = y;
                    int n51 = n50;
                    double d = ptr23.getDouble(n51);
                    int n52 = (i + 1) * 8;
                    Ptr ptr24 = ys;
                    int n53 = n52;
                    double d18 = ptr24.getDouble(n53);
                    double d19 = d - d18;
                    ptr.setDouble(n49, d19);
                    ++i;
                }
                sc = 0.0;
                i = 0;
                while (i < n) {
                    int n54 = i * 8;
                    Ptr ptr = res;
                    int n55 = n54;
                    sc = Math.abs(ptr.getDouble(n55)) + sc;
                    ++i;
                }
                double d = n;
                sc /= d;
                if (iter > nsteps) break;
                i = 0;
                while (i < n) {
                    int n56 = i * 8;
                    Ptr ptr = rw;
                    int n57 = n56;
                    int n58 = i * 8;
                    Ptr ptr25 = res;
                    int n59 = n58;
                    double d20 = Math.abs(ptr25.getDouble(n59));
                    ptr.setDouble(n57, d20);
                    ++i;
                }
                int m1 = n / 2;
                sort.Rf_rPsort((Ptr)rw, (int)n, (int)m1);
                if ((n & 1) == 0) {
                    int m2 = n - m1 + -1;
                    sort.Rf_rPsort((Ptr)rw, (int)n, (int)m2);
                    int n60 = m1 * 8;
                    Ptr ptr = rw;
                    int n61 = n60;
                    double d21 = ptr.getDouble(n61);
                    int n62 = m2 * 8;
                    Ptr ptr26 = rw;
                    int n63 = n62;
                    double d22 = ptr26.getDouble(n63);
                    cmad = (d21 + d22) * 3.0;
                } else {
                    int n64 = m1 * 8;
                    Ptr ptr = rw;
                    int n65 = n64;
                    cmad = ptr.getDouble(n65) * 6.0;
                }
                if (sc * 1.0E-7 > cmad) break;
                c9 = cmad * 0.999;
                c1 = cmad * 0.001;
                i = 0;
                while (i < n) {
                    Ptr ptr = res;
                    int n66 = i * 8;
                    int n67 = n66;
                    double r = Math.abs(ptr.getDouble(n67));
                    if (r <= c1) {
                        int n68 = i * 8;
                        Ptr ptr27 = rw;
                        int n69 = n68;
                        ptr27.setDouble(n69, 1.0);
                    } else if (r <= c9) {
                        int n70 = i * 8;
                        Ptr ptr28 = rw;
                        int n71 = n70;
                        double d23 = lowess__.fsquare(r / cmad);
                        double d24 = lowess__.fsquare(1.0 - d23);
                        ptr28.setDouble(n71, d24);
                    } else {
                        int n72 = i * 8;
                        Ptr ptr29 = rw;
                        int n73 = n72;
                        ptr29.setDouble(n73, 0.0);
                    }
                    ++i;
                }
                ++iter;
            }
        }
    }

    public static double fsquare(double x) {
        double d = x;
        return d * d;
    }

    public static void lowest(Ptr x, Ptr y, int n, Ptr xs, Ptr ys, int nleft, int nright, Ptr w, int userw, Ptr rw, Ptr ok) {
        double range = 0.0;
        double h9 = 0.0;
        double h1 = 0.0;
        double h = 0.0;
        double b = 0.0;
        double a = 0.0;
        int nrt = 0;
        x = x.pointerPlus(-8);
        y = y.pointerPlus(-8);
        w = w.pointerPlus(-8);
        rw = rw.pointerPlus(-8);
        int n2 = n * 8;
        Ptr ptr = x;
        int n3 = n2;
        double d = ptr.getDouble(n3);
        double d2 = x.getDouble(8);
        range = d - d2;
        int n4 = nright * 8;
        Ptr ptr2 = x;
        int n5 = n4;
        double d3 = ptr2.getDouble(n5);
        double d4 = xs.getDouble();
        double d5 = d3 - d4;
        double d6 = xs.getDouble();
        int n6 = nleft * 8;
        Ptr ptr3 = x;
        int n7 = n6;
        double d7 = ptr3.getDouble(n7);
        h = Rmath.Rf_fmax2((double)(d6 - d7), (double)d5);
        h9 = h * 0.999;
        h1 = h * 0.001;
        a = 0.0;
        int j = nleft;
        while (j <= n) {
            int n8 = j * 8;
            Ptr ptr4 = w;
            int n9 = n8;
            ptr4.setDouble(n9, 0.0);
            int n10 = j * 8;
            Ptr ptr5 = x;
            int n11 = n10;
            double d8 = ptr5.getDouble(n11);
            double d9 = xs.getDouble();
            double r = Math.abs(d8 - d9);
            if (r <= h9) {
                if (r <= h1) {
                    int n12 = j * 8;
                    Ptr ptr6 = w;
                    int n13 = n12;
                    ptr6.setDouble(n13, 1.0);
                } else {
                    int n14 = j * 8;
                    Ptr ptr7 = w;
                    int n15 = n14;
                    double d10 = lowess__.fcube(r / h);
                    double d11 = lowess__.fcube(1.0 - d10);
                    ptr7.setDouble(n15, d11);
                }
                if (userw != 0) {
                    int n16 = j * 8;
                    Ptr ptr8 = w;
                    int n17 = n16;
                    int n18 = j * 8;
                    Ptr ptr9 = w;
                    int n19 = n18;
                    double d12 = ptr9.getDouble(n19);
                    int n20 = j * 8;
                    Ptr ptr10 = rw;
                    int n21 = n20;
                    double d13 = ptr10.getDouble(n21);
                    double d14 = d12 * d13;
                    ptr8.setDouble(n17, d14);
                }
                int n22 = j * 8;
                Ptr ptr11 = w;
                int n23 = n22;
                a = ptr11.getDouble(n23) + a;
            } else {
                double d15;
                Ptr ptr12 = x;
                int n24 = j * 8;
                int n25 = n24;
                double d16 = ptr12.getDouble(n25);
                if (d16 > (d15 = xs.getDouble())) break;
            }
            ++j;
        }
        nrt = j + -1;
        if (a <= 0.0) {
            ok.setInt(0);
        } else {
            ok.setInt(1);
            j = nleft;
            while (j <= nrt) {
                int n26 = j * 8;
                Ptr ptr13 = w;
                int n27 = n26;
                int n28 = j * 8;
                Ptr ptr14 = w;
                int n29 = n28;
                double d17 = ptr14.getDouble(n29) / a;
                ptr13.setDouble(n27, d17);
                ++j;
            }
            if (h > 0.0) {
                double d18;
                a = 0.0;
                j = nleft;
                while (j <= nrt) {
                    int n30 = j * 8;
                    Ptr ptr15 = w;
                    int n31 = n30;
                    double d19 = ptr15.getDouble(n31);
                    int n32 = j * 8;
                    Ptr ptr16 = x;
                    int n33 = n32;
                    double d20 = ptr16.getDouble(n33);
                    a = d19 * d20 + a;
                    ++j;
                }
                b = xs.getDouble() - a;
                double c = 0.0;
                j = nleft;
                while (j <= nrt) {
                    int n34 = j * 8;
                    Ptr ptr17 = w;
                    int n35 = n34;
                    double d21 = ptr17.getDouble(n35);
                    int n36 = j * 8;
                    Ptr ptr18 = x;
                    int n37 = n36;
                    double d22 = lowess__.fsquare(ptr18.getDouble(n37) - a);
                    c = d21 * d22 + c;
                    ++j;
                }
                double d23 = Mathlib.sqrt((double)c);
                if (d23 > (d18 = range * 0.001)) {
                    b /= c;
                    j = nleft;
                    while (j <= nrt) {
                        int n38 = j * 8;
                        Ptr ptr19 = w;
                        int n39 = n38;
                        int n40 = j * 8;
                        Ptr ptr20 = w;
                        int n41 = n40;
                        double d24 = ptr20.getDouble(n41);
                        int n42 = j * 8;
                        Ptr ptr21 = x;
                        int n43 = n42;
                        double d25 = (ptr21.getDouble(n43) - a) * b + 1.0;
                        double d26 = d24 * d25;
                        ptr19.setDouble(n39, d26);
                        ++j;
                    }
                }
            }
            ys.setDouble(0.0);
            j = nleft;
            while (j <= nrt) {
                double d27 = ys.getDouble();
                int n44 = j * 8;
                Ptr ptr22 = w;
                int n45 = n44;
                double d28 = ptr22.getDouble(n45);
                int n46 = j * 8;
                Ptr ptr23 = y;
                int n47 = n46;
                double d29 = ptr23.getDouble(n47);
                double d30 = d28 * d29;
                double d31 = d27 + d30;
                ys.setDouble(d31);
                ++j;
            }
        }
    }

    public static double fcube(double x) {
        double d = x;
        return d * d * x;
    }
}

