/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.utils;

import java.io.PrintWriter;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.utils.ColumnPrinter;

public class FactorPrinter
implements ColumnPrinter {
    private PrintWriter writer;
    private IntVector vector;
    private String naSymbol;
    private String[] levels;

    public FactorPrinter(PrintWriter writer, IntVector vector, boolean quote, String naSymbol) {
        this.writer = writer;
        this.vector = vector;
        this.naSymbol = naSymbol;
        this.levels = this.formatLevels(vector, quote);
    }

    private String[] formatLevels(IntVector vector, boolean quote) {
        SEXP attribute = vector.getAttribute(Symbols.LEVELS);
        if (!(attribute instanceof AtomicVector)) {
            throw new EvalException("Expected 'levels' attribute of type character", new Object[0]);
        }
        AtomicVector levelsVector = (AtomicVector)attribute;
        String[] levels = new String[levelsVector.length()];
        for (int i = 0; i != levelsVector.length(); ++i) {
            levels[i] = quote ? "\"" + levelsVector.getElementAsString(i) + "\"" : levelsVector.getElementAsString(i);
        }
        return levels;
    }

    @Override
    public void print(int index) {
        int valueIndex = this.vector.getElementAsInt(index);
        if (IntVector.isNA((int)valueIndex) || valueIndex > this.levels.length) {
            this.writer.write(this.naSymbol);
        } else {
            this.writer.write(this.levels[valueIndex - 1]);
        }
    }
}

