/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JLineNumberTableAttribute
extends JAttribute {
    protected final JCode code;
    protected int[] encoding;

    public JLineNumberTableAttribute(FJBGContext context2, JClass clazz2, JCode owner) {
        super(context2, clazz2);
        this.code = owner;
        assert (owner.getOwner().getOwner() == clazz2);
    }

    public JLineNumberTableAttribute(FJBGContext context2, JClass clazz2, Object owner, String name, int size2, DataInputStream stream) throws IOException {
        super(context2, clazz2, name);
        this.code = (JCode)owner;
        int[] mapping = new int[this.code.getSize()];
        int count2 = stream.readShort();
        for (int i = 0; i < count2; ++i) {
            short startPC = stream.readShort();
            short lineNum = stream.readShort();
            mapping[startPC] = lineNum;
        }
        assert (this.code.lineNumbers == null);
        this.code.lineNumbers = new int[0];
        int lineNum = 0;
        for (int pc = 0; pc < mapping.length; ++pc) {
            if (mapping[pc] != 0) {
                lineNum = mapping[pc];
            }
            if (lineNum == 0) continue;
            this.code.setLineNumber(pc, lineNum);
        }
        assert (name.equals(this.getName()));
    }

    public String getName() {
        return "LineNumberTable";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  LineNumberTable: ");
        int[] encoding = this.encode();
        for (int i = 0; i < encoding.length / 2; ++i) {
            buf.append("\n   line ");
            buf.append(encoding[i * 2 + 1]);
            buf.append(": ");
            buf.append(encoding[i * 2]);
        }
        buf.append("\n");
        return buf.toString();
    }

    protected int[] encode() {
        if (this.encoding == null) {
            int[] lineNumbers = this.code.getLineNumbers();
            int[] preEncoding = new int[lineNumbers.length * 2];
            int prevLineNum = 0;
            int i = 0;
            for (int pc = 0; pc < lineNumbers.length; ++pc) {
                int lineNum = lineNumbers[pc];
                if (!(lineNum != 0 & lineNum != prevLineNum)) continue;
                preEncoding[i++] = pc;
                preEncoding[i++] = lineNum;
                prevLineNum = lineNum;
            }
            if (i == preEncoding.length) {
                this.encoding = preEncoding;
            } else {
                this.encoding = new int[i];
                System.arraycopy(preEncoding, 0, this.encoding, 0, i);
            }
        }
        return this.encoding;
    }

    protected int getSize() {
        int[] encoding = this.encode();
        return 2 + encoding.length * 2;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        int[] encoding = this.encode();
        int entries = encoding.length / 2;
        stream.writeShort(entries);
        for (int i = 0; i < entries; ++i) {
            stream.writeShort(encoding[i * 2]);
            stream.writeShort(encoding[i * 2 + 1]);
        }
    }
}

