/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MojoUtils {
    static F passThrough = new F(){

        public String f(String in) {
            return in;
        }
    };

    private MojoUtils() {
    }

    static F fileRelativeTo(final File relative) {
        return new F(){

            public String f(String in) {
                File file = new File(relative, in);
                File parentDir = file.getParentFile();
                MojoUtils.createIfNotExists(parentDir);
                return file.getAbsolutePath();
            }
        };
    }

    static F dirRelativeTo(final File relative) {
        return new F(){

            public String f(String in) {
                File dir = new File(relative, in);
                MojoUtils.createIfNotExists(dir);
                return dir.getAbsolutePath();
            }
        };
    }

    private static void createIfNotExists(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Cannot create directory " + dir);
        }
    }

    static List<String> compoundArg(String name, String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        for (String commaSeparated : strings) {
            params.addAll(MojoUtils.splitOnComma(commaSeparated));
        }
        if (params.size() > 0) {
            list.add(name);
            String prefix = "";
            String a = "";
            for (String param : params) {
                a = a + prefix;
                a = a + param;
                prefix = " ";
            }
            list.add(a);
        }
        return list;
    }

    static List<String> suiteArg(String name, String commaSeparated) {
        ArrayList<String> list = new ArrayList<String>();
        for (String param : MojoUtils.splitOnComma(commaSeparated)) {
            list.add(name);
            list.add(param);
        }
        return list;
    }

    static List<String> reporterArg(String name, String commaSeparated, F map) {
        ArrayList<String> r = new ArrayList<String>();
        for (String arg : MojoUtils.splitOnComma(commaSeparated)) {
            String[] split = arg.split("\\s");
            if (split.length == 1) {
                r.add(name);
                r.add(map.f(split[0]));
                continue;
            }
            r.add(name + split[0]);
            r.add(map.f(split[1]));
        }
        return r;
    }

    static List<String> splitOnComma(String cs) {
        String[] split;
        ArrayList<String> args = new ArrayList<String>();
        if (cs == null) {
            return args;
        }
        for (String arg : split = cs.split(",")) {
            args.add(arg.trim());
        }
        return args;
    }

    static String[] concat(List<String> ... lists) {
        ArrayList<String> c = new ArrayList<String>();
        for (List<String> l : lists) {
            c.addAll(l);
        }
        return c.toArray(new String[c.size()]);
    }

    static interface F {
        public String f(String var1);
    }
}

