/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class LogEntry {
    private final Level level;
    private final long timestamp;
    private final String message;

    public LogEntry(Level level, long timestamp, String message) {
        this.level = level;
        this.timestamp = timestamp;
        this.message = message;
    }

    public Level getLevel() {
        return this.level;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.format("[%s] [%s] %s", DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(this.timestamp)), this.level, this.message);
    }

    public Map<String, Object> toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", this.timestamp);
        map.put("level", this.level);
        map.put("message", this.message);
        return map;
    }
}

