/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v125.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v125.network.model.Initiator;
import org.openqa.selenium.devtools.v125.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class WebSocketCreated {
    private final RequestId requestId;
    private final String url;
    private final Optional<Initiator> initiator;

    public WebSocketCreated(RequestId requestId, String url, Optional<Initiator> initiator) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.initiator = initiator;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<Initiator> getInitiator() {
        return this.initiator;
    }

    private static WebSocketCreated fromJson(JsonInput input) {
        RequestId requestId = null;
        String url = null;
        Optional<Initiator> initiator = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "url": {
                    url = input.nextString();
                    continue block10;
                }
                case "initiator": {
                    initiator = Optional.ofNullable((Initiator)input.read(Initiator.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebSocketCreated(requestId, url, initiator);
    }
}

