/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum CookieExclusionReason {
    EXCLUDESAMESITEUNSPECIFIEDTREATEDASLAX("ExcludeSameSiteUnspecifiedTreatedAsLax"),
    EXCLUDESAMESITENONEINSECURE("ExcludeSameSiteNoneInsecure"),
    EXCLUDESAMESITELAX("ExcludeSameSiteLax"),
    EXCLUDESAMESITESTRICT("ExcludeSameSiteStrict"),
    EXCLUDEINVALIDSAMEPARTY("ExcludeInvalidSameParty"),
    EXCLUDESAMEPARTYCROSSPARTYCONTEXT("ExcludeSamePartyCrossPartyContext"),
    EXCLUDEDOMAINNONASCII("ExcludeDomainNonASCII"),
    EXCLUDETHIRDPARTYCOOKIEBLOCKEDINFIRSTPARTYSET("ExcludeThirdPartyCookieBlockedInFirstPartySet"),
    EXCLUDETHIRDPARTYPHASEOUT("ExcludeThirdPartyPhaseout");

    private String value;

    private CookieExclusionReason(String value) {
        this.value = value;
    }

    public static CookieExclusionReason fromString(String s) {
        return Arrays.stream(CookieExclusionReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CookieExclusionReason "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CookieExclusionReason fromJson(JsonInput input) {
        return CookieExclusionReason.fromString(input.nextString());
    }
}

