/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.dom.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v128.dom.model.BackendNode;
import org.openqa.selenium.devtools.v128.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v128.dom.model.CompatibilityMode;
import org.openqa.selenium.devtools.v128.dom.model.NodeId;
import org.openqa.selenium.devtools.v128.dom.model.PseudoType;
import org.openqa.selenium.devtools.v128.dom.model.ShadowRootType;
import org.openqa.selenium.devtools.v128.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class Node {
    private final NodeId nodeId;
    private final Optional<NodeId> parentId;
    private final BackendNodeId backendNodeId;
    private final Integer nodeType;
    private final String nodeName;
    private final String localName;
    private final String nodeValue;
    private final Optional<Integer> childNodeCount;
    private final Optional<List<Node>> children;
    private final Optional<List<String>> attributes;
    private final Optional<String> documentURL;
    private final Optional<String> baseURL;
    private final Optional<String> publicId;
    private final Optional<String> systemId;
    private final Optional<String> internalSubset;
    private final Optional<String> xmlVersion;
    private final Optional<String> name;
    private final Optional<String> value;
    private final Optional<PseudoType> pseudoType;
    private final Optional<String> pseudoIdentifier;
    private final Optional<ShadowRootType> shadowRootType;
    private final Optional<FrameId> frameId;
    private final Optional<Node> contentDocument;
    private final Optional<List<Node>> shadowRoots;
    private final Optional<Node> templateContent;
    private final Optional<List<Node>> pseudoElements;
    private final Optional<Node> importedDocument;
    private final Optional<List<BackendNode>> distributedNodes;
    private final Optional<Boolean> isSVG;
    private final Optional<CompatibilityMode> compatibilityMode;
    private final Optional<BackendNode> assignedSlot;

    public Node(NodeId nodeId, Optional<NodeId> parentId, BackendNodeId backendNodeId, Integer nodeType, String nodeName, String localName, String nodeValue, Optional<Integer> childNodeCount, Optional<List<Node>> children, Optional<List<String>> attributes, Optional<String> documentURL, Optional<String> baseURL, Optional<String> publicId, Optional<String> systemId, Optional<String> internalSubset, Optional<String> xmlVersion, Optional<String> name, Optional<String> value, Optional<PseudoType> pseudoType, Optional<String> pseudoIdentifier, Optional<ShadowRootType> shadowRootType, Optional<FrameId> frameId, Optional<Node> contentDocument, Optional<List<Node>> shadowRoots, Optional<Node> templateContent, Optional<List<Node>> pseudoElements, Optional<Node> importedDocument, Optional<List<BackendNode>> distributedNodes, Optional<Boolean> isSVG, Optional<CompatibilityMode> compatibilityMode, Optional<BackendNode> assignedSlot) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.parentId = parentId;
        this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.nodeType = Objects.requireNonNull(nodeType, "nodeType is required");
        this.nodeName = Objects.requireNonNull(nodeName, "nodeName is required");
        this.localName = Objects.requireNonNull(localName, "localName is required");
        this.nodeValue = Objects.requireNonNull(nodeValue, "nodeValue is required");
        this.childNodeCount = childNodeCount;
        this.children = children;
        this.attributes = attributes;
        this.documentURL = documentURL;
        this.baseURL = baseURL;
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
        this.xmlVersion = xmlVersion;
        this.name = name;
        this.value = value;
        this.pseudoType = pseudoType;
        this.pseudoIdentifier = pseudoIdentifier;
        this.shadowRootType = shadowRootType;
        this.frameId = frameId;
        this.contentDocument = contentDocument;
        this.shadowRoots = shadowRoots;
        this.templateContent = templateContent;
        this.pseudoElements = pseudoElements;
        this.importedDocument = importedDocument;
        this.distributedNodes = distributedNodes;
        this.isSVG = isSVG;
        this.compatibilityMode = compatibilityMode;
        this.assignedSlot = assignedSlot;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Optional<NodeId> getParentId() {
        return this.parentId;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public Optional<Integer> getChildNodeCount() {
        return this.childNodeCount;
    }

    public Optional<List<Node>> getChildren() {
        return this.children;
    }

    public Optional<List<String>> getAttributes() {
        return this.attributes;
    }

    public Optional<String> getDocumentURL() {
        return this.documentURL;
    }

    public Optional<String> getBaseURL() {
        return this.baseURL;
    }

    public Optional<String> getPublicId() {
        return this.publicId;
    }

    public Optional<String> getSystemId() {
        return this.systemId;
    }

    public Optional<String> getInternalSubset() {
        return this.internalSubset;
    }

    public Optional<String> getXmlVersion() {
        return this.xmlVersion;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public Optional<PseudoType> getPseudoType() {
        return this.pseudoType;
    }

    public Optional<String> getPseudoIdentifier() {
        return this.pseudoIdentifier;
    }

    public Optional<ShadowRootType> getShadowRootType() {
        return this.shadowRootType;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    public Optional<Node> getContentDocument() {
        return this.contentDocument;
    }

    public Optional<List<Node>> getShadowRoots() {
        return this.shadowRoots;
    }

    public Optional<Node> getTemplateContent() {
        return this.templateContent;
    }

    public Optional<List<Node>> getPseudoElements() {
        return this.pseudoElements;
    }

    @Deprecated
    public Optional<Node> getImportedDocument() {
        return this.importedDocument;
    }

    public Optional<List<BackendNode>> getDistributedNodes() {
        return this.distributedNodes;
    }

    public Optional<Boolean> getIsSVG() {
        return this.isSVG;
    }

    public Optional<CompatibilityMode> getCompatibilityMode() {
        return this.compatibilityMode;
    }

    public Optional<BackendNode> getAssignedSlot() {
        return this.assignedSlot;
    }

    private static Node fromJson(JsonInput input) {
        NodeId nodeId = null;
        Optional<NodeId> parentId = Optional.empty();
        BackendNodeId backendNodeId = null;
        Integer nodeType = 0;
        String nodeName = null;
        String localName = null;
        String nodeValue = null;
        Optional<Integer> childNodeCount = Optional.empty();
        Optional<List<Node>> children = Optional.empty();
        Optional<List<String>> attributes = Optional.empty();
        Optional<String> documentURL = Optional.empty();
        Optional<String> baseURL = Optional.empty();
        Optional<String> publicId = Optional.empty();
        Optional<String> systemId = Optional.empty();
        Optional<String> internalSubset = Optional.empty();
        Optional<String> xmlVersion = Optional.empty();
        Optional<String> name = Optional.empty();
        Optional<String> value = Optional.empty();
        Optional<PseudoType> pseudoType = Optional.empty();
        Optional<String> pseudoIdentifier = Optional.empty();
        Optional<ShadowRootType> shadowRootType = Optional.empty();
        Optional<FrameId> frameId = Optional.empty();
        Optional<Node> contentDocument = Optional.empty();
        Optional<List<Node>> shadowRoots = Optional.empty();
        Optional<Node> templateContent = Optional.empty();
        Optional<List<Node>> pseudoElements = Optional.empty();
        Optional<Node> importedDocument = Optional.empty();
        Optional<List<BackendNode>> distributedNodes = Optional.empty();
        Optional<Boolean> isSVG = Optional.empty();
        Optional<CompatibilityMode> compatibilityMode = Optional.empty();
        Optional<BackendNode> assignedSlot = Optional.empty();
        input.beginObject();
        block66: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block66;
                }
                case "parentId": {
                    parentId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                    continue block66;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block66;
                }
                case "nodeType": {
                    nodeType = input.nextNumber().intValue();
                    continue block66;
                }
                case "nodeName": {
                    nodeName = input.nextString();
                    continue block66;
                }
                case "localName": {
                    localName = input.nextString();
                    continue block66;
                }
                case "nodeValue": {
                    nodeValue = input.nextString();
                    continue block66;
                }
                case "childNodeCount": {
                    childNodeCount = Optional.ofNullable(input.nextNumber().intValue());
                    continue block66;
                }
                case "children": {
                    children = Optional.ofNullable(input.readArray(Node.class));
                    continue block66;
                }
                case "attributes": {
                    attributes = Optional.ofNullable(input.readArray(String.class));
                    continue block66;
                }
                case "documentURL": {
                    documentURL = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "baseURL": {
                    baseURL = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "publicId": {
                    publicId = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "systemId": {
                    systemId = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "internalSubset": {
                    internalSubset = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "xmlVersion": {
                    xmlVersion = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "value": {
                    value = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "pseudoType": {
                    pseudoType = Optional.ofNullable((PseudoType)((Object)input.read(PseudoType.class)));
                    continue block66;
                }
                case "pseudoIdentifier": {
                    pseudoIdentifier = Optional.ofNullable(input.nextString());
                    continue block66;
                }
                case "shadowRootType": {
                    shadowRootType = Optional.ofNullable((ShadowRootType)((Object)input.read(ShadowRootType.class)));
                    continue block66;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block66;
                }
                case "contentDocument": {
                    contentDocument = Optional.ofNullable((Node)input.read(Node.class));
                    continue block66;
                }
                case "shadowRoots": {
                    shadowRoots = Optional.ofNullable(input.readArray(Node.class));
                    continue block66;
                }
                case "templateContent": {
                    templateContent = Optional.ofNullable((Node)input.read(Node.class));
                    continue block66;
                }
                case "pseudoElements": {
                    pseudoElements = Optional.ofNullable(input.readArray(Node.class));
                    continue block66;
                }
                case "importedDocument": {
                    importedDocument = Optional.ofNullable((Node)input.read(Node.class));
                    continue block66;
                }
                case "distributedNodes": {
                    distributedNodes = Optional.ofNullable(input.readArray(BackendNode.class));
                    continue block66;
                }
                case "isSVG": {
                    isSVG = Optional.ofNullable(input.nextBoolean());
                    continue block66;
                }
                case "compatibilityMode": {
                    compatibilityMode = Optional.ofNullable((CompatibilityMode)((Object)input.read(CompatibilityMode.class)));
                    continue block66;
                }
                case "assignedSlot": {
                    assignedSlot = Optional.ofNullable((BackendNode)input.read(BackendNode.class));
                    continue block66;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Node(nodeId, parentId, backendNodeId, nodeType, nodeName, localName, nodeValue, childNodeCount, children, attributes, documentURL, baseURL, publicId, systemId, internalSubset, xmlVersion, name, value, pseudoType, pseudoIdentifier, shadowRootType, frameId, contentDocument, shadowRoots, templateContent, pseudoElements, importedDocument, distributedNodes, isSVG, compatibilityMode, assignedSlot);
    }
}

