/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.input.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DragDataItem {
    private final String mimeType;
    private final String data;
    private final Optional<String> title;
    private final Optional<String> baseURL;

    public DragDataItem(String mimeType, String data, Optional<String> title, Optional<String> baseURL) {
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.data = Objects.requireNonNull(data, "data is required");
        this.title = title;
        this.baseURL = baseURL;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getData() {
        return this.data;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getBaseURL() {
        return this.baseURL;
    }

    private static DragDataItem fromJson(JsonInput input) {
        String mimeType = null;
        String data = null;
        Optional<String> title = Optional.empty();
        Optional<String> baseURL = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block12;
                }
                case "data": {
                    data = input.nextString();
                    continue block12;
                }
                case "title": {
                    title = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "baseURL": {
                    baseURL = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DragDataItem(mimeType, data, title, baseURL);
    }
}

