/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v130.debugger.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class SearchMatch {
    private final Number lineNumber;
    private final String lineContent;

    public SearchMatch(Number lineNumber, String lineContent) {
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.lineContent = Objects.requireNonNull(lineContent, "lineContent is required");
    }

    public Number getLineNumber() {
        return this.lineNumber;
    }

    public String getLineContent() {
        return this.lineContent;
    }

    private static SearchMatch fromJson(JsonInput input) {
        Number lineNumber = 0;
        String lineContent = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "lineNumber": {
                    lineNumber = input.nextNumber();
                    continue block8;
                }
                case "lineContent": {
                    lineContent = input.nextString();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SearchMatch(lineNumber, lineContent);
    }
}

