/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v135.network.model.CrossOriginEmbedderPolicyValue;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CrossOriginEmbedderPolicyStatus {
    private final CrossOriginEmbedderPolicyValue value;
    private final CrossOriginEmbedderPolicyValue reportOnlyValue;
    private final Optional<String> reportingEndpoint;
    private final Optional<String> reportOnlyReportingEndpoint;

    public CrossOriginEmbedderPolicyStatus(CrossOriginEmbedderPolicyValue value, CrossOriginEmbedderPolicyValue reportOnlyValue, Optional<String> reportingEndpoint, Optional<String> reportOnlyReportingEndpoint) {
        this.value = Objects.requireNonNull(value, "value is required");
        this.reportOnlyValue = Objects.requireNonNull(reportOnlyValue, "reportOnlyValue is required");
        this.reportingEndpoint = reportingEndpoint;
        this.reportOnlyReportingEndpoint = reportOnlyReportingEndpoint;
    }

    public CrossOriginEmbedderPolicyValue getValue() {
        return this.value;
    }

    public CrossOriginEmbedderPolicyValue getReportOnlyValue() {
        return this.reportOnlyValue;
    }

    public Optional<String> getReportingEndpoint() {
        return this.reportingEndpoint;
    }

    public Optional<String> getReportOnlyReportingEndpoint() {
        return this.reportOnlyReportingEndpoint;
    }

    private static CrossOriginEmbedderPolicyStatus fromJson(JsonInput input) {
        CrossOriginEmbedderPolicyValue value = null;
        CrossOriginEmbedderPolicyValue reportOnlyValue = null;
        Optional<String> reportingEndpoint = Optional.empty();
        Optional<String> reportOnlyReportingEndpoint = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "value": {
                    value = (CrossOriginEmbedderPolicyValue)((Object)input.read(CrossOriginEmbedderPolicyValue.class));
                    continue block12;
                }
                case "reportOnlyValue": {
                    reportOnlyValue = (CrossOriginEmbedderPolicyValue)((Object)input.read(CrossOriginEmbedderPolicyValue.class));
                    continue block12;
                }
                case "reportingEndpoint": {
                    reportingEndpoint = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "reportOnlyReportingEndpoint": {
                    reportOnlyReportingEndpoint = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CrossOriginEmbedderPolicyStatus(value, reportOnlyValue, reportingEndpoint, reportOnlyReportingEndpoint);
    }
}

