/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v135.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v135.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class WebSocketFrameError {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final String errorMessage;

    public WebSocketFrameError(RequestId requestId, MonotonicTime timestamp, String errorMessage) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private static WebSocketFrameError fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        String errorMessage = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block10;
                }
                case "errorMessage": {
                    errorMessage = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebSocketFrameError(requestId, timestamp, errorMessage);
    }
}

