/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.accessibility.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v136.accessibility.model.AXRelatedNode;
import org.openqa.selenium.devtools.v136.accessibility.model.AXValueSource;
import org.openqa.selenium.devtools.v136.accessibility.model.AXValueType;
import org.openqa.selenium.json.JsonInput;

public class AXValue {
    private final AXValueType type;
    private final Optional<Object> value;
    private final Optional<List<AXRelatedNode>> relatedNodes;
    private final Optional<List<AXValueSource>> sources;

    public AXValue(AXValueType type, Optional<Object> value, Optional<List<AXRelatedNode>> relatedNodes, Optional<List<AXValueSource>> sources) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.relatedNodes = relatedNodes;
        this.sources = sources;
    }

    public AXValueType getType() {
        return this.type;
    }

    public Optional<Object> getValue() {
        return this.value;
    }

    public Optional<List<AXRelatedNode>> getRelatedNodes() {
        return this.relatedNodes;
    }

    public Optional<List<AXValueSource>> getSources() {
        return this.sources;
    }

    private static AXValue fromJson(JsonInput input) {
        AXValueType type = null;
        Optional<Object> value = Optional.empty();
        Optional<List<AXRelatedNode>> relatedNodes = Optional.empty();
        Optional<List<AXValueSource>> sources = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (AXValueType)((Object)input.read(AXValueType.class));
                    continue block12;
                }
                case "value": {
                    value = Optional.ofNullable(input.read(Object.class));
                    continue block12;
                }
                case "relatedNodes": {
                    relatedNodes = Optional.ofNullable(input.readArray(AXRelatedNode.class));
                    continue block12;
                }
                case "sources": {
                    sources = Optional.ofNullable(input.readArray(AXValueSource.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXValue(type, value, relatedNodes, sources);
    }
}

