/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.autofill.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v136.autofill.model.FillingStrategy;
import org.openqa.selenium.devtools.v136.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v136.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class FilledField {
    private final String htmlType;
    private final String id;
    private final String name;
    private final String value;
    private final String autofillType;
    private final FillingStrategy fillingStrategy;
    private final FrameId frameId;
    private final BackendNodeId fieldId;

    public FilledField(String htmlType, String id, String name, String value, String autofillType, FillingStrategy fillingStrategy, FrameId frameId, BackendNodeId fieldId) {
        this.htmlType = Objects.requireNonNull(htmlType, "htmlType is required");
        this.id = Objects.requireNonNull(id, "id is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.autofillType = Objects.requireNonNull(autofillType, "autofillType is required");
        this.fillingStrategy = Objects.requireNonNull(fillingStrategy, "fillingStrategy is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.fieldId = Objects.requireNonNull(fieldId, "fieldId is required");
    }

    public String getHtmlType() {
        return this.htmlType;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getAutofillType() {
        return this.autofillType;
    }

    public FillingStrategy getFillingStrategy() {
        return this.fillingStrategy;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public BackendNodeId getFieldId() {
        return this.fieldId;
    }

    private static FilledField fromJson(JsonInput input) {
        String htmlType = null;
        String id = null;
        String name = null;
        String value = null;
        String autofillType = null;
        FillingStrategy fillingStrategy = null;
        FrameId frameId = null;
        BackendNodeId fieldId = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "htmlType": {
                    htmlType = input.nextString();
                    continue block20;
                }
                case "id": {
                    id = input.nextString();
                    continue block20;
                }
                case "name": {
                    name = input.nextString();
                    continue block20;
                }
                case "value": {
                    value = input.nextString();
                    continue block20;
                }
                case "autofillType": {
                    autofillType = input.nextString();
                    continue block20;
                }
                case "fillingStrategy": {
                    fillingStrategy = (FillingStrategy)((Object)input.read(FillingStrategy.class));
                    continue block20;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block20;
                }
                case "fieldId": {
                    fieldId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FilledField(htmlType, id, name, value, autofillType, fillingStrategy, frameId, fieldId);
    }
}

