/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v136.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class FailedRequestInfo {
    private final String url;
    private final String failureMessage;
    private final Optional<RequestId> requestId;

    public FailedRequestInfo(String url, String failureMessage, Optional<RequestId> requestId) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.failureMessage = Objects.requireNonNull(failureMessage, "failureMessage is required");
        this.requestId = requestId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public Optional<RequestId> getRequestId() {
        return this.requestId;
    }

    private static FailedRequestInfo fromJson(JsonInput input) {
        String url = null;
        String failureMessage = null;
        Optional<RequestId> requestId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block10;
                }
                case "failureMessage": {
                    failureMessage = input.nextString();
                    continue block10;
                }
                case "requestId": {
                    requestId = Optional.ofNullable((RequestId)input.read(RequestId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FailedRequestInfo(url, failureMessage, requestId);
    }
}

