/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.audits.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v136.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v136.audits.model.SRIMessageSignatureError;
import org.openqa.selenium.json.JsonInput;

public class SRIMessageSignatureIssueDetails {
    private final SRIMessageSignatureError error;
    private final String signatureBase;
    private final List<String> integrityAssertions;
    private final AffectedRequest request;

    public SRIMessageSignatureIssueDetails(SRIMessageSignatureError error, String signatureBase, List<String> integrityAssertions, AffectedRequest request) {
        this.error = Objects.requireNonNull(error, "error is required");
        this.signatureBase = Objects.requireNonNull(signatureBase, "signatureBase is required");
        this.integrityAssertions = Objects.requireNonNull(integrityAssertions, "integrityAssertions is required");
        this.request = Objects.requireNonNull(request, "request is required");
    }

    public SRIMessageSignatureError getError() {
        return this.error;
    }

    public String getSignatureBase() {
        return this.signatureBase;
    }

    public List<String> getIntegrityAssertions() {
        return this.integrityAssertions;
    }

    public AffectedRequest getRequest() {
        return this.request;
    }

    private static SRIMessageSignatureIssueDetails fromJson(JsonInput input) {
        SRIMessageSignatureError error = null;
        String signatureBase = null;
        List integrityAssertions = null;
        AffectedRequest request = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "error": {
                    error = (SRIMessageSignatureError)((Object)input.read(SRIMessageSignatureError.class));
                    continue block12;
                }
                case "signatureBase": {
                    signatureBase = input.nextString();
                    continue block12;
                }
                case "integrityAssertions": {
                    integrityAssertions = input.readArray(String.class);
                    continue block12;
                }
                case "request": {
                    request = (AffectedRequest)input.read(AffectedRequest.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SRIMessageSignatureIssueDetails(error, signatureBase, integrityAssertions, request);
    }
}

