/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ServiceWorkerRouterSource {
    NETWORK("network"),
    CACHE("cache"),
    FETCH_EVENT("fetch-event"),
    RACE_NETWORK_AND_FETCH_HANDLER("race-network-and-fetch-handler");

    private String value;

    private ServiceWorkerRouterSource(String value) {
        this.value = value;
    }

    public static ServiceWorkerRouterSource fromString(String s) {
        return Arrays.stream(ServiceWorkerRouterSource.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ServiceWorkerRouterSource "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ServiceWorkerRouterSource fromJson(JsonInput input) {
        return ServiceWorkerRouterSource.fromString(input.nextString());
    }
}

