/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.page.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v136.network.model.LoaderId;
import org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredExplanation;
import org.openqa.selenium.devtools.v136.page.model.BackForwardCacheNotRestoredExplanationTree;
import org.openqa.selenium.devtools.v136.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class BackForwardCacheNotUsed {
    private final LoaderId loaderId;
    private final FrameId frameId;
    private final List<BackForwardCacheNotRestoredExplanation> notRestoredExplanations;
    private final Optional<BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree;

    public BackForwardCacheNotUsed(LoaderId loaderId, FrameId frameId, List<BackForwardCacheNotRestoredExplanation> notRestoredExplanations, Optional<BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree) {
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.notRestoredExplanations = Objects.requireNonNull(notRestoredExplanations, "notRestoredExplanations is required");
        this.notRestoredExplanationsTree = notRestoredExplanationsTree;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public List<BackForwardCacheNotRestoredExplanation> getNotRestoredExplanations() {
        return this.notRestoredExplanations;
    }

    public Optional<BackForwardCacheNotRestoredExplanationTree> getNotRestoredExplanationsTree() {
        return this.notRestoredExplanationsTree;
    }

    private static BackForwardCacheNotUsed fromJson(JsonInput input) {
        LoaderId loaderId = null;
        FrameId frameId = null;
        List notRestoredExplanations = null;
        Optional<BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block12;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block12;
                }
                case "notRestoredExplanations": {
                    notRestoredExplanations = input.readArray(BackForwardCacheNotRestoredExplanation.class);
                    continue block12;
                }
                case "notRestoredExplanationsTree": {
                    notRestoredExplanationsTree = Optional.ofNullable((BackForwardCacheNotRestoredExplanationTree)input.read(BackForwardCacheNotRestoredExplanationTree.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BackForwardCacheNotUsed(loaderId, frameId, notRestoredExplanations, notRestoredExplanationsTree);
    }
}

