/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.webauthn.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class Credential {
    private final String credentialId;
    private final Boolean isResidentCredential;
    private final Optional<String> rpId;
    private final String privateKey;
    private final Optional<String> userHandle;
    private final Integer signCount;
    private final Optional<String> largeBlob;
    private final Optional<Boolean> backupEligibility;
    private final Optional<Boolean> backupState;
    private final Optional<String> userName;
    private final Optional<String> userDisplayName;

    public Credential(String credentialId, Boolean isResidentCredential, Optional<String> rpId, String privateKey, Optional<String> userHandle, Integer signCount, Optional<String> largeBlob, Optional<Boolean> backupEligibility, Optional<Boolean> backupState, Optional<String> userName, Optional<String> userDisplayName) {
        this.credentialId = Objects.requireNonNull(credentialId, "credentialId is required");
        this.isResidentCredential = Objects.requireNonNull(isResidentCredential, "isResidentCredential is required");
        this.rpId = rpId;
        this.privateKey = Objects.requireNonNull(privateKey, "privateKey is required");
        this.userHandle = userHandle;
        this.signCount = Objects.requireNonNull(signCount, "signCount is required");
        this.largeBlob = largeBlob;
        this.backupEligibility = backupEligibility;
        this.backupState = backupState;
        this.userName = userName;
        this.userDisplayName = userDisplayName;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public Boolean getIsResidentCredential() {
        return this.isResidentCredential;
    }

    public Optional<String> getRpId() {
        return this.rpId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Optional<String> getUserHandle() {
        return this.userHandle;
    }

    public Integer getSignCount() {
        return this.signCount;
    }

    public Optional<String> getLargeBlob() {
        return this.largeBlob;
    }

    public Optional<Boolean> getBackupEligibility() {
        return this.backupEligibility;
    }

    public Optional<Boolean> getBackupState() {
        return this.backupState;
    }

    public Optional<String> getUserName() {
        return this.userName;
    }

    public Optional<String> getUserDisplayName() {
        return this.userDisplayName;
    }

    private static Credential fromJson(JsonInput input) {
        String credentialId = null;
        Boolean isResidentCredential = false;
        Optional<String> rpId = Optional.empty();
        String privateKey = null;
        Optional<String> userHandle = Optional.empty();
        Integer signCount = 0;
        Optional<String> largeBlob = Optional.empty();
        Optional<Boolean> backupEligibility = Optional.empty();
        Optional<Boolean> backupState = Optional.empty();
        Optional<String> userName = Optional.empty();
        Optional<String> userDisplayName = Optional.empty();
        input.beginObject();
        block26: while (input.hasNext()) {
            switch (input.nextName()) {
                case "credentialId": {
                    credentialId = input.nextString();
                    continue block26;
                }
                case "isResidentCredential": {
                    isResidentCredential = input.nextBoolean();
                    continue block26;
                }
                case "rpId": {
                    rpId = Optional.ofNullable(input.nextString());
                    continue block26;
                }
                case "privateKey": {
                    privateKey = input.nextString();
                    continue block26;
                }
                case "userHandle": {
                    userHandle = Optional.ofNullable(input.nextString());
                    continue block26;
                }
                case "signCount": {
                    signCount = input.nextNumber().intValue();
                    continue block26;
                }
                case "largeBlob": {
                    largeBlob = Optional.ofNullable(input.nextString());
                    continue block26;
                }
                case "backupEligibility": {
                    backupEligibility = Optional.ofNullable(input.nextBoolean());
                    continue block26;
                }
                case "backupState": {
                    backupState = Optional.ofNullable(input.nextBoolean());
                    continue block26;
                }
                case "userName": {
                    userName = Optional.ofNullable(input.nextString());
                    continue block26;
                }
                case "userDisplayName": {
                    userDisplayName = Optional.ofNullable(input.nextString());
                    continue block26;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Credential(credentialId, isResidentCredential, rpId, privateKey, userHandle, signCount, largeBlob, backupEligibility, backupState, userName, userDisplayName);
    }
}

