/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.css.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v142.css.model.CSSContainerQuery;
import org.openqa.selenium.devtools.v142.css.model.CSSFunctionNode;
import org.openqa.selenium.devtools.v142.css.model.CSSMedia;
import org.openqa.selenium.devtools.v142.css.model.CSSSupports;
import org.openqa.selenium.json.JsonInput;

public class CSSFunctionConditionNode {
    private final Optional<CSSMedia> media;
    private final Optional<CSSContainerQuery> containerQueries;
    private final Optional<CSSSupports> supports;
    private final List<CSSFunctionNode> children;
    private final String conditionText;

    public CSSFunctionConditionNode(Optional<CSSMedia> media, Optional<CSSContainerQuery> containerQueries, Optional<CSSSupports> supports, List<CSSFunctionNode> children, String conditionText) {
        this.media = media;
        this.containerQueries = containerQueries;
        this.supports = supports;
        this.children = Objects.requireNonNull(children, "children is required");
        this.conditionText = Objects.requireNonNull(conditionText, "conditionText is required");
    }

    public Optional<CSSMedia> getMedia() {
        return this.media;
    }

    public Optional<CSSContainerQuery> getContainerQueries() {
        return this.containerQueries;
    }

    public Optional<CSSSupports> getSupports() {
        return this.supports;
    }

    public List<CSSFunctionNode> getChildren() {
        return this.children;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    private static CSSFunctionConditionNode fromJson(JsonInput input) {
        Optional<CSSMedia> media = Optional.empty();
        Optional<CSSContainerQuery> containerQueries = Optional.empty();
        Optional<CSSSupports> supports = Optional.empty();
        List children = null;
        String conditionText = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "media": {
                    media = Optional.ofNullable((CSSMedia)input.read(CSSMedia.class));
                    continue block14;
                }
                case "containerQueries": {
                    containerQueries = Optional.ofNullable((CSSContainerQuery)input.read(CSSContainerQuery.class));
                    continue block14;
                }
                case "supports": {
                    supports = Optional.ofNullable((CSSSupports)input.read(CSSSupports.class));
                    continue block14;
                }
                case "children": {
                    children = input.readArray(CSSFunctionNode.class);
                    continue block14;
                }
                case "conditionText": {
                    conditionText = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSFunctionConditionNode(media, containerQueries, supports, children, conditionText);
    }
}

