/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics;

import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.FailureAnalysisReporter;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.support.SpringFactoriesLoader;

public final class FailureAnalyzers {
    private FailureAnalyzers() {
    }

    public static boolean analyzeAndReport(Throwable failure, ClassLoader classLoader, ConfigurableApplicationContext context) {
        List analyzers = SpringFactoriesLoader.loadFactories(FailureAnalyzer.class, (ClassLoader)classLoader);
        List reporters = SpringFactoriesLoader.loadFactories(FailureAnalysisReporter.class, (ClassLoader)classLoader);
        FailureAnalysis analysis = FailureAnalyzers.analyze(failure, analyzers, context);
        return FailureAnalyzers.report(analysis, reporters);
    }

    private static FailureAnalysis analyze(Throwable failure, List<FailureAnalyzer> analyzers, ConfigurableApplicationContext context) {
        for (FailureAnalyzer analyzer : analyzers) {
            FailureAnalyzers.prepareAnalyzer(context, analyzer);
            FailureAnalysis analysis = analyzer.analyze(failure);
            if (analysis == null) continue;
            return analysis;
        }
        return null;
    }

    private static void prepareAnalyzer(ConfigurableApplicationContext context, FailureAnalyzer analyzer) {
        if (analyzer instanceof BeanFactoryAware) {
            ((BeanFactoryAware)analyzer).setBeanFactory((BeanFactory)context.getBeanFactory());
        }
    }

    private static boolean report(FailureAnalysis analysis, List<FailureAnalysisReporter> reporters) {
        if (analysis == null || reporters.isEmpty()) {
            return false;
        }
        for (FailureAnalysisReporter reporter : reporters) {
            reporter.report(analysis);
        }
        return true;
    }
}

