/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonUnwrapped;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

@XmlRootElement
public class Resource<T>
extends ResourceSupport {
    @JsonUnwrapped
    @com.fasterxml.jackson.annotation.JsonUnwrapped
    private final T content;

    Resource() {
        this.content = null;
    }

    public Resource(T content, Link ... links) {
        this(content, Arrays.asList(links));
    }

    public Resource(T content, Iterable<Link> links) {
        Assert.notNull(content, (String)"Content must not be null!");
        this.content = content;
        this.add(links);
    }

    public T getContent() {
        return this.content;
    }

    @Override
    public String toString() {
        return String.format("Resource { content: %s, %s }", this.getContent(), super.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Resource that = (Resource)obj;
        boolean contentEqual = this.content == null ? that.content == null : this.content.equals(that.content);
        return contentEqual ? super.equals(obj) : false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.content == null ? 0 : 17 * this.content.hashCode();
    }
}

