/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.LinkBuilderBeanDefinitionRegistrar;
import org.springframework.hateoas.core.AnnotationRelProvider;
import org.springframework.hateoas.core.DefaultLinkDiscoverer;
import org.springframework.hateoas.core.DefaultRelProvider;
import org.springframework.hateoas.core.DelegatingRelProvider;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.hateoas.hal.HalLinkDiscoverer;
import org.springframework.hateoas.hal.Jackson1HalModule;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

class HypermediaSupportBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String LINK_DISCOVERER_BEAN_NAME = "_linkDiscoverer";
    private static final String DELEGATING_REL_PROVIDER_BEAN_NAME = "_relProvider";
    private static final boolean JACKSON1_PRESENT = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", null);
    private static final boolean JACKSON2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null);
    private static final boolean JSONPATH_PRESENT = ClassUtils.isPresent((String)"com.jayway.jsonpath.JsonPath", null);
    private static final boolean EVO_PRESENT = ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null);
    private final ImportBeanDefinitionRegistrar linkBuilderBeanDefinitionRegistrar = new LinkBuilderBeanDefinitionRegistrar();

    HypermediaSupportBeanDefinitionRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.linkBuilderBeanDefinitionRegistrar.registerBeanDefinitions(importingClassMetadata, registry);
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableHypermediaSupport.class.getName());
        EnableHypermediaSupport.HypermediaType type = (EnableHypermediaSupport.HypermediaType)((Object)attributes.get("type"));
        if (JSONPATH_PRESENT) {
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)this.getLinkDiscovererBeanDefinition(type), LINK_DISCOVERER_BEAN_NAME), (BeanDefinitionRegistry)registry);
        }
        if (type == EnableHypermediaSupport.HypermediaType.HAL) {
            if (JACKSON2_PRESENT) {
                BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)new RootBeanDefinition(Jackson2ModuleRegisteringBeanPostProcessor.class), (BeanDefinitionRegistry)registry);
            }
            if (JACKSON1_PRESENT) {
                BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)new RootBeanDefinition(Jackson1ModuleRegisteringBeanPostProcessor.class), (BeanDefinitionRegistry)registry);
            }
        }
        HypermediaSupportBeanDefinitionRegistrar.registerRelProviderPluginRegistryAndDelegate(registry);
    }

    private static void registerRelProviderPluginRegistryAndDelegate(BeanDefinitionRegistry registry) {
        Class defaultRelProviderType = EVO_PRESENT ? EvoInflectorRelProvider.class : DefaultRelProvider.class;
        RootBeanDefinition defaultRelProviderBeanDefinition = new RootBeanDefinition(defaultRelProviderType);
        registry.registerBeanDefinition("defaultRelProvider", (BeanDefinition)defaultRelProviderBeanDefinition);
        RootBeanDefinition annotationRelProviderBeanDefinition = new RootBeanDefinition(AnnotationRelProvider.class);
        registry.registerBeanDefinition("annotationRelProvider", (BeanDefinition)annotationRelProviderBeanDefinition);
        BeanDefinitionBuilder registryFactoryBeanBuilder = BeanDefinitionBuilder.rootBeanDefinition(PluginRegistryFactoryBean.class);
        registryFactoryBeanBuilder.addPropertyValue("type", RelProvider.class);
        registryFactoryBeanBuilder.addPropertyValue("exclusions", DelegatingRelProvider.class);
        AbstractBeanDefinition registryBeanDefinition = registryFactoryBeanBuilder.getBeanDefinition();
        registry.registerBeanDefinition("relProviderPluginRegistry", (BeanDefinition)registryBeanDefinition);
        BeanDefinitionBuilder delegateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DelegatingRelProvider.class);
        delegateBuilder.addConstructorArgValue((Object)registryBeanDefinition);
        AbstractBeanDefinition beanDefinition = delegateBuilder.getBeanDefinition();
        beanDefinition.setPrimary(true);
        registry.registerBeanDefinition(DELEGATING_REL_PROVIDER_BEAN_NAME, (BeanDefinition)beanDefinition);
    }

    private AbstractBeanDefinition getLinkDiscovererBeanDefinition(EnableHypermediaSupport.HypermediaType type) {
        RootBeanDefinition definition;
        switch (type) {
            case HAL: {
                definition = new RootBeanDefinition(HalLinkDiscoverer.class);
                break;
            }
            default: {
                definition = new RootBeanDefinition(DefaultLinkDiscoverer.class);
            }
        }
        definition.setSource((Object)this);
        return definition;
    }

    private static class Jackson1ModuleRegisteringBeanPostProcessor
    implements BeanPostProcessor,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        private Jackson1ModuleRegisteringBeanPostProcessor() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof AnnotationMethodHandlerAdapter) {
                this.registerModule(((AnnotationMethodHandlerAdapter)bean).getMessageConverters());
            }
            if (bean instanceof RequestMappingHandlerAdapter) {
                this.registerModule(((RequestMappingHandlerAdapter)bean).getMessageConverters());
            }
            if (bean instanceof org.codehaus.jackson.map.ObjectMapper) {
                this.registerModule(bean);
            }
            return bean;
        }

        private void registerModule(List<HttpMessageConverter<?>> converters) {
            for (HttpMessageConverter<?> converter : converters) {
                if (!(converter instanceof MappingJacksonHttpMessageConverter)) continue;
                this.registerModule(((MappingJacksonHttpMessageConverter)converter).getObjectMapper());
            }
        }

        private void registerModule(Object objectMapper) {
            RelProvider relProvider = (RelProvider)this.beanFactory.getBean(HypermediaSupportBeanDefinitionRegistrar.DELEGATING_REL_PROVIDER_BEAN_NAME, RelProvider.class);
            org.codehaus.jackson.map.ObjectMapper mapper = (org.codehaus.jackson.map.ObjectMapper)objectMapper;
            mapper.registerModule((org.codehaus.jackson.map.Module)new Jackson1HalModule());
            mapper.setHandlerInstantiator((org.codehaus.jackson.map.HandlerInstantiator)new Jackson1HalModule.HalHandlerInstantiator(relProvider));
        }
    }

    private static class Jackson2ModuleRegisteringBeanPostProcessor
    implements BeanPostProcessor,
    BeanFactoryAware {
        private BeanFactory factory;

        private Jackson2ModuleRegisteringBeanPostProcessor() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.factory = beanFactory;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof RequestMappingHandlerAdapter) {
                this.registerModule(((RequestMappingHandlerAdapter)bean).getMessageConverters());
            }
            if (bean instanceof AnnotationMethodHandlerAdapter) {
                this.registerModule(((AnnotationMethodHandlerAdapter)bean).getMessageConverters());
            }
            if (bean instanceof ObjectMapper) {
                this.registerModule(bean);
            }
            return bean;
        }

        private void registerModule(List<HttpMessageConverter<?>> converters) {
            for (HttpMessageConverter<?> converter : converters) {
                if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
                this.registerModule(((MappingJackson2HttpMessageConverter)converter).getObjectMapper());
            }
        }

        private void registerModule(Object objectMapper) {
            RelProvider provider = (RelProvider)this.factory.getBean(HypermediaSupportBeanDefinitionRegistrar.DELEGATING_REL_PROVIDER_BEAN_NAME, RelProvider.class);
            ObjectMapper mapper = (ObjectMapper)objectMapper;
            mapper.registerModule((Module)new Jackson2HalModule());
            mapper.setHandlerInstantiator((HandlerInstantiator)new Jackson2HalModule.HalHandlerInstantiator(provider));
        }
    }
}

