/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public class DelegatingJwtGrantedAuthoritiesConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private final Collection<Converter<Jwt, Collection<GrantedAuthority>>> authoritiesConverters;

    public DelegatingJwtGrantedAuthoritiesConverter(Collection<Converter<Jwt, Collection<GrantedAuthority>>> authoritiesConverters) {
        Assert.notNull(authoritiesConverters, (String)"authoritiesConverters cannot be null");
        this.authoritiesConverters = new ArrayList<Converter<Jwt, Collection<GrantedAuthority>>>(authoritiesConverters);
    }

    @SafeVarargs
    public DelegatingJwtGrantedAuthoritiesConverter(Converter<Jwt, Collection<GrantedAuthority>> ... authoritiesConverters) {
        this(Arrays.asList(authoritiesConverters));
    }

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        LinkedHashSet<GrantedAuthority> result = new LinkedHashSet<GrantedAuthority>();
        for (Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter : this.authoritiesConverters) {
            Collection authorities = (Collection)authoritiesConverter.convert((Object)jwt);
            if (authorities == null) continue;
            result.addAll(authorities);
        }
        return result;
    }
}

