/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.springframework.core.MethodParameter;
import org.springframework.lang.UsesJava8;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.DeferredResultAdapter;

public class DeferredResultMethodReturnValueHandler
implements AsyncHandlerMethodReturnValueHandler {
    private final Map<Class<?>, DeferredResultAdapter> adapterMap = new HashMap(5);

    public DeferredResultMethodReturnValueHandler() {
        this.adapterMap.put(DeferredResult.class, new SimpleDeferredResultAdapter());
        this.adapterMap.put(ListenableFuture.class, new ListenableFutureAdapter());
        if (ClassUtils.isPresent((String)"java.util.concurrent.CompletionStage", (ClassLoader)this.getClass().getClassLoader())) {
            this.adapterMap.put(CompletionStage.class, new CompletionStageAdapter());
        }
    }

    public Map<Class<?>, DeferredResultAdapter> getAdapterMap() {
        return this.adapterMap;
    }

    private DeferredResultAdapter getAdapterFor(Class<?> type) {
        for (Class<?> adapteeType : this.getAdapterMap().keySet()) {
            if (!adapteeType.isAssignableFrom(type)) continue;
            return this.getAdapterMap().get(adapteeType);
        }
        return null;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getAdapterFor(returnType.getParameterType()) != null;
    }

    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        return returnValue != null && this.getAdapterFor(returnValue.getClass()) != null;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        DeferredResultAdapter adapter = this.getAdapterFor(returnValue.getClass());
        if (adapter == null) {
            throw new IllegalStateException("Could not find DeferredResultAdapter for return value type: " + returnValue.getClass());
        }
        DeferredResult<?> result = adapter.adaptToDeferredResult(returnValue);
        WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startDeferredResultProcessing(result, new Object[]{mavContainer});
    }

    @UsesJava8
    private static class CompletionStageAdapter
    implements DeferredResultAdapter {
        private CompletionStageAdapter() {
        }

        @Override
        public DeferredResult<?> adaptToDeferredResult(Object returnValue) {
            Assert.isInstanceOf(CompletionStage.class, (Object)returnValue, (String)"CompletionStage expected");
            final DeferredResult result = new DeferredResult();
            CompletionStage future = (CompletionStage)returnValue;
            future.handle(new BiFunction<Object, Throwable, Object>(){

                @Override
                public Object apply(Object value, Throwable ex) {
                    if (ex != null) {
                        result.setErrorResult((Object)ex);
                    } else {
                        result.setResult(value);
                    }
                    return null;
                }
            });
            return result;
        }
    }

    private static class ListenableFutureAdapter
    implements DeferredResultAdapter {
        private ListenableFutureAdapter() {
        }

        @Override
        public DeferredResult<?> adaptToDeferredResult(Object returnValue) {
            Assert.isInstanceOf(ListenableFuture.class, (Object)returnValue, (String)"ListenableFuture expected");
            final DeferredResult result = new DeferredResult();
            ((ListenableFuture)returnValue).addCallback((ListenableFutureCallback)new ListenableFutureCallback<Object>(){

                public void onSuccess(Object value) {
                    result.setResult(value);
                }

                public void onFailure(Throwable ex) {
                    result.setErrorResult((Object)ex);
                }
            });
            return result;
        }
    }

    private static class SimpleDeferredResultAdapter
    implements DeferredResultAdapter {
        private SimpleDeferredResultAdapter() {
        }

        @Override
        public DeferredResult<?> adaptToDeferredResult(Object returnValue) {
            Assert.isInstanceOf(DeferredResult.class, (Object)returnValue, (String)"DeferredResult expected");
            return (DeferredResult)returnValue;
        }
    }
}

