/*
 * Decompiled with CFR 0.152.
 */
package tachyon.underfs.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import tachyon.conf.TachyonConf;
import tachyon.underfs.UnderFileSystem;
import tachyon.util.io.FileUtils;
import tachyon.util.io.PathUtils;
import tachyon.util.network.NetworkAddressUtils;

public class LocalUnderFileSystem
extends UnderFileSystem {
    public LocalUnderFileSystem(TachyonConf conf) {
        super(conf);
    }

    public UnderFileSystem.UnderFSType getUnderFSType() {
        return UnderFileSystem.UnderFSType.LOCAL;
    }

    public void close() throws IOException {
    }

    public OutputStream create(String path) throws IOException {
        FileOutputStream stream = new FileOutputStream(path);
        try {
            this.setPermission(path, "777");
        }
        catch (IOException e) {
            stream.close();
            throw e;
        }
        return stream;
    }

    public OutputStream create(String path, int blockSizeByte) throws IOException {
        return this.create(path, (short)1, blockSizeByte);
    }

    public OutputStream create(String path, short replication, int blockSizeByte) throws IOException {
        if (replication != 1) {
            throw new IOException("UnderFileSystemSingleLocal does not provide more than one replication factor");
        }
        return this.create(path);
    }

    public boolean delete(String path, boolean recursive) throws IOException {
        File file = new File(path);
        boolean success = true;
        if (recursive && file.isDirectory()) {
            String[] files;
            for (String child : files = file.list()) {
                success = success && this.delete(PathUtils.concatPath((Object)path, (Object[])new Object[]{child}), true);
            }
        }
        return success && file.delete();
    }

    public boolean exists(String path) throws IOException {
        File file = new File(path);
        return file.exists();
    }

    public long getBlockSizeByte(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        return 0x80000000L;
    }

    public Object getConf() {
        return null;
    }

    public List<String> getFileLocations(String path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_RPC, (TachyonConf)this.mTachyonConf));
        return ret;
    }

    public List<String> getFileLocations(String path, long offset) throws IOException {
        return this.getFileLocations(path);
    }

    public long getFileSize(String path) throws IOException {
        File file = new File(path);
        return file.length();
    }

    public long getModificationTimeMs(String path) throws IOException {
        File file = new File(path);
        return file.lastModified();
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        File file = new File(path);
        switch (type) {
            case SPACE_TOTAL: {
                return file.getTotalSpace();
            }
            case SPACE_FREE: {
                return file.getFreeSpace();
            }
            case SPACE_USED: {
                return file.getTotalSpace() - file.getFreeSpace();
            }
        }
        throw new IOException("Unknown getSpace parameter: " + type);
    }

    public boolean isFile(String path) throws IOException {
        File file = new File(path);
        return file.isFile();
    }

    public String[] list(String path) throws IOException {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files != null) {
            String[] rtn = new String[files.length];
            int i = 0;
            for (File f : files) {
                rtn[i++] = f.getName();
            }
            return rtn;
        }
        return null;
    }

    public boolean mkdirs(String path, boolean createParent) throws IOException {
        File file = new File(path);
        boolean created = createParent ? file.mkdirs() : file.mkdir();
        this.setPermission(path, "777");
        FileUtils.setLocalDirStickyBit((String)path);
        return created;
    }

    public InputStream open(String path) throws IOException {
        return new FileInputStream(path);
    }

    public boolean rename(String src, String dst) throws IOException {
        File file = new File(src);
        return file.renameTo(new File(dst));
    }

    public void setConf(Object conf) {
    }

    public void setPermission(String path, String posixPerm) throws IOException {
        FileUtils.changeLocalFilePermission((String)path, (String)posixPerm);
    }

    public void connectFromMaster(TachyonConf conf, String hostname) throws IOException {
    }

    public void connectFromWorker(TachyonConf conf, String hostname) throws IOException {
    }
}

