/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.multi.event;

import tachyon.org.jets3t.service.model.StorageObject;
import tachyon.org.jets3t.service.multi.ThreadWatcher;
import tachyon.org.jets3t.service.multi.event.ServiceEvent;

public class GetObjectHeadsEvent
extends ServiceEvent {
    private StorageObject[] objects = null;

    private GetObjectHeadsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static GetObjectHeadsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static GetObjectHeadsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static GetObjectHeadsEvent newInProgressEvent(ThreadWatcher threadWatcher, StorageObject[] completedObjects, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static GetObjectHeadsEvent newCompletedEvent(Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(2, uniqueOperationId);
        return event;
    }

    public static GetObjectHeadsEvent newCancelledEvent(StorageObject[] incompletedObjects, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static GetObjectHeadsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(StorageObject[] objects) {
        this.objects = objects;
    }

    public StorageObject[] getCompletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

