/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.spi.LoggingEvent;
import tachyon.LazyFileOutputStream;
import tachyon.util.CommonUtils;

public class Log4jFileAppender
extends FileAppender {
    private int mMaxBackupIndex = 1;
    private int mMaxFileSizeBytes = 0x100000;
    private int mCurrentFileBackupIndex = -1;
    private int mDeletionPercentage = 10;
    private String mCurrentFileName = "";
    private String mOriginalFileName = "";
    private String mLastDate = "";

    public void activateOptions() {
        if (this.fileName != null) {
            if (!this.fileName.equals(this.mCurrentFileName)) {
                this.mOriginalFileName = this.fileName;
            } else {
                this.fileName = this.mOriginalFileName;
            }
            try {
                this.fileName = this.getNewLogFileName(this.fileName);
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
            }
            catch (Exception e) {
                this.errorHandler.error("Error while activating log options", e, 4);
            }
        }
    }

    private String getNewLogFileName(String fileName) {
        if (!fileName.isEmpty()) {
            String newFileName = "";
            String address = "";
            try {
                address = "@" + InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                address = "@UnknownHost";
            }
            newFileName = fileName + address + "_" + CommonUtils.convertMsToSimpleDate(System.currentTimeMillis());
            File file = new File(newFileName);
            if (file.exists()) {
                this.rotateLogs(newFileName);
            }
            this.mLastDate = CommonUtils.convertMsToSimpleDate(System.currentTimeMillis());
            this.mCurrentFileName = newFileName;
            return newFileName;
        }
        throw new RuntimeException("Log4j configuration error, null filepath");
    }

    private void rotateLogs(String fileName) {
        if (this.mCurrentFileBackupIndex == -1) {
            int lo = 0;
            int hi = this.mMaxBackupIndex;
            while (lo <= hi) {
                int mid = lo + (hi - lo) / 2;
                if (mid == 0) {
                    this.mCurrentFileBackupIndex = 1;
                    break;
                }
                if (new File(fileName + "_" + mid).exists()) {
                    if (new File(fileName + "_" + (mid + 1)).exists()) {
                        lo = mid;
                        continue;
                    }
                    this.mCurrentFileBackupIndex = mid + 1;
                    break;
                }
                if (new File(fileName + "_" + (mid - 1)).exists()) {
                    this.mCurrentFileBackupIndex = mid;
                    break;
                }
                hi = mid;
            }
        }
        File oldFile = new File(fileName);
        if (this.mCurrentFileBackupIndex >= this.mMaxBackupIndex) {
            int i;
            int deleteToIndex = (int)Math.ceil((double)(this.mMaxBackupIndex * this.mDeletionPercentage) / 100.0);
            for (i = 1; i < deleteToIndex; ++i) {
                new File(fileName + "_" + i).delete();
            }
            for (i = deleteToIndex + 1; i <= this.mMaxBackupIndex; ++i) {
                new File(fileName + "_" + i).renameTo(new File(fileName + "_" + (i - deleteToIndex)));
            }
            this.mCurrentFileBackupIndex -= deleteToIndex;
        }
        oldFile.renameTo(new File(fileName + "_" + this.mCurrentFileBackupIndex));
        ++this.mCurrentFileBackupIndex;
    }

    public void setDeletionPercentage(int deletionPercentage) {
        if (deletionPercentage <= 0 || deletionPercentage > 100) {
            throw new RuntimeException("Log4j configuration error, invalid deletionPercentage");
        }
        this.mDeletionPercentage = deletionPercentage;
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        if (bufferedIO) {
            this.setImmediateFlush(false);
        }
        this.reset();
        LazyFileOutputStream ostream = new LazyFileOutputStream(fileName, append);
        Writer fw = this.createWriter(ostream);
        if (bufferedIO) {
            fw = new BufferedWriter(fw, bufferSize);
        }
        this.setQWForFiles(fw);
        this.fileName = fileName;
        this.fileAppend = append;
        this.bufferedIO = bufferedIO;
        this.bufferSize = bufferSize;
        this.writeHeader();
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.mMaxBackupIndex = maxBackups;
    }

    public void setMaxFileSize(int maxFileSizeMB) {
        this.mMaxFileSizeBytes = maxFileSizeMB * 0x100000;
    }

    public synchronized void subAppend(LoggingEvent event) {
        File currentLog = new File(this.mCurrentFileName);
        if (currentLog.length() > (long)this.mMaxFileSizeBytes || !CommonUtils.convertMsToSimpleDate(System.currentTimeMillis()).equals(this.mLastDate)) {
            this.activateOptions();
        }
        if (currentLog.exists()) {
            super.subAppend(event);
        } else {
            String parentName = currentLog.getParent();
            if (parentName != null) {
                File parent = new File(parentName);
                if (parent.exists()) {
                    super.subAppend(event);
                } else if (parent.mkdirs()) {
                    super.subAppend(event);
                }
            }
        }
    }
}

