/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.conf.CommonConf;
import tachyon.hadoop.Utils;
import tachyon.util.CommonUtils;

public class UnderFileSystemHdfs
extends UnderFileSystem {
    private static final int MAX_TRY = 5;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private FileSystem mFs = null;
    private String mUfsPrefix = null;
    private static final FsPermission PERMISSION = new FsPermission(511).applyUMask(FsPermission.createImmutable((short)0));

    public static UnderFileSystemHdfs getClient(String path) {
        return new UnderFileSystemHdfs(path, null);
    }

    public static UnderFileSystemHdfs getClient(String path, Object conf) {
        return new UnderFileSystemHdfs(path, conf);
    }

    private UnderFileSystemHdfs(String fsDefaultName, Object conf) {
        try {
            this.mUfsPrefix = fsDefaultName;
            Configuration tConf = null;
            tConf = conf != null ? (Configuration)conf : new Configuration();
            tConf.set("fs.defaultFS", fsDefaultName);
            String glusterfsPrefix = "glusterfs:///";
            if (fsDefaultName.startsWith(glusterfsPrefix)) {
                tConf.set("fs.glusterfs.impl", CommonConf.get().UNDERFS_GLUSTERFS_IMPL);
                tConf.set("mapred.system.dir", CommonConf.get().UNDERFS_GLUSTERFS_MR_DIR);
                tConf.set("fs.glusterfs.volumes", CommonConf.get().UNDERFS_GLUSTERFS_VOLUMES);
                tConf.set("fs.glusterfs.volume.fuse." + CommonConf.get().UNDERFS_GLUSTERFS_VOLUMES, CommonConf.get().UNDERFS_GLUSTERFS_MOUNTS);
            } else {
                tConf.set("fs.hdfs.impl", CommonConf.get().UNDERFS_HDFS_IMPL);
                tConf.set("fs.hdfs.impl.disable.cache", System.getProperty("fs.hdfs.impl.disable.cache", "false"));
            }
            Utils.addS3Credentials(tConf);
            Path path = new Path(this.mUfsPrefix);
            this.mFs = path.getFileSystem(tConf);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.mFs.close();
    }

    public FSDataOutputStream create(String path) throws IOException {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                this.LOG.debug((Object)("Creating HDFS file at " + path));
                return FileSystem.create((FileSystem)this.mFs, (Path)new Path(path), (FsPermission)PERMISSION);
            }
            catch (IOException e) {
                this.LOG.error((Object)(++cnt + " : " + e.getMessage()), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    public FSDataOutputStream create(String path, int blockSizeByte) throws IOException {
        return this.create(path);
    }

    public FSDataOutputStream create(String path, short replication, int blockSizeByte) throws IOException {
        return this.create(path);
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        this.LOG.debug((Object)("deleting " + path + " " + recursive));
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                return this.mFs.delete(new Path(path), recursive);
            }
            catch (IOException e) {
                this.LOG.error((Object)(++cnt + " : " + e.getMessage()), (Throwable)e);
                te = e;
            }
        }
        throw te;
    }

    @Override
    public boolean exists(String path) {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                return this.mFs.exists(new Path(path));
            }
            catch (IOException e) {
                this.LOG.error((Object)(++cnt + " : " + e.getMessage()), (Throwable)e);
                te = e;
            }
        }
        CommonUtils.runtimeException(te);
        return false;
    }

    @Override
    public long getBlockSizeByte(String path) throws IOException {
        Path tPath = new Path(path);
        if (!this.mFs.exists(tPath)) {
            throw new FileNotFoundException(path);
        }
        FileStatus fs = this.mFs.getFileStatus(tPath);
        return fs.getBlockSize();
    }

    @Override
    public Object getConf() {
        return this.mFs.getConf();
    }

    @Override
    public List<String> getFileLocations(String path) {
        return this.getFileLocations(path, 0L);
    }

    @Override
    public List<String> getFileLocations(String path, long offset) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            FileStatus fStatus = this.mFs.getFileStatus(new Path(path));
            BlockLocation[] bLocations = this.mFs.getFileBlockLocations(fStatus, offset, 1L);
            if (bLocations.length > 0) {
                String[] hosts = bLocations[0].getHosts();
                Collections.addAll(ret, hosts);
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
        }
        return ret;
    }

    @Override
    public long getFileSize(String path) {
        int cnt = 0;
        Path tPath = new Path(path);
        while (cnt < 5) {
            try {
                FileStatus fs = this.mFs.getFileStatus(tPath);
                return fs.getLen();
            }
            catch (IOException e) {
                this.LOG.error((Object)(++cnt + " : " + e.getMessage()), (Throwable)e);
            }
        }
        return -1L;
    }

    @Override
    public long getModificationTimeMs(String path) throws IOException {
        Path tPath = new Path(path);
        if (!this.mFs.exists(tPath)) {
            throw new FileNotFoundException(path);
        }
        FileStatus fs = this.mFs.getFileStatus(tPath);
        return fs.getModificationTime();
    }

    @Override
    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        if (this.mFs instanceof DistributedFileSystem) {
            switch (type) {
                case SPACE_TOTAL: {
                    return ((DistributedFileSystem)this.mFs).getDiskStatus().getCapacity();
                }
                case SPACE_USED: {
                    return ((DistributedFileSystem)this.mFs).getDiskStatus().getDfsUsed();
                }
                case SPACE_FREE: {
                    return ((DistributedFileSystem)this.mFs).getDiskStatus().getRemaining();
                }
            }
        }
        return -1L;
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.mFs.isFile(new Path(path));
    }

    @Override
    public String[] list(String path) throws IOException {
        FileStatus[] files = this.mFs.listStatus(new Path(path));
        if (files != null) {
            String[] rtn = new String[files.length];
            int i = 0;
            for (FileStatus status : files) {
                rtn[i++] = status.getPath().toString().substring(path.length());
            }
            return rtn;
        }
        return null;
    }

    @Override
    public boolean mkdirs(String path, boolean createParent) {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                if (this.mFs.exists(new Path(path))) {
                    return false;
                }
                return this.mFs.mkdirs(new Path(path), PERMISSION);
            }
            catch (IOException e) {
                this.LOG.error((Object)(++cnt + " : " + e.getMessage()), (Throwable)e);
                te = e;
            }
        }
        CommonUtils.runtimeException(te);
        return false;
    }

    public FSDataInputStream open(String path) {
        IOException te = null;
        int cnt = 0;
        while (cnt < 5) {
            try {
                return this.mFs.open(new Path(path));
            }
            catch (IOException e) {
                this.LOG.error((Object)(++cnt + " : " + e.getMessage()), (Throwable)e);
                te = e;
            }
        }
        CommonUtils.runtimeException(te);
        return null;
    }

    @Override
    public boolean rename(String src, String dst) {
        IOException te = null;
        int cnt = 0;
        this.LOG.debug((Object)("Renaming from " + src + " to " + dst));
        if (!this.exists(src)) {
            this.LOG.error((Object)("File " + src + " does not exist. Therefore rename to " + dst + " failed."));
        }
        if (this.exists(dst)) {
            this.LOG.error((Object)("File " + dst + " does exist. Therefore rename from " + src + " failed."));
        }
        while (cnt < 5) {
            try {
                return this.mFs.rename(new Path(src), new Path(dst));
            }
            catch (IOException e) {
                this.LOG.error((Object)(++cnt + " : " + e.getMessage()), (Throwable)e);
                te = e;
            }
        }
        CommonUtils.runtimeException(te);
        return false;
    }

    @Override
    public void setConf(Object conf) {
        this.mFs.setConf((Configuration)conf);
    }

    @Override
    public void setPermission(String path, String posixPerm) throws IOException {
        try {
            FileStatus fileStatus = this.mFs.getFileStatus(new Path(path));
            this.LOG.info((Object)("Changing file '" + fileStatus.getPath() + "' permissions from: " + fileStatus.getPermission() + " to " + posixPerm));
            FsPermission perm = new FsPermission(Short.parseShort(posixPerm));
            this.mFs.setPermission(fileStatus.getPath(), perm);
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
        }
    }
}

