/*
 * Decompiled with CFR 0.152.
 */
package tachyon.command;

import java.io.IOException;
import tachyon.conf.CommonConf;
import tachyon.util.CommonUtils;

public class Utils {
    public static String getFilePath(String path) throws IOException {
        if ((path = Utils.validatePath(path)).startsWith("tachyon://")) {
            path = path.substring("tachyon://".length());
        } else if (path.startsWith("tachyon-ft://")) {
            path = path.substring("tachyon-ft://".length());
        }
        String ret = path.substring(path.indexOf("/"));
        return ret;
    }

    public static String validatePath(String path) throws IOException {
        if (path.startsWith("tachyon://") || path.startsWith("tachyon-ft://")) {
            if (!path.contains(":")) {
                throw new IOException("Invalid Path: " + path + ". Use " + "tachyon://" + "host:port/ ," + "tachyon-ft://" + "host:port/" + " , or /file");
            }
            return path;
        }
        String HOSTNAME = System.getProperty("tachyon.master.hostname", "localhost");
        String PORT = System.getProperty("tachyon.master.port", "19998");
        if (CommonConf.get().USE_ZOOKEEPER) {
            return CommonUtils.concat("tachyon-ft://" + HOSTNAME + ":" + PORT, path);
        }
        return CommonUtils.concat("tachyon://" + HOSTNAME + ":" + PORT, path);
    }
}

