/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import tachyon.conf.Utils;
import tachyon.util.CommonUtils;

public class WorkerConf
extends Utils {
    private static WorkerConf WORKER_CONF = null;
    public final String MASTER_HOSTNAME = WorkerConf.getProperty("tachyon.master.hostname", "localhost");
    public final int MASTER_PORT = WorkerConf.getIntProperty("tachyon.master.port", 19998);
    public final int PORT = WorkerConf.getIntProperty("tachyon.worker.port", 29998);
    public final int DATA_PORT = WorkerConf.getIntProperty("tachyon.worker.data.port", 29999);
    public final String DATA_FOLDER = WorkerConf.getProperty("tachyon.worker.data.folder", "/mnt/ramdisk");
    public final long MEMORY_SIZE = CommonUtils.parseSpaceSize(WorkerConf.getProperty("tachyon.worker.memory.size", "134217728"));
    public final long HEARTBEAT_TIMEOUT_MS = WorkerConf.getIntProperty("tachyon.worker.heartbeat.timeout.ms", 10000);
    public final int TO_MASTER_HEARTBEAT_INTERVAL_MS = WorkerConf.getIntProperty("tachyon.worker.to.master.heartbeat.interval.ms", 1000);
    public final int SELECTOR_THREADS = WorkerConf.getIntProperty("tachyon.worker.selector.threads", 3);
    public final int QUEUE_SIZE_PER_SELECTOR = WorkerConf.getIntProperty("tachyon.worker.queue.size.per.selector", 3000);
    public final int SERVER_THREADS = WorkerConf.getIntProperty("tachyon.worker.server.threads", 128);
    public final int USER_TIMEOUT_MS = WorkerConf.getIntProperty("tachyon.worker.user.timeout.ms", 10000);
    public final String USER_TEMP_RELATIVE_FOLDER = "users";
    public final int WORKER_CHECKPOINT_THREADS = WorkerConf.getIntProperty("tachyon.worker.checkpoint.threads", 1);
    public final int WORKER_PER_THREAD_CHECKPOINT_CAP_MB_SEC = WorkerConf.getIntProperty("tachyon.worker.per.thread.checkpoint.cap.mb.sec", 1000);

    public static synchronized void clear() {
        WORKER_CONF = null;
    }

    public static synchronized WorkerConf get() {
        if (WORKER_CONF == null) {
            WORKER_CONF = new WorkerConf();
        }
        return WORKER_CONF;
    }

    private WorkerConf() {
    }
}

