/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.PrefixList;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.CommonConf;
import tachyon.hadoop.HdfsFileInputStream;
import tachyon.hadoop.Utils;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;
import tachyon.util.UnderfsUtils;

public class TFS
extends FileSystem {
    public static final String FIRST_COM_PATH = "tachyon_dep/";
    public static final String RECOMPUTE_PATH = "tachyon_recompute/";
    public static String UNDERFS_ADDRESS;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private URI mUri = null;
    private Path mWorkingDir = new Path("/");
    private TachyonFS mTFS = null;
    private String mTachyonHeader = null;

    public FSDataOutputStream append(Path cPath, int bufferSize, Progressable progress) throws IOException {
        this.LOG.info((Object)("append(" + cPath + ", " + bufferSize + ", " + progress + ")"));
        String path = Utils.getPathWithoutScheme(cPath);
        this.fromHdfsToTachyon(path);
        int fileId = this.mTFS.getFileId(path);
        TachyonFile file = this.mTFS.getFile(fileId);
        if (file.length() > 0L) {
            this.LOG.warn((Object)"This maybe an error.");
        }
        return new FSDataOutputStream((OutputStream)file.getOutStream(WriteType.CACHE_THROUGH), null);
    }

    public FSDataOutputStream create(Path cPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        int fileId;
        this.LOG.info((Object)("create(" + cPath + ", " + permission + ", " + overwrite + ", " + bufferSize + ", " + replication + ", " + blockSize + ", " + progress + ")"));
        if (!CommonConf.get().ASYNC_ENABLED) {
            String path = Utils.getPathWithoutScheme(cPath);
            if (this.mTFS.exist(path) && !this.mTFS.delete(path, false)) {
                throw new IOException("Failed to delete existing data " + cPath);
            }
            int fileId2 = this.mTFS.createFile(path, blockSize);
            TachyonFile file = this.mTFS.getFile(fileId2);
            file.setUFSConf(this.getConf());
            return new FSDataOutputStream((OutputStream)file.getOutStream(WriteType.CACHE_THROUGH), null);
        }
        if (cPath.toString().contains(FIRST_COM_PATH) && !cPath.toString().contains("SUCCESS")) {
            String path = Utils.getPathWithoutScheme(cPath);
            this.mTFS.createFile(path, blockSize);
            path = path.substring(path.indexOf(FIRST_COM_PATH) + FIRST_COM_PATH.length());
            path = path.substring(0, path.indexOf("/"));
            int depId = Integer.parseInt(path);
            this.LOG.info((Object)("create(" + cPath + ") : " + path + " " + depId));
            path = Utils.getPathWithoutScheme(cPath);
            path = path.substring(path.indexOf("part-") + 5);
            int index = Integer.parseInt(path);
            ClientDependencyInfo info = this.mTFS.getClientDependencyInfo(depId);
            int fileId3 = info.getChildren().get(index);
            this.LOG.info((Object)("create(" + cPath + ") : " + path + " " + index + " " + info + " " + fileId3));
            TachyonFile file = this.mTFS.getFile(fileId3);
            file.setUFSConf(this.getConf());
            return new FSDataOutputStream((OutputStream)file.getOutStream(WriteType.ASYNC_THROUGH), null);
        }
        if (cPath.toString().contains(RECOMPUTE_PATH) && !cPath.toString().contains("SUCCESS")) {
            String path = Utils.getPathWithoutScheme(cPath);
            this.mTFS.createFile(path, blockSize);
            path = path.substring(path.indexOf(RECOMPUTE_PATH) + RECOMPUTE_PATH.length());
            path = path.substring(0, path.indexOf("/"));
            int depId = Integer.parseInt(path);
            this.LOG.info((Object)("create(" + cPath + ") : " + path + " " + depId));
            path = Utils.getPathWithoutScheme(cPath);
            path = path.substring(path.indexOf("part-") + 5);
            int index = Integer.parseInt(path);
            ClientDependencyInfo info = this.mTFS.getClientDependencyInfo(depId);
            int fileId4 = info.getChildren().get(index);
            this.LOG.info((Object)("create(" + cPath + ") : " + path + " " + index + " " + info + " " + fileId4));
            TachyonFile file = this.mTFS.getFile(fileId4);
            file.setUFSConf(this.getConf());
            return new FSDataOutputStream((OutputStream)file.getOutStream(WriteType.ASYNC_THROUGH), null);
        }
        String path = Utils.getPathWithoutScheme(cPath);
        WriteType type = WriteType.CACHE_THROUGH;
        if (this.mTFS.exist(path)) {
            fileId = this.mTFS.getFileId(path);
            type = WriteType.MUST_CACHE;
        } else {
            fileId = this.mTFS.createFile(path, blockSize);
        }
        TachyonFile file = this.mTFS.getFile(fileId);
        file.setUFSConf(this.getConf());
        return new FSDataOutputStream((OutputStream)file.getOutStream(type), null);
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        this.LOG.info((Object)("delete(" + path + ", " + recursive + ")"));
        String tPath = Utils.getPathWithoutScheme(path);
        this.fromHdfsToTachyon(tPath);
        return this.mTFS.delete(tPath, recursive);
    }

    private void fromHdfsToTachyon(String path) throws IOException {
        Path hdfsPath;
        FileSystem fs;
        if (!this.mTFS.exist(path) && (fs = (hdfsPath = Utils.getHDFSPath(path)).getFileSystem(this.getConf())).exists(hdfsPath)) {
            String ufsAddrPath = CommonUtils.concat(UNDERFS_ADDRESS, path);
            UnderfsUtils.loadUnderFs(this.mTFS, path, ufsAddrPath, new PrefixList(null));
        }
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        String path = Utils.getPathWithoutScheme(file.getPath());
        this.fromHdfsToTachyon(path);
        int fileId = this.mTFS.getFileId(path);
        if (fileId == -1) {
            throw new FileNotFoundException("File does not exist: " + file.getPath());
        }
        ArrayList<BlockLocation> blockLocations = new ArrayList<BlockLocation>();
        List<ClientBlockInfo> blocks = this.mTFS.getFileBlocks(fileId);
        for (int k = 0; k < blocks.size(); ++k) {
            ClientBlockInfo info = blocks.get(k);
            long offset = info.getOffset();
            long end = offset + info.getLength();
            if ((offset < start || offset > start + len) && (end < start || end > start + len)) continue;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> hosts = new ArrayList<String>();
            for (NetAddress addr : info.getLocations()) {
                names.add(addr.mHost);
                hosts.add(addr.mHost);
            }
            blockLocations.add(new BlockLocation(CommonUtils.toStringArray(names), CommonUtils.toStringArray(hosts), offset, info.getLength()));
        }
        BlockLocation[] ret = new BlockLocation[blockLocations.size()];
        for (int k = 0; k < blockLocations.size(); ++k) {
            ret[k] = (BlockLocation)blockLocations.get(k);
        }
        return ret;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        String tPath = Utils.getPathWithoutScheme(path);
        Path hdfsPath = Utils.getHDFSPath(tPath);
        this.LOG.info((Object)("getFileStatus(" + path + "): HDFS Path: " + hdfsPath + " TPath: " + this.mTachyonHeader + tPath));
        this.fromHdfsToTachyon(tPath);
        TachyonFile file = this.mTFS.getFile(tPath);
        if (file == null) {
            this.LOG.info((Object)("File does not exist: " + path));
            throw new FileNotFoundException("File does not exist: " + path);
        }
        FileStatus ret = new FileStatus(file.length(), file.isDirectory(), file.getDiskReplication(), file.getBlockSizeByte(), file.getCreationTimeMs(), file.getCreationTimeMs(), null, null, null, new Path(this.mTachyonHeader + tPath));
        return ret;
    }

    public TachyonFS getTachyonFS() {
        return this.mTFS;
    }

    public URI getUri() {
        return this.mUri;
    }

    public Path getWorkingDirectory() {
        this.LOG.info((Object)("getWorkingDirectory: " + this.mWorkingDir));
        return this.mWorkingDir;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.LOG.info((Object)("initialize(" + uri + ", " + conf + "). Connecting to Tachyon: " + uri.toString()));
        Utils.addS3Credentials(conf);
        this.setConf(conf);
        this.mTachyonHeader = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
        this.mTFS = TachyonFS.get(this.mTachyonHeader);
        this.mUri = URI.create(this.mTachyonHeader);
        UNDERFS_ADDRESS = this.mTFS.getUnderfsAddress();
        this.LOG.info((Object)(this.mTachyonHeader + " " + this.mUri + " " + UNDERFS_ADDRESS));
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        String tPath = Utils.getPathWithoutScheme(path);
        Path hdfsPath = Utils.getHDFSPath(tPath);
        this.LOG.info((Object)("listStatus(" + path + "): HDFS Path: " + hdfsPath));
        this.fromHdfsToTachyon(tPath);
        if (!this.mTFS.exist(tPath)) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        List<ClientFileInfo> files = this.mTFS.listStatus(tPath);
        FileStatus[] ret = new FileStatus[files.size()];
        for (int k = 0; k < files.size(); ++k) {
            ClientFileInfo info = files.get(k);
            ret[k] = new FileStatus(info.getLength(), info.isFolder, 3, info.getBlockSizeByte(), info.getCreationTimeMs(), info.getCreationTimeMs(), null, null, null, new Path(this.mTachyonHeader + info.getPath()));
        }
        return ret;
    }

    public boolean mkdirs(Path cPath, FsPermission permission) throws IOException {
        this.LOG.info((Object)("mkdirs(" + cPath + ", " + permission + ")"));
        return this.mTFS.mkdir(Utils.getPathWithoutScheme(cPath));
    }

    public FSDataInputStream open(Path cPath, int bufferSize) throws IOException {
        this.LOG.info((Object)("open(" + cPath + ", " + bufferSize + ")"));
        String path = Utils.getPathWithoutScheme(cPath);
        this.fromHdfsToTachyon(path);
        int fileId = this.mTFS.getFileId(path);
        return new FSDataInputStream((InputStream)new HdfsFileInputStream(this.mTFS, fileId, Utils.getHDFSPath(path), this.getConf(), bufferSize));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.LOG.info((Object)("rename(" + src + ", " + dst + ")"));
        String hSrc = Utils.getPathWithoutScheme(src);
        String hDst = Utils.getPathWithoutScheme(dst);
        this.fromHdfsToTachyon(hSrc);
        return this.mTFS.rename(hSrc, hDst);
    }

    public void setWorkingDirectory(Path path) {
        this.LOG.info((Object)("setWorkingDirectory(" + path + ")"));
        this.mWorkingDir = path.isAbsolute() ? path : new Path(this.mWorkingDir, path);
    }
}

