/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.conf.MasterConf;
import tachyon.io.Utils;
import tachyon.master.DependencyType;
import tachyon.master.DependencyVariables;
import tachyon.master.ImageElement;
import tachyon.master.ImageElementType;
import tachyon.master.ImageWriter;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.util.CommonUtils;

public class Dependency
extends ImageWriter {
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    public final int ID;
    public final long CREATION_TIME_MS;
    public final List<Integer> PARENT_FILES;
    public final List<Integer> CHILDREN_FILES;
    private final Set<Integer> UNCHECKPOINTED_CHILDREN_FILES;
    public final String COMMAND_PREFIX;
    public final List<ByteBuffer> DATA;
    public final String COMMENT;
    public final String FRAMEWORK;
    public final String FRAMEWORK_VERSION;
    public final DependencyType TYPE;
    public final List<Integer> PARENT_DEPENDENCIES;
    private List<Integer> mChildrenDependencies;
    private Set<Integer> mLostFileIds;

    static Dependency loadImage(ImageElement ele) throws IOException {
        Dependency dep = new Dependency(ele.getInt("depID"), (List)ele.get("parentFiles"), (List)ele.get("childrenFiles"), ele.getString("commandPrefix"), ele.getByteBufferList("data"), ele.getString("comment"), ele.getString("framework"), ele.getString("frameworkVersion"), (DependencyType)((Object)ele.get("dependencyType")), (Collection)ele.get("parentDeps"), ele.getLong("creationTimeMs"));
        dep.resetUncheckpointedChildrenFiles((Collection)ele.get("unCheckpointedChildrenFiles"));
        return dep;
    }

    public Dependency(int id, List<Integer> parents, List<Integer> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType type, Collection<Integer> parentDependencies, long creationTimeMs) {
        this.ID = id;
        this.CREATION_TIME_MS = creationTimeMs;
        this.PARENT_FILES = new ArrayList<Integer>(parents.size());
        this.PARENT_FILES.addAll(parents);
        this.CHILDREN_FILES = new ArrayList<Integer>(children.size());
        this.CHILDREN_FILES.addAll(children);
        this.UNCHECKPOINTED_CHILDREN_FILES = new HashSet<Integer>();
        this.UNCHECKPOINTED_CHILDREN_FILES.addAll(this.CHILDREN_FILES);
        this.COMMAND_PREFIX = commandPrefix;
        this.DATA = CommonUtils.cloneByteBufferList(data);
        this.COMMENT = comment;
        this.FRAMEWORK = framework;
        this.FRAMEWORK_VERSION = frameworkVersion;
        this.TYPE = type;
        this.PARENT_DEPENDENCIES = new ArrayList<Integer>(parentDependencies.size());
        this.PARENT_DEPENDENCIES.addAll(parentDependencies);
        this.mChildrenDependencies = new ArrayList<Integer>(0);
        this.mLostFileIds = new HashSet<Integer>(0);
    }

    public synchronized void addChildrenDependency(int childDependencyId) {
        for (int dependencyId : this.mChildrenDependencies) {
            if (dependencyId != childDependencyId) continue;
            return;
        }
        this.mChildrenDependencies.add(childDependencyId);
    }

    public synchronized void addLostFile(int fileId) {
        this.mLostFileIds.add(fileId);
    }

    public synchronized void childCheckpointed(int childFileId) {
        this.UNCHECKPOINTED_CHILDREN_FILES.remove(childFileId);
        LOG.debug((Object)("Child got checkpointed " + childFileId + " : " + this.toString()));
    }

    public ClientDependencyInfo generateClientDependencyInfo() {
        ClientDependencyInfo ret = new ClientDependencyInfo();
        ret.id = this.ID;
        ret.parents = new ArrayList<Integer>(this.PARENT_FILES.size());
        ret.parents.addAll(this.PARENT_FILES);
        ret.children = new ArrayList<Integer>(this.CHILDREN_FILES.size());
        ret.children.addAll(this.CHILDREN_FILES);
        ret.data = CommonUtils.cloneByteBufferList(this.DATA);
        return ret;
    }

    public synchronized List<Integer> getChildrenDependency() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.mChildrenDependencies.size());
        ret.addAll(this.mChildrenDependencies);
        return ret;
    }

    public synchronized String getCommand() {
        StringBuilder sb = new StringBuilder(this.parseCommandPrefix());
        sb.append(" ").append(MasterConf.get().MASTER_ADDRESS);
        sb.append(" ").append(this.ID);
        for (int k = 0; k < this.CHILDREN_FILES.size(); ++k) {
            int id = this.CHILDREN_FILES.get(k);
            if (!this.mLostFileIds.contains(id)) continue;
            sb.append(" ").append(k);
        }
        this.mLostFileIds.clear();
        return sb.toString();
    }

    public synchronized List<Integer> getLostFiles() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.addAll(this.mLostFileIds);
        return ret;
    }

    synchronized List<Integer> getUncheckpointedChildrenFiles() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.UNCHECKPOINTED_CHILDREN_FILES.size());
        ret.addAll(this.UNCHECKPOINTED_CHILDREN_FILES);
        return ret;
    }

    public synchronized boolean hasCheckpointed() {
        return this.UNCHECKPOINTED_CHILDREN_FILES.size() == 0;
    }

    public synchronized boolean hasChildrenDependency() {
        return !this.mChildrenDependencies.isEmpty();
    }

    public synchronized boolean hasLostFile() {
        return !this.mLostFileIds.isEmpty();
    }

    String parseCommandPrefix() {
        String rtn = this.COMMAND_PREFIX;
        for (String s : DependencyVariables.sVariables.keySet()) {
            rtn = rtn.replace("$" + s, DependencyVariables.sVariables.get(s));
        }
        return rtn;
    }

    synchronized void resetUncheckpointedChildrenFiles(Collection<Integer> uncheckpointedChildrenFiles) {
        this.UNCHECKPOINTED_CHILDREN_FILES.clear();
        this.UNCHECKPOINTED_CHILDREN_FILES.addAll(uncheckpointedChildrenFiles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dependency[");
        sb.append("ID:").append(this.ID).append(", CREATION_TIME_MS:").append(this.CREATION_TIME_MS);
        sb.append(", Parents:").append(this.PARENT_FILES).append(", Children:").append(this.CHILDREN_FILES);
        sb.append(", COMMAND_PREFIX:").append(this.COMMAND_PREFIX);
        sb.append(", PARSED_COMMAND_PREFIX:").append(this.parseCommandPrefix());
        sb.append(", COMMENT:").append(this.COMMENT);
        sb.append(", FRAMEWORK:").append(this.FRAMEWORK);
        sb.append(", FRAMEWORK_VERSION:").append(this.FRAMEWORK_VERSION);
        sb.append(", PARENT_DEPENDENCIES:").append(this.PARENT_DEPENDENCIES);
        sb.append(", ChildrenDependencies:").append(this.mChildrenDependencies);
        sb.append(", UncheckpointedChildrenFiles:").append(this.UNCHECKPOINTED_CHILDREN_FILES);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public synchronized void writeImage(ObjectWriter objWriter, DataOutputStream dos) throws IOException {
        ImageElement ele = new ImageElement(ImageElementType.Dependency).withParameter("depID", this.ID).withParameter("parentFiles", this.PARENT_FILES).withParameter("childrenFiles", this.CHILDREN_FILES).withParameter("commandPrefix", this.COMMAND_PREFIX).withParameter("data", Utils.byteBufferListToBase64(this.DATA)).withParameter("comment", this.COMMENT).withParameter("framework", this.FRAMEWORK).withParameter("frameworkVersion", this.FRAMEWORK_VERSION).withParameter("depType", (Object)this.TYPE).withParameter("parentDeps", this.PARENT_DEPENDENCIES).withParameter("creationTimeMs", this.CREATION_TIME_MS).withParameter("unCheckpointedChildrenFiles", this.getUncheckpointedChildrenFiles());
        this.writeElement(objWriter, dos, ele);
    }
}

