/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tachyon.Pair;
import tachyon.master.BlockInfo;
import tachyon.master.ImageElement;
import tachyon.master.ImageElementType;
import tachyon.master.Inode;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.NetAddress;
import tachyon.thrift.SuspectedFileSizeException;

public class InodeFile
extends Inode {
    private final long BLOCK_SIZE_BYTE;
    private long mLength = 0L;
    private boolean mIsComplete = false;
    private boolean mCache = false;
    private String mUfsPath = "";
    private List<BlockInfo> mBlocks = new ArrayList<BlockInfo>(3);
    private int mDependencyId;

    static InodeFile loadImage(ImageElement ele) throws IOException {
        long creationTimeMs = ele.getLong("creationTimeMs");
        int fileId = ele.getInt("id");
        String fileName = ele.getString("name");
        int parentId = ele.getInt("parentId");
        long blockSizeByte = ele.getLong("blockSizeByte");
        long length = ele.getLong("length");
        boolean isComplete = ele.getBoolean("complete");
        boolean isPinned = ele.getBoolean("pin");
        boolean isCache = ele.getBoolean("cache");
        String ufsPath = ele.getString("ufsPath");
        int dependencyId = ele.getInt("depId");
        InodeFile inode = new InodeFile(fileName, fileId, parentId, blockSizeByte, creationTimeMs);
        try {
            inode.setLength(length);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        inode.setComplete(isComplete);
        inode.setPinned(isPinned);
        inode.setCache(isCache);
        inode.setUfsPath(ufsPath);
        inode.setDependencyId(dependencyId);
        return inode;
    }

    public InodeFile(String name, int id, int parentId, long blockSizeByte, long creationTimeMs) {
        super(name, id, parentId, false, creationTimeMs);
        this.BLOCK_SIZE_BYTE = blockSizeByte;
        this.mDependencyId = -1;
    }

    public synchronized void addBlock(BlockInfo blockInfo) throws BlockInfoException {
        if (this.mIsComplete) {
            throw new BlockInfoException("The file is complete: " + this);
        }
        if (this.mBlocks.size() > 0 && this.mBlocks.get((int)(this.mBlocks.size() - 1)).LENGTH != this.BLOCK_SIZE_BYTE) {
            throw new BlockInfoException("BLOCK_SIZE_BYTE is " + this.BLOCK_SIZE_BYTE + ", but the " + "previous block size is " + this.mBlocks.get((int)(this.mBlocks.size() - 1)).LENGTH);
        }
        if (blockInfo.getInodeFile() != this) {
            throw new BlockInfoException("InodeFile unmatch: " + this + " != " + blockInfo);
        }
        if (blockInfo.BLOCK_INDEX != this.mBlocks.size()) {
            throw new BlockInfoException("BLOCK_INDEX unmatch: " + this.mBlocks.size() + " != " + blockInfo);
        }
        if (blockInfo.OFFSET != (long)this.mBlocks.size() * this.BLOCK_SIZE_BYTE) {
            throw new BlockInfoException("OFFSET unmatch: " + (long)this.mBlocks.size() * this.BLOCK_SIZE_BYTE + " != " + blockInfo);
        }
        if (blockInfo.LENGTH > this.BLOCK_SIZE_BYTE) {
            throw new BlockInfoException("LENGTH too big: " + this.BLOCK_SIZE_BYTE + " " + blockInfo);
        }
        this.mLength += blockInfo.LENGTH;
        this.mBlocks.add(blockInfo);
    }

    public synchronized void addLocation(int blockIndex, long workerId, NetAddress workerAddress) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex >= this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex " + blockIndex + " out of bounds." + this.toString());
        }
        this.mBlocks.get(blockIndex).addLocation(workerId, workerAddress);
    }

    @Override
    public ClientFileInfo generateClientFileInfo(String path) {
        ClientFileInfo ret = new ClientFileInfo();
        ret.id = this.getId();
        ret.name = this.getName();
        ret.path = path;
        ret.ufsPath = this.mUfsPath;
        ret.length = this.mLength;
        ret.blockSizeByte = this.BLOCK_SIZE_BYTE;
        ret.creationTimeMs = this.getCreationTimeMs();
        ret.isComplete = this.isComplete();
        ret.isFolder = false;
        ret.isPinned = this.isPinned();
        ret.isCache = this.mCache;
        ret.blockIds = this.getBlockIds();
        ret.dependencyId = this.mDependencyId;
        ret.inMemoryPercentage = this.getInMemoryPercentage();
        return ret;
    }

    public long getBlockIdBasedOnOffset(long offset) {
        int index = (int)(offset / this.BLOCK_SIZE_BYTE);
        return BlockInfo.computeBlockId(this.getId(), index);
    }

    public synchronized List<Long> getBlockIds() {
        ArrayList<Long> ret = new ArrayList<Long>(this.mBlocks.size());
        for (int k = 0; k < this.mBlocks.size(); ++k) {
            ret.add(this.mBlocks.get((int)k).BLOCK_ID);
        }
        return ret;
    }

    public synchronized List<Pair<Long, Long>> getBlockIdWorkerIdPairs() {
        ArrayList<Pair<Long, Long>> ret = new ArrayList<Pair<Long, Long>>();
        for (BlockInfo info : this.mBlocks) {
            ret.addAll(info.getBlockIdWorkerIdPairs());
        }
        return ret;
    }

    public List<BlockInfo> getBlockList() {
        return this.mBlocks;
    }

    public synchronized List<NetAddress> getBlockLocations(int blockIndex) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex > this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex is out of the boundry: " + blockIndex);
        }
        return this.mBlocks.get(blockIndex).getLocations();
    }

    public long getBlockSizeByte() {
        return this.BLOCK_SIZE_BYTE;
    }

    public synchronized String getUfsPath() {
        return this.mUfsPath;
    }

    public synchronized ClientBlockInfo getClientBlockInfo(int blockIndex) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex > this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex is out of the boundry: " + blockIndex);
        }
        return this.mBlocks.get(blockIndex).generateClientBlockInfo();
    }

    public synchronized List<ClientBlockInfo> getClientBlockInfos() {
        ArrayList<ClientBlockInfo> ret = new ArrayList<ClientBlockInfo>(this.mBlocks.size());
        for (BlockInfo tInfo : this.mBlocks) {
            ret.add(tInfo.generateClientBlockInfo());
        }
        return ret;
    }

    public synchronized int getDependencyId() {
        return this.mDependencyId;
    }

    private synchronized int getInMemoryPercentage() {
        if (this.mLength == 0L) {
            return 100;
        }
        long inMemoryLength = 0L;
        for (BlockInfo info : this.mBlocks) {
            if (!info.isInMemory()) continue;
            inMemoryLength += info.LENGTH;
        }
        return (int)(inMemoryLength * 100L / this.mLength);
    }

    public synchronized long getLength() {
        return this.mLength;
    }

    public synchronized long getNewBlockId() {
        return BlockInfo.computeBlockId(this.getId(), this.mBlocks.size());
    }

    public synchronized int getNumberOfBlocks() {
        return this.mBlocks.size();
    }

    public synchronized boolean hasCheckpointed() {
        return !this.mUfsPath.equals("");
    }

    public synchronized boolean isCache() {
        return this.mCache;
    }

    public synchronized boolean isComplete() {
        return this.mIsComplete;
    }

    public synchronized boolean isFullyInMemory() {
        return this.getInMemoryPercentage() == 100;
    }

    public synchronized void removeLocation(int blockIndex, long workerId) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex >= this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex " + blockIndex + " out of bounds." + this.toString());
        }
        this.mBlocks.get(blockIndex).removeLocation(workerId);
    }

    public synchronized void setCache(boolean cache) {
        this.mCache = cache;
    }

    public synchronized void setUfsPath(String ufsPath) {
        this.mUfsPath = ufsPath;
    }

    public synchronized void setComplete() {
        this.mIsComplete = true;
    }

    public synchronized void setComplete(boolean complete) {
        this.mIsComplete = complete;
    }

    public synchronized void setDependencyId(int dependencyId) {
        this.mDependencyId = dependencyId;
    }

    public synchronized void setLength(long length) throws SuspectedFileSizeException, BlockInfoException {
        if (this.isComplete()) {
            throw new SuspectedFileSizeException("InodeFile length was set previously.");
        }
        if (length < 0L) {
            throw new SuspectedFileSizeException("InodeFile new length " + length + " is illegal.");
        }
        this.mLength = 0L;
        while (length >= this.BLOCK_SIZE_BYTE) {
            this.addBlock(new BlockInfo(this, this.mBlocks.size(), this.BLOCK_SIZE_BYTE));
            length -= this.BLOCK_SIZE_BYTE;
        }
        if (length > 0L) {
            this.addBlock(new BlockInfo(this, this.mBlocks.size(), (int)length));
        }
        this.mIsComplete = true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InodeFile(");
        sb.append(super.toString()).append(", LENGTH: ").append(this.mLength);
        sb.append(", UfsPath: ").append(this.mUfsPath);
        sb.append(", mBlocks: ").append(this.mBlocks);
        sb.append(", DependencyId:").append(this.mDependencyId).append(")");
        return sb.toString();
    }

    @Override
    public synchronized void writeImage(ObjectWriter objWriter, DataOutputStream dos) throws IOException {
        ImageElement ele = new ImageElement(ImageElementType.InodeFile).withParameter("creationTimeMs", this.getCreationTimeMs()).withParameter("id", this.getId()).withParameter("name", this.getName()).withParameter("parentId", this.getParentId()).withParameter("blockSizeByte", this.getBlockSizeByte()).withParameter("length", this.getLength()).withParameter("complete", this.isComplete()).withParameter("pin", this.isPinned()).withParameter("cache", this.isCache()).withParameter("ufsPath", this.getUfsPath()).withParameter("depId", this.getDependencyId());
        this.writeElement(objWriter, dos, ele);
    }
}

