/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.HeartbeatThread;
import tachyon.LeaderInquireClient;
import tachyon.conf.CommonConf;
import tachyon.conf.UserConf;
import tachyon.master.MasterClientHeartbeatExecutor;
import tachyon.org.apache.thrift.TException;
import tachyon.org.apache.thrift.protocol.TBinaryProtocol;
import tachyon.org.apache.thrift.protocol.TProtocol;
import tachyon.org.apache.thrift.transport.TFramedTransport;
import tachyon.org.apache.thrift.transport.TSocket;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.Command;
import tachyon.thrift.DependencyDoesNotExistException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.MasterService;
import tachyon.thrift.NetAddress;
import tachyon.thrift.NoWorkerException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableColumnException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;

public class MasterClient {
    private static final int MAX_CONNECT_TRY = 5;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private boolean mUseZookeeper;
    private MasterService.Client mClient = null;
    private InetSocketAddress mMasterAddress = null;
    private TProtocol mProtocol = null;
    private volatile boolean mIsConnected;
    private volatile boolean mIsShutdown;
    private volatile long mLastAccessedMs;
    private HeartbeatThread mHeartbeatThread = null;

    public MasterClient(InetSocketAddress masterAddress) {
        this(masterAddress, CommonConf.get().USE_ZOOKEEPER);
    }

    public MasterClient(InetSocketAddress masterAddress, boolean useZookeeper) {
        this.mUseZookeeper = useZookeeper;
        if (!this.mUseZookeeper) {
            this.mMasterAddress = masterAddress;
        }
        this.mIsConnected = false;
        this.mIsShutdown = false;
    }

    public synchronized boolean addCheckpoint(long workerId, int fileId, long length, String checkpointPath) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.addCheckpoint(workerId, fileId, length, checkpointPath);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return false;
    }

    public synchronized void cleanConnect() {
        if (this.mIsConnected) {
            this.LOG.debug((Object)("Disconnecting from the master " + this.mMasterAddress));
            this.mIsConnected = false;
        }
        if (this.mProtocol != null) {
            this.mProtocol.getTransport().close();
        }
        if (this.mHeartbeatThread != null) {
            this.mHeartbeatThread.shutdown();
        }
    }

    public synchronized void connect() throws TException {
        this.mLastAccessedMs = System.currentTimeMillis();
        if (this.mIsConnected) {
            return;
        }
        this.cleanConnect();
        if (this.mIsShutdown) {
            throw new TException("Client is shutdown, will not try to connect");
        }
        int tries = 0;
        TTransportException lastException = null;
        while (tries++ < 5 && !this.mIsShutdown) {
            this.mMasterAddress = this.getMasterAddress();
            this.mProtocol = new TBinaryProtocol(new TFramedTransport(new TSocket(this.mMasterAddress.getHostName(), this.mMasterAddress.getPort())));
            this.mClient = new MasterService.Client(this.mProtocol);
            this.mLastAccessedMs = System.currentTimeMillis();
            try {
                this.mProtocol.getTransport().open();
                this.mHeartbeatThread = new HeartbeatThread("Master_Client Heartbeat", new MasterClientHeartbeatExecutor(this, UserConf.get().MASTER_CLIENT_TIMEOUT_MS), UserConf.get().MASTER_CLIENT_TIMEOUT_MS / 2L);
                this.mHeartbeatThread.start();
            }
            catch (TTransportException e) {
                lastException = e;
                this.LOG.error((Object)("Failed to connect (" + tries + ") to master " + this.mMasterAddress + " : " + e.getMessage()));
                if (this.mHeartbeatThread != null) {
                    this.mHeartbeatThread.shutdown();
                }
                CommonUtils.sleepMs(this.LOG, 1000L);
                continue;
            }
            this.mIsConnected = true;
            return;
        }
        throw new TException("Failed to connect to master " + this.mMasterAddress + " after " + (tries - 1) + " attempts", lastException);
    }

    public ClientDependencyInfo getClientDependencyInfo(int did) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getClientDependencyInfo(did);
            }
            catch (DependencyDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized ClientFileInfo getClientFileInfoById(int id) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.getClientFileInfoById(id);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    long getLastAccessedMs() {
        return this.mLastAccessedMs;
    }

    private InetSocketAddress getMasterAddress() {
        if (!this.mUseZookeeper) {
            return this.mMasterAddress;
        }
        LeaderInquireClient leaderInquireClient = LeaderInquireClient.getClient(CommonConf.get().ZOOKEEPER_ADDRESS, CommonConf.get().ZOOKEEPER_LEADER_PATH);
        try {
            String temp = leaderInquireClient.getMasterAddress();
            return CommonUtils.parseInetSocketAddress(temp);
        }
        catch (IOException e) {
            this.LOG.error((Object)e.getMessage(), (Throwable)e);
            CommonUtils.runtimeException(e);
            return null;
        }
    }

    public synchronized long getUserId() throws TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                long ret = this.mClient.user_getUserId();
                this.LOG.info((Object)("User registered at the master " + this.mMasterAddress + " got UserId " + ret));
                return ret;
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1L;
    }

    public synchronized List<ClientWorkerInfo> getWorkersInfo() throws TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.getWorkersInfo();
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized boolean isConnected() {
        return this.mIsConnected;
    }

    public synchronized List<ClientFileInfo> listStatus(String path) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.liststatus(path);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public void shutdown() {
        this.mIsShutdown = true;
        if (this.mProtocol != null) {
            this.mProtocol.getTransport().close();
        }
        this.cleanConnect();
    }

    public synchronized void user_completeFile(int fId) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.user_completeFile(fId);
                return;
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized int user_createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_createDependency(parents, children, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, childrenBlockSizeByte);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1;
    }

    public synchronized int user_createFile(String path, long blockSizeByte) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_createFile(path, blockSizeByte);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1;
    }

    public int user_createFileOnCheckpoint(String path, String checkpointPath) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_createFileOnCheckpoint(path, checkpointPath);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (SuspectedFileSizeException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1;
    }

    public synchronized long user_createNewBlock(int fId) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_createNewBlock(fId);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1L;
    }

    public synchronized int user_createRawTable(String path, int columns, ByteBuffer metadata) throws IOException, TException {
        if (metadata == null) {
            metadata = ByteBuffer.allocate(0);
        }
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_createRawTable(path, columns, metadata);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TableColumnException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1;
    }

    public synchronized boolean user_delete(int fileId, boolean recursive) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_deleteById(fileId, recursive);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return false;
    }

    public synchronized boolean user_delete(String path, boolean recursive) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_deleteByPath(path, recursive);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return false;
    }

    public synchronized long user_getBlockId(int fId, int index) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getBlockId(fId, index);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1L;
    }

    public ClientBlockInfo user_getClientBlockInfo(long blockId) throws FileDoesNotExistException, BlockInfoException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getClientBlockInfo(blockId);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized ClientFileInfo user_getClientFileInfoByPath(String path) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getClientFileInfoByPath(path);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized ClientRawTableInfo user_getClientRawTableInfoById(int id) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                ClientRawTableInfo ret = this.mClient.user_getClientRawTableInfoById(id);
                ret.setMetadata(CommonUtils.generateNewByteBufferFromThriftRPCResults(ret.metadata));
                return ret;
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized ClientRawTableInfo user_getClientRawTableInfoByPath(String path) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                ClientRawTableInfo ret = this.mClient.user_getClientRawTableInfoByPath(path);
                ret.setMetadata(CommonUtils.generateNewByteBufferFromThriftRPCResults(ret.metadata));
                return ret;
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized List<ClientBlockInfo> user_getFileBlocks(int id) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getFileBlocksById(id);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized int user_getFileId(String path) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getFileId(path);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1;
    }

    public synchronized int user_getNumberOfFiles(String folderPath) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getNumberOfFiles(folderPath);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1;
    }

    public synchronized int user_getRawTableId(String path) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getRawTableId(path);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1;
    }

    public synchronized String user_getUnderfsAddress() throws TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getUnderfsAddress();
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized NetAddress user_getWorker(boolean random, String hostname) throws NoWorkerException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_getWorker(random, hostname);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized List<Integer> user_listFiles(String path, boolean recursive) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_listFiles(path, recursive);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized List<String> user_ls(String path, boolean recursive) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_ls(path, recursive);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized boolean user_mkdir(String path) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_mkdir(path);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return false;
    }

    public synchronized void user_outOfMemoryForPinFile(int fileId) throws TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.user_outOfMemoryForPinFile(fileId);
                return;
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized boolean user_rename(String srcPath, String dstPath) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.user_rename(srcPath, dstPath);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return false;
    }

    public void user_renameTo(int fId, String path) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.user_renameTo(fId, path);
                return;
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized void user_reportLostFile(int fileId) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.user_reportLostFile(fileId);
                return;
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized void user_requestFilesInDependency(int depId) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.user_requestFilesInDependency(depId);
                return;
            }
            catch (DependencyDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized void user_setPinned(int id, boolean pinned) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.user_setPinned(id, pinned);
                return;
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized void user_updateRawTableMetadata(int id, ByteBuffer metadata) throws IOException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.user_updateRawTableMetadata(id, metadata);
                return;
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized void worker_cacheBlock(long workerId, long workerUsedBytes, long blockId, long length) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                this.mClient.worker_cacheBlock(workerId, workerUsedBytes, blockId, length);
                return;
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
    }

    public synchronized Set<Integer> worker_getPinIdList() throws TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.worker_getPinIdList();
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized List<Integer> worker_getPriorityDependencyList() throws TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.worker_getPriorityDependencyList();
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return new ArrayList<Integer>();
    }

    public synchronized Command worker_heartbeat(long workerId, long usedBytes, List<Long> removedPartitionList) throws BlockInfoException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                return this.mClient.worker_heartbeat(workerId, usedBytes, removedPartitionList);
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return null;
    }

    public synchronized long worker_register(NetAddress workerNetAddress, long totalBytes, long usedBytes, List<Long> currentBlockList) throws BlockInfoException, TException {
        while (!this.mIsShutdown) {
            this.connect();
            try {
                long ret = this.mClient.worker_register(workerNetAddress, totalBytes, usedBytes, currentBlockList);
                this.LOG.info((Object)("Registered at the master " + this.mMasterAddress + " from worker " + workerNetAddress + " , got WorkerId " + ret));
                return ret;
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage());
                this.mIsConnected = false;
            }
        }
        return -1L;
    }
}

