/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;

public class MasterWorkerInfo {
    public final InetSocketAddress ADDRESS;
    private final long CAPACITY_BYTES;
    private final long START_TIME_MS;
    private long mId;
    private long mUsedBytes;
    private long mLastUpdatedTimeMs;
    private Set<Long> mBlocks;
    private Set<Long> mToRemoveBlocks;

    public MasterWorkerInfo(long id, InetSocketAddress address, long capacityBytes) {
        this.mId = id;
        this.ADDRESS = address;
        this.CAPACITY_BYTES = capacityBytes;
        this.START_TIME_MS = System.currentTimeMillis();
        this.mUsedBytes = 0L;
        this.mBlocks = new HashSet<Long>();
        this.mToRemoveBlocks = new HashSet<Long>();
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public synchronized ClientWorkerInfo generateClientWorkerInfo() {
        ClientWorkerInfo ret = new ClientWorkerInfo();
        ret.id = this.mId;
        ret.address = new NetAddress(this.ADDRESS.getAddress().getCanonicalHostName(), this.ADDRESS.getPort());
        ret.lastContactSec = (int)((CommonUtils.getCurrentMs() - this.mLastUpdatedTimeMs) / 1000L);
        ret.state = "In Service";
        ret.capacityBytes = this.CAPACITY_BYTES;
        ret.usedBytes = this.mUsedBytes;
        ret.starttimeMs = this.START_TIME_MS;
        return ret;
    }

    public InetSocketAddress getAddress() {
        return this.ADDRESS;
    }

    public synchronized long getAvailableBytes() {
        return this.CAPACITY_BYTES - this.mUsedBytes;
    }

    public synchronized Set<Long> getBlocks() {
        return new HashSet<Long>(this.mBlocks);
    }

    public long getCapacityBytes() {
        return this.CAPACITY_BYTES;
    }

    public synchronized long getId() {
        return this.mId;
    }

    public synchronized long getLastUpdatedTimeMs() {
        return this.mLastUpdatedTimeMs;
    }

    public synchronized List<Long> getToRemovedBlocks() {
        return new ArrayList<Long>(this.mToRemoveBlocks);
    }

    public synchronized long getUsedBytes() {
        return this.mUsedBytes;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("MasterWorkerInfo(");
        sb.append(" ID: ").append(this.mId);
        sb.append(", ADDRESS: ").append(this.ADDRESS);
        sb.append(", TOTAL_BYTES: ").append(this.CAPACITY_BYTES);
        sb.append(", mUsedBytes: ").append(this.mUsedBytes);
        sb.append(", mAvailableBytes: ").append(this.CAPACITY_BYTES - this.mUsedBytes);
        sb.append(", mLastUpdatedTimeMs: ").append(this.mLastUpdatedTimeMs);
        sb.append(", mBlocks: [ ");
        for (long blockId : this.mBlocks) {
            sb.append(blockId).append(", ");
        }
        sb.append("] )");
        return sb.toString();
    }

    public synchronized void updateBlock(boolean add, long blockId) {
        if (add) {
            this.mBlocks.add(blockId);
        } else {
            this.mBlocks.remove(blockId);
        }
    }

    public synchronized void updateBlocks(boolean add, Collection<Long> blockIds) {
        if (add) {
            this.mBlocks.addAll(blockIds);
        } else {
            this.mBlocks.removeAll(blockIds);
        }
    }

    public synchronized void updateLastUpdatedTimeMs() {
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public synchronized void updateToRemovedBlock(boolean add, long blockId) {
        if (add) {
            if (this.mBlocks.contains(blockId)) {
                this.mToRemoveBlocks.add(blockId);
            }
        } else {
            this.mToRemoveBlocks.remove(blockId);
        }
    }

    public synchronized void updateToRemovedBlocks(boolean add, Collection<Long> blockIds) {
        for (long blockId : blockIds) {
            this.updateToRemovedBlock(add, blockId);
        }
    }

    public synchronized void updateUsedBytes(long usedBytes) {
        this.mUsedBytes = usedBytes;
    }
}

