/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.util.ArrayList;
import java.util.List;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;

public class UiFileInfo
implements Comparable<UiFileInfo> {
    private final int ID;
    private final int DEPENDENCY_ID;
    private final String NAME;
    private final String ABSOLUATE_PATH;
    private final String CHECKPOINT_PATH;
    private final long BLOCK_SIZE_BYTES;
    private final long SIZE;
    private final long CREATION_TIME_MS;
    private final boolean IN_MEMORY;
    private final int IN_MEMORY_PERCENTAGE;
    private final boolean IS_DIRECTORY;
    private final boolean NEED_PIN;
    private List<String> mFileLocations;

    public UiFileInfo(ClientFileInfo fileInfo) {
        this.ID = fileInfo.getId();
        this.DEPENDENCY_ID = fileInfo.getDependencyId();
        this.NAME = fileInfo.getName();
        this.ABSOLUATE_PATH = fileInfo.getPath();
        this.CHECKPOINT_PATH = fileInfo.getUfsPath();
        this.BLOCK_SIZE_BYTES = fileInfo.getBlockSizeByte();
        this.SIZE = fileInfo.getLength();
        this.CREATION_TIME_MS = fileInfo.getCreationTimeMs();
        this.IN_MEMORY = 100 == fileInfo.inMemoryPercentage;
        this.IN_MEMORY_PERCENTAGE = fileInfo.getInMemoryPercentage();
        this.IS_DIRECTORY = fileInfo.isFolder;
        this.NEED_PIN = fileInfo.isPinned;
        this.mFileLocations = new ArrayList<String>();
    }

    @Override
    public int compareTo(UiFileInfo o) {
        return this.ABSOLUATE_PATH.compareTo(o.getAbsolutePath());
    }

    public String getAbsolutePath() {
        return this.ABSOLUATE_PATH;
    }

    public String getBlockSizeBytes() {
        if (this.IS_DIRECTORY) {
            return " ";
        }
        return CommonUtils.getSizeFromBytes(this.BLOCK_SIZE_BYTES);
    }

    public String getCheckpointPath() {
        return this.CHECKPOINT_PATH;
    }

    public String getCreationTime() {
        return CommonUtils.convertMsToDate(this.CREATION_TIME_MS);
    }

    public int getDependencyId() {
        return this.DEPENDENCY_ID;
    }

    public List<String> getFileLocations() {
        return this.mFileLocations;
    }

    public int getId() {
        return this.ID;
    }

    public boolean getInMemory() {
        return this.IN_MEMORY;
    }

    public int getInMemoryPercentage() {
        return this.IN_MEMORY_PERCENTAGE;
    }

    public boolean getIsDirectory() {
        return this.IS_DIRECTORY;
    }

    public boolean getNeedPin() {
        return this.NEED_PIN;
    }

    public String getName() {
        if (this.ABSOLUATE_PATH.equals("/")) {
            return "root";
        }
        return this.NAME;
    }

    public String getSize() {
        if (this.IS_DIRECTORY) {
            return " ";
        }
        return CommonUtils.getSizeFromBytes(this.SIZE);
    }

    public void setFileLocations(List<NetAddress> fileLocations) {
        for (NetAddress addr : fileLocations) {
            this.mFileLocations.add(new String(addr.getMHost() + ":" + addr.getMPort()));
        }
    }
}

