/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tachyon.master.MasterInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.web.UiFileInfo;

public class WebInterfaceMemoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 4293149962399443914L;
    private MasterInfo mMasterInfo;

    public WebInterfaceMemoryServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        List<String> inMemoryFiles = this.mMasterInfo.getInMemoryFiles();
        Collections.sort(inMemoryFiles);
        request.setAttribute("inMemoryFiles", inMemoryFiles);
        ArrayList<UiFileInfo> fileInfos = new ArrayList<UiFileInfo>(inMemoryFiles.size());
        for (String file : inMemoryFiles) {
            ClientFileInfo fileInfo = null;
            try {
                fileInfo = this.mMasterInfo.getClientFileInfo(file);
            }
            catch (InvalidPathException ipe) {
                request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + ipe.getLocalizedMessage()));
                this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (FileDoesNotExistException fdne) {
                // empty catch block
            }
            if (fileInfo.getInMemoryPercentage() != 100) continue;
            fileInfos.add(new UiFileInfo(fileInfo));
        }
        request.setAttribute("fileInfos", fileInfos);
        this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

