/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.Precedence;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.impl.JS;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class JSNativeGenerator
implements Injector,
DependencyPlugin,
Generator {
    private Set<MethodReference> reachedFunctorMethods = new HashSet<MethodReference>();
    private Set<DependencyNode> functorParamNodes = new HashSet<DependencyNode>();

    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "function": {
                this.writeFunction(context, writer);
                break;
            }
            case "functionAsObject": {
                this.writeFunctionAsObject(context, writer);
            }
        }
    }

    private void writeFunction(GeneratorContext context, SourceWriter writer) throws IOException {
        String thisName = context.getParameterName(1);
        String methodName = context.getParameterName(2);
        writer.append("var name").ws().append('=').ws().append("'jso$functor$'").ws().append('+').ws().append(methodName).append(';').softNewLine();
        writer.append("if").ws().append("(!").append(thisName).append("[name])").ws().append('{').indent().softNewLine();
        writer.append("var fn").ws().append('=').ws().append("function()").ws().append('{').indent().softNewLine();
        writer.append("return ").append(thisName).append('[').append(methodName).append(']').append(".apply(").append(thisName).append(',').ws().append("arguments);").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.append(thisName).append("[name]").ws().append('=').ws().append("function()").ws().append('{').indent().softNewLine();
        writer.append("return fn;").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.outdent().append('}').softNewLine();
        writer.append("return ").append(thisName).append("[name]();").softNewLine();
    }

    private void writeFunctionAsObject(GeneratorContext context, SourceWriter writer) throws IOException {
        String thisName = context.getParameterName(1);
        String methodName = context.getParameterName(2);
        writer.append("if").ws().append("(typeof ").append(thisName).ws().append("!==").ws().append("\"function\")").ws().append("return ").append(thisName).append(";").softNewLine();
        writer.append("var result").ws().append("=").ws().append("{};").softNewLine();
        writer.append("result[").append(methodName).append("]").ws().append("=").ws().append(thisName).append(";").softNewLine();
        writer.append("return result;").softNewLine();
    }

    public void generate(InjectorContext context, MethodReference methodRef) throws IOException {
        SourceWriter writer = context.getWriter();
        switch (methodRef.getName()) {
            case "arrayData": {
                context.writeExpr(context.getArgument(0));
                writer.append(".data");
                break;
            }
            case "get": {
                context.writeExpr(context.getArgument(0), Precedence.MEMBER_ACCESS);
                this.renderProperty(context.getArgument(1), context);
                break;
            }
            case "set": {
                context.writeExpr(context.getArgument(0), Precedence.ASSIGNMENT.next());
                this.renderProperty(context.getArgument(1), context);
                writer.ws().append('=').ws();
                context.writeExpr(context.getArgument(2), Precedence.ASSIGNMENT.next());
                break;
            }
            case "invoke": {
                context.writeExpr(context.getArgument(0), Precedence.GROUPING);
                this.renderProperty(context.getArgument(1), context);
                writer.append('(');
                for (int i = 2; i < context.argumentCount(); ++i) {
                    if (i > 2) {
                        writer.append(',').ws();
                    }
                    context.writeExpr(context.getArgument(i), Precedence.min());
                }
                writer.append(')');
                break;
            }
            case "instantiate": {
                if (context.getPrecedence().ordinal() >= Precedence.FUNCTION_CALL.ordinal()) {
                    writer.append("(");
                }
                writer.append("new ");
                context.writeExpr(context.getArgument(0), Precedence.GROUPING);
                this.renderProperty(context.getArgument(1), context);
                writer.append("(");
                for (int i = 2; i < context.argumentCount(); ++i) {
                    if (i > 2) {
                        writer.append(',').ws();
                    }
                    context.writeExpr(context.getArgument(i), Precedence.min());
                }
                writer.append(")");
                if (context.getPrecedence().ordinal() < Precedence.FUNCTION_CALL.ordinal()) break;
                writer.append(")");
                break;
            }
            case "wrap": {
                if (methodRef.getDescriptor().parameterType(0).isObject("java.lang.String")) {
                    ConstantExpr constant;
                    if (context.getArgument(0) instanceof ConstantExpr && (constant = (ConstantExpr)context.getArgument(0)).getValue() instanceof String) {
                        writer.append('\"').append(RenderingUtil.escapeString((String)((String)constant.getValue()))).append('\"');
                        break;
                    }
                    writer.append("$rt_ustr(");
                    context.writeExpr(context.getArgument(0), Precedence.min());
                    writer.append(")");
                    break;
                }
                if (methodRef.getDescriptor().parameterType(0) == ValueType.BOOLEAN) {
                    if (context.getPrecedence().ordinal() >= Precedence.UNARY.ordinal()) {
                        writer.append("(");
                    }
                    writer.append("!!");
                    context.writeExpr(context.getArgument(0), Precedence.UNARY);
                    if (context.getPrecedence().ordinal() < Precedence.UNARY.ordinal()) break;
                    writer.append(")");
                    break;
                }
                context.writeExpr(context.getArgument(0), context.getPrecedence());
                break;
            }
            case "unwrapString": {
                writer.append("$rt_str(");
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            case "unwrapBoolean": {
                if (context.getPrecedence().ordinal() >= Precedence.CONDITIONAL.ordinal()) {
                    writer.append("(");
                }
                context.writeExpr(context.getArgument(0), Precedence.CONDITIONAL.next());
                writer.ws().append("?").ws().append("1").ws().append(":").ws().append("0");
                if (context.getPrecedence().ordinal() < Precedence.CONDITIONAL.ordinal()) break;
                writer.append(")");
                break;
            }
            case "dataToByteArray": {
                writer.append("$rt_wrapArray($rt_bytecls(),").ws();
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            case "dataToShortArray": {
                writer.append("$rt_wrapArray($rt_shortcls(),").ws();
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            case "dataToCharArray": {
                writer.append("$rt_wrapArray($rt_charcls(),").ws();
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            case "dataToIntArray": {
                writer.append("$rt_wrapArray($rt_intcls(),").ws();
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            case "dataToFloatArray": {
                writer.append("$rt_wrapArray($rt_floatcls(),").ws();
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            case "dataToDoubleArray": {
                writer.append("$rt_wrapArray($rt_doublecls(),").ws();
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            case "dataToArray": {
                writer.append("$rt_wrapArray($rt_objcls(),").ws();
                context.writeExpr(context.getArgument(0), Precedence.min());
                writer.append(")");
                break;
            }
            default: {
                if (!methodRef.getName().startsWith("unwrap")) break;
                context.writeExpr(context.getArgument(0), context.getPrecedence());
            }
        }
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "invoke": 
            case "instantiate": 
            case "function": {
                if (!this.reachedFunctorMethods.add(method.getReference()) || method.isMissing()) break;
                for (int i = 0; i < method.getReference().parameterCount(); ++i) {
                    DependencyNode node = method.getVariable(i);
                    if (!this.functorParamNodes.add(node)) continue;
                    node.addConsumer(type -> {
                        if (agent.getClassHierarchy().isSuperType(method.getMethod().getOwnerName(), type.getName(), false)) {
                            this.reachFunctorMethods(agent, type.getName());
                        }
                    });
                }
                break;
            }
            case "unwrapString": {
                method.getResult().propagate(agent.getType("java.lang.String"));
                break;
            }
            case "dataToByteArray": {
                method.getResult().propagate(agent.getType("[B"));
                break;
            }
            case "dataToShortArray": {
                method.getResult().propagate(agent.getType("[S"));
                break;
            }
            case "dataToCharArray": {
                method.getResult().propagate(agent.getType("[C"));
                break;
            }
            case "dataToIntArray": {
                method.getResult().propagate(agent.getType("[I"));
                break;
            }
            case "dataToFloatArray": {
                method.getResult().propagate(agent.getType("[F"));
                break;
            }
            case "dataToDoubleArray": {
                method.getResult().propagate(agent.getType("[D"));
                break;
            }
            case "dataToArray": {
                method.getResult().propagate(agent.getType("[Ljava/lang/Object;"));
            }
        }
    }

    private void reachFunctorMethods(DependencyAgent agent, String type) {
        ClassReader cls = agent.getClassSource().get(type);
        if (cls != null) {
            for (MethodReader method : cls.getMethods()) {
                if (method.hasModifier(ElementModifier.STATIC)) continue;
                agent.linkMethod(method.getReference()).use();
            }
        }
    }

    private void renderProperty(Expr property, InjectorContext context) throws IOException {
        SourceWriter writer = context.getWriter();
        String name = this.extractPropertyName(property);
        if (name == null) {
            writer.append('[');
            context.writeExpr(property, Precedence.min());
            writer.append(']');
        } else if (!this.isIdentifier(name)) {
            writer.append("[\"");
            context.writeEscaped(name);
            writer.append("\"]");
        } else {
            writer.append(".").append(name);
        }
    }

    private String extractPropertyName(Expr propertyName) {
        if (!(propertyName instanceof InvocationExpr)) {
            return null;
        }
        InvocationExpr invoke = (InvocationExpr)propertyName;
        if (!invoke.getMethod().getClassName().equals(JS.class.getName())) {
            return null;
        }
        if (!invoke.getMethod().getName().equals("wrap") || !invoke.getMethod().getDescriptor().parameterType(0).isObject("java.lang.String")) {
            return null;
        }
        Expr arg = (Expr)invoke.getArguments().get(0);
        if (!(arg instanceof ConstantExpr)) {
            return null;
        }
        ConstantExpr constant = (ConstantExpr)arg;
        return constant.getValue() instanceof String ? (String)constant.getValue() : null;
    }

    private boolean isIdentifier(String name) {
        if (name.isEmpty() || !Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

