/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.FunctorImpl;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSClassProcessor;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.JSValueMarshaller;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

class JSObjectClassTransformer
implements ClassHolderTransformer {
    private JSClassProcessor processor;
    private JSBodyRepository repository;
    private JSTypeHelper typeHelper;
    private ClassHierarchy hierarchy;
    private Map<String, ExposedClass> exposedClasses = new HashMap<String, ExposedClass>();

    JSObjectClassTransformer(JSBodyRepository repository) {
        this.repository = repository;
    }

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        ExposedClass exposedClass;
        ClassReader originalClass;
        this.hierarchy = context.getHierarchy();
        if (this.processor == null || this.processor.getClassSource() != this.hierarchy.getClassSource()) {
            this.typeHelper = new JSTypeHelper(this.hierarchy.getClassSource());
            this.processor = new JSClassProcessor(this.hierarchy.getClassSource(), this.typeHelper, this.repository, context.getDiagnostics(), context.getIncrementalCache());
        }
        this.processor.processClass(cls);
        if (this.typeHelper.isJavaScriptClass(cls.getName())) {
            this.processor.processMemberMethods(cls);
        }
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            if (method.getProgram() == null) continue;
            this.processor.processProgram(method);
        }
        this.processor.createJSMethods(cls);
        MethodReference functorMethod = this.processor.isFunctor(cls.getName());
        if (functorMethod != null && this.processor.isFunctor(cls.getParent()) != null) {
            functorMethod = null;
        }
        if ((originalClass = this.hierarchy.getClassSource().get(cls.getName())) != null) {
            exposedClass = this.getExposedClass(cls.getName());
        } else {
            exposedClass = new ExposedClass();
            this.createExposedClass((ClassReader)cls, exposedClass);
        }
        this.exposeMethods(cls, exposedClass, context.getDiagnostics(), functorMethod);
    }

    private void exposeMethods(ClassHolder classHolder, ExposedClass classToExpose, Diagnostics diagnostics, MethodReference functorMethod) {
        int index = 0;
        for (MethodDescriptor method : classToExpose.methods.keySet()) {
            int i;
            MethodReference methodRef = new MethodReference(classHolder.getName(), method);
            CallLocation callLocation = new CallLocation(methodRef);
            ValueType[] exportedMethodSignature = (ValueType[])Arrays.stream(method.getSignature()).map(type -> ValueType.object((String)JSObject.class.getName())).toArray(ValueType[]::new);
            MethodDescriptor exportedMethodDesc = new MethodDescriptor(method.getName() + "$exported$" + index++, exportedMethodSignature);
            MethodHolder exportedMethod = new MethodHolder(exportedMethodDesc);
            Program program = new Program();
            exportedMethod.setProgram(program);
            program.createVariable();
            BasicBlock basicBlock = program.createBasicBlock();
            ArrayList<Instruction> marshallInstructions = new ArrayList<Instruction>();
            JSValueMarshaller marshaller = new JSValueMarshaller(diagnostics, this.typeHelper, this.hierarchy.getClassSource(), program, marshallInstructions);
            Variable[] variablesToPass = new Variable[method.parameterCount()];
            for (i = 0; i < method.parameterCount(); ++i) {
                variablesToPass[i] = program.createVariable();
            }
            for (i = 0; i < method.parameterCount(); ++i) {
                variablesToPass[i] = marshaller.unwrapReturnValue(callLocation, variablesToPass[i], method.parameterType(i), false);
            }
            basicBlock.addAll(marshallInstructions);
            marshallInstructions.clear();
            InvokeInstruction invocation = new InvokeInstruction();
            invocation.setType(InvocationType.VIRTUAL);
            invocation.setInstance(program.variableAt(0));
            invocation.setMethod(methodRef);
            invocation.setArguments(variablesToPass);
            basicBlock.add((Instruction)invocation);
            ExitInstruction exit = new ExitInstruction();
            if (method.getResultType() != ValueType.VOID) {
                invocation.setReceiver(program.createVariable());
                exit.setValueToReturn(marshaller.wrapArgument(callLocation, invocation.getReceiver(), method.getResultType(), false));
                basicBlock.addAll(marshallInstructions);
                marshallInstructions.clear();
            }
            basicBlock.add((Instruction)exit);
            classHolder.addMethod(exportedMethod);
            String publicAlias = classToExpose.methods.get(method);
            AnnotationHolder annot = new AnnotationHolder(JSMethodToExpose.class.getName());
            annot.getValues().put("name", new AnnotationValue(publicAlias));
            exportedMethod.getAnnotations().add(annot);
            if (!methodRef.equals((Object)functorMethod)) continue;
            this.addFunctorField(classHolder, exportedMethod.getReference());
        }
    }

    private ExposedClass getExposedClass(String name) {
        ExposedClass cls = this.exposedClasses.get(name);
        if (cls == null) {
            cls = this.createExposedClass(name);
            this.exposedClasses.put(name, cls);
        }
        return cls;
    }

    private ExposedClass createExposedClass(String name) {
        ClassReader cls = this.hierarchy.getClassSource().get(name);
        ExposedClass exposedCls = new ExposedClass();
        if (cls != null) {
            this.createExposedClass(cls, exposedCls);
        }
        return exposedCls;
    }

    private void createExposedClass(ClassReader cls, ExposedClass exposedCls) {
        if (cls.hasModifier(ElementModifier.INTERFACE)) {
            return;
        }
        if (cls.getParent() != null) {
            ExposedClass parent = this.getExposedClass(cls.getParent());
            exposedCls.inheritedMethods.putAll(parent.inheritedMethods);
            exposedCls.inheritedMethods.putAll(parent.methods);
            exposedCls.implementedInterfaces.addAll(parent.implementedInterfaces);
        }
        this.addInterfaces(exposedCls, cls);
    }

    private boolean addInterfaces(ExposedClass exposedCls, ClassReader cls) {
        boolean added = false;
        for (String ifaceName : cls.getInterfaces()) {
            ClassReader iface;
            if (exposedCls.implementedInterfaces.contains(ifaceName) || (iface = this.hierarchy.getClassSource().get(ifaceName)) == null || !this.addInterface(exposedCls, iface)) continue;
            added = true;
            for (MethodReader method : iface.getMethods()) {
                String nameStr;
                AnnotationValue nameVal;
                if (method.hasModifier(ElementModifier.STATIC) || method.getProgram() != null && method.getProgram().basicBlockCount() > 0 || exposedCls.inheritedMethods.containsKey(method.getDescriptor())) continue;
                String name = method.getName();
                AnnotationReader methodAnnot = method.getAnnotations().get(JSMethod.class.getName());
                if (methodAnnot != null && (nameVal = methodAnnot.getValue("value")) != null && !(nameStr = nameVal.getString()).isEmpty()) {
                    name = nameStr;
                }
                exposedCls.methods.put(method.getDescriptor(), name);
            }
        }
        return added;
    }

    private boolean addInterface(ExposedClass exposedCls, ClassReader cls) {
        if (cls.getName().equals(JSObject.class.getName())) {
            return true;
        }
        return this.addInterfaces(exposedCls, cls);
    }

    private void addFunctorField(ClassHolder cls, MethodReference method) {
        if (cls.getAnnotations().get(FunctorImpl.class.getName()) != null) {
            return;
        }
        FieldHolder field = new FieldHolder("$$jso_functor$$");
        field.setLevel(AccessLevel.PUBLIC);
        field.setType(ValueType.parse(JSObject.class));
        cls.addField(field);
        AnnotationHolder annot = new AnnotationHolder(FunctorImpl.class.getName());
        annot.getValues().put("value", new AnnotationValue(method.getDescriptor().toString()));
        cls.getAnnotations().add(annot);
    }

    static class ExposedClass {
        Map<MethodDescriptor, String> inheritedMethods = new HashMap<MethodDescriptor, String>();
        Map<MethodDescriptor, String> methods = new HashMap<MethodDescriptor, String>();
        Set<String> implementedInterfaces = new HashSet<String>();

        ExposedClass() {
        }
    }
}

