/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.annotation.scan;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.request.target.coding.BookmarkablePageRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.wicketstuff.annotation.mount.MountDefinition;
import org.wicketstuff.annotation.mount.MountPath;
import org.wicketstuff.annotation.scan.AnnotatedMountList;
import org.wicketstuff.config.MatchingResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedMountScanner {
    public String getPatternForPackage(String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageName = packageName.replace('.', '/')).endsWith("/")) {
            packageName = packageName + '/';
        }
        return "classpath*:" + packageName + "**/*.class";
    }

    public List<Class<?>> getPackageMatches(String pattern) {
        return this.getPatternMatches(this.getPatternForPackage(pattern));
    }

    public List<Class<?>> getPatternMatches(String pattern) {
        MatchingResources resources = new MatchingResources(pattern);
        List<Class<?>> mounts = resources.getAnnotatedMatches(MountPath.class);
        for (Class<?> mount : mounts) {
            if (Page.class.isAssignableFrom(mount)) continue;
            throw new RuntimeException("@MountPath annotated class should subclass Page: " + mount);
        }
        return mounts;
    }

    public AnnotatedMountList scanPackage(String packageName) {
        return this.scanList(this.getPackageMatches(packageName));
    }

    public AnnotatedMountList scanPattern(String pattern) {
        return this.scanList(this.getPatternMatches(pattern));
    }

    protected AnnotatedMountList scanList(List<Class<?>> mounts) {
        AnnotatedMountList list = new AnnotatedMountList();
        Iterator<Class<?>> i$ = mounts.iterator();
        while (i$.hasNext()) {
            Class<?> mount;
            Class<?> page = mount = i$.next();
            this.scanClass(page, list);
        }
        return list;
    }

    public AnnotatedMountList scanClass(Class<? extends Page> pageClass) {
        AnnotatedMountList list = new AnnotatedMountList();
        this.scanClass(pageClass, list);
        return list;
    }

    private void scanClass(Class<? extends Page> pageClass, AnnotatedMountList list) {
        MountPath mountPath = pageClass.getAnnotation(MountPath.class);
        if (mountPath == null) {
            return;
        }
        Annotation pageSpecificMountDetails = null;
        Class<?> mountStrategyAnnotationClass = null;
        MountDefinition mountDefinition = null;
        Annotation[] annos = pageClass.getAnnotations();
        for (Annotation anno : annos) {
            mountDefinition = anno.annotationType().getAnnotation(MountDefinition.class);
            if (mountDefinition == null) continue;
            pageSpecificMountDetails = anno;
            mountStrategyAnnotationClass = anno.getClass();
            break;
        }
        if (pageSpecificMountDetails == null) {
            list.add(this.getDefaultStrategy(mountPath.path(), pageClass));
            for (String alt : mountPath.alt()) {
                list.add(this.getDefaultStrategy(alt, pageClass));
            }
            return;
        }
        Class<? extends IRequestTargetUrlCodingStrategy> strategyClass = mountDefinition.strategyClass();
        int STANDARD_ARGS = 2;
        String[] argOrder = mountDefinition.argOrder();
        Class[] paramTypes = new Class[argOrder.length + STANDARD_ARGS];
        Object[] initArgs = new Object[paramTypes.length];
        paramTypes[0] = String.class;
        paramTypes[1] = Class.class;
        initArgs[0] = null;
        initArgs[1] = pageClass;
        for (int i = 0; i < argOrder.length; ++i) {
            int index = i + STANDARD_ARGS;
            Method method = null;
            try {
                method = mountStrategyAnnotationClass.getDeclaredMethod(argOrder[i], new Class[0]);
                paramTypes[index] = method.getReturnType();
                initArgs[index] = method.invoke((Object)pageSpecificMountDetails, new Object[0]);
                if (!initArgs[index].equals("[null]")) continue;
                initArgs[index] = null;
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("argOrder[" + i + "] = " + argOrder[i] + " not found in annotation " + mountStrategyAnnotationClass.getName(), e);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke method " + method + " on annotation " + pageSpecificMountDetails.getClass().getName(), e);
            }
        }
        Constructor<? extends IRequestTargetUrlCodingStrategy> ctx = null;
        try {
            ctx = strategyClass.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No constructor matching parameters defined by 'argOrder' found for " + strategyClass, e);
        }
        try {
            initArgs[0] = mountPath.path();
            list.add(ctx.newInstance(initArgs));
            for (String alt : mountPath.alt()) {
                initArgs[0] = alt;
                list.add(ctx.newInstance(initArgs));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke constructor " + ctx + " for " + strategyClass, e);
        }
    }

    public IRequestTargetUrlCodingStrategy getDefaultStrategy(String mountPath, Class<? extends Page> pageClass) {
        return new BookmarkablePageRequestTargetUrlCodingStrategy(mountPath, pageClass, null);
    }
}

