/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingResources {
    private static Logger logger = LoggerFactory.getLogger(MatchingResources.class);
    private Resource[] resources;
    private String pattern;

    public MatchingResources(String sPattern) {
        this.pattern = sPattern.replace('\\', '/');
        PathMatchingResourcePatternResolver match = new PathMatchingResourcePatternResolver();
        try {
            this.resources = match.getResources(this.pattern);
            logger.debug("Found " + this.resources.length + " resource(s) for: " + this.pattern);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Resource[] getAllMatches() {
        return this.resources;
    }

    public URL[] getAllMatchesURL() {
        URL[] urls = new URL[this.resources.length];
        for (int i = 0; i < this.resources.length; ++i) {
            urls[i] = this.getURL(this.resources[i]);
        }
        return urls;
    }

    public List<Class<?>> getAnnotatedMatches(Class<? extends Annotation> annotation, boolean includeSubclasses) {
        ArrayList matches = new ArrayList();
        SimpleMetadataReaderFactory f = new SimpleMetadataReaderFactory();
        for (Resource r : this.resources) {
            MetadataReader meta = null;
            try {
                meta = f.getMetadataReader(r);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get MetadataReader for " + r, e);
            }
            AnnotationMetadata anno = meta.getAnnotationMetadata();
            Set types = anno.getAnnotationTypes();
            if (!types.contains(annotation.getName()) && (!includeSubclasses || !this.anySuperHas(this.getClass(anno.getSuperClassName()), annotation))) continue;
            matches.add(this.getClass(anno.getClassName()));
        }
        return matches;
    }

    public List<Class<?>> getAnnotatedMatches(Class<? extends Annotation> annotation) {
        return this.getAnnotatedMatches(annotation, false);
    }

    private boolean anySuperHas(Class<?> clz, Class<? extends Annotation> annotation) {
        return clz != null && (clz.isAnnotationPresent(annotation) || this.anySuperHas(clz.getSuperclass(), annotation));
    }

    private Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Resource getSingleResource() {
        if (this.resources.length > 1) {
            throw new RuntimeException("Found more than one resource in classpath for " + this.pattern + ": " + this.toString());
        }
        if (this.resources.length == 0) {
            return null;
        }
        return this.resources[0];
    }

    public URL getSingleResourceURL() {
        Resource r = this.getSingleResource();
        if (r == null) {
            return null;
        }
        return this.getURL(r);
    }

    public Resource getSingleRequiredResource() {
        if (this.resources.length == 0) {
            throw new RuntimeException("Cound not find required resource for " + this.pattern);
        }
        if (this.resources.length > 1) {
            throw new RuntimeException("Found more than one resource in classpath for " + this.pattern + ": " + this.toString());
        }
        if (this.resources.length == 0) {
            return null;
        }
        return this.resources[0];
    }

    public URL getSingleRequiredResourceURL() {
        Resource r = this.getSingleRequiredResource();
        if (r == null) {
            return null;
        }
        return this.getURL(r);
    }

    public URL getURL(Resource r) {
        if (r == null) {
            return null;
        }
        try {
            return r.getURL();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Resource r : this.resources) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(this.getURL(r).toString());
        }
        return sb.toString();
    }
}

