/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.gradle;

import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.wildfly.swarm.plugin.gradle.PackageTask;
import org.wildfly.swarm.plugin.gradle.SwarmExtension;

public class PackagePlugin
implements Plugin<Project> {
    public static final String WILDFLY_SWARM_PACKAGE_TASK_NAME = "wildfly-swarm-package";
    public static final String SWARM_EXTENSION = "swarm";

    public void apply(Project project) {
        project.getExtensions().create(SWARM_EXTENSION, SwarmExtension.class, new Object[]{project});
        project.afterEvaluate(__ -> {
            TaskContainer tasks = project.getTasks();
            PackageTask packageTask = (PackageTask)tasks.create(WILDFLY_SWARM_PACKAGE_TASK_NAME, PackageTask.class);
            Jar archiveTask = this.getArchiveTask(project);
            if (archiveTask == null) {
                throw new GradleException("No suitable Archive-Task found to include in Swarm Uber-JAR.");
            }
            packageTask.jarTask(archiveTask).dependsOn(new Object[]{archiveTask});
            tasks.getByName("build").dependsOn(new Object[]{packageTask});
        });
    }

    private Jar getArchiveTask(Project project) {
        TaskCollection existingArchiveTasks = project.getTasks().withType(Jar.class);
        Jar customArchiveTask = ((SwarmExtension)project.getExtensions().getByType(SwarmExtension.class)).getArchiveTask();
        if (customArchiveTask != null) {
            return (Jar)existingArchiveTasks.getByName(customArchiveTask.getName());
        }
        if (existingArchiveTasks.findByName("war") != null) {
            return (Jar)existingArchiveTasks.getByName("war");
        }
        if (existingArchiveTasks.findByName("jar") != null) {
            return (Jar)existingArchiveTasks.getByName("jar");
        }
        return null;
    }
}

