/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.timeseries.PrimingDataLearner;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class HoltWinters
extends AbstractClassifier
implements PrimingDataLearner,
OptionHandler,
Serializable {
    private static final long serialVersionUID = -4478856847945888899L;
    protected double m_alpha = 0.2;
    protected double m_beta = 0.2;
    protected double m_gamma = 0.2;
    protected int m_seasonCycleLength = 12;
    protected boolean m_includeSeason = true;
    protected boolean m_includeTrend = true;
    protected double[] m_c;
    protected double[] m_twoSeasonsOfY;
    protected int m_counter;
    protected double m_sPrev;
    protected double m_bPrev;
    protected double m_s;
    protected double m_b;

    public String globalInfo() {
        return "Class implementing the Holt-Winters triple exponential smoothing method. Use the max lag length option in the time series forecasting environment to control how many of the most recent training data instances are used for estimating the initial parameters and smoothing. If not specified manually, the max lag will be set to 3 * seasonal cycle length";
    }

    @Override
    public void reset() {
        this.m_sPrev = Utils.missingValue();
        this.m_bPrev = Utils.missingValue();
        this.m_s = Utils.missingValue();
        this.m_b = Utils.missingValue();
        this.m_c = new double[this.m_seasonCycleLength];
        this.m_twoSeasonsOfY = new double[2 * this.m_seasonCycleLength];
        this.m_counter = 0;
    }

    @Override
    public int getMinRequiredTrainingPoints() {
        return 3 * this.m_seasonCycleLength;
    }

    protected void update(double value) {
        double seasonAdjust = this.m_includeSeason ? this.m_c[this.m_counter % this.m_seasonCycleLength] : 1.0;
        double trendAdjust = this.m_includeTrend ? this.m_bPrev : 0.0;
        this.m_s = this.m_alpha * value / seasonAdjust + (1.0 - this.m_alpha) * (this.m_sPrev + trendAdjust);
        if (this.m_includeTrend) {
            this.m_b = this.m_beta * (this.m_s - this.m_sPrev) + (1.0 - this.m_beta) * this.m_bPrev;
        }
        if (this.m_includeSeason) {
            this.m_c[this.m_counter % this.m_seasonCycleLength] = this.m_gamma * value / this.m_s + (1.0 - this.m_gamma) * this.m_c[this.m_counter % this.m_seasonCycleLength];
        }
        ++this.m_counter;
        this.m_sPrev = this.m_s;
        this.m_bPrev = this.m_b;
    }

    protected void initialize() {
        double[] obsFirstYear = new double[this.m_seasonCycleLength];
        System.arraycopy(this.m_twoSeasonsOfY, 0, obsFirstYear, 0, this.m_seasonCycleLength);
        double sum = Utils.sum((double[])obsFirstYear);
        this.m_sPrev = sum / (double)this.m_seasonCycleLength;
        double[] obsSecondYear = new double[this.m_seasonCycleLength];
        System.arraycopy(this.m_twoSeasonsOfY, this.m_seasonCycleLength, obsSecondYear, 0, this.m_seasonCycleLength);
        sum = Utils.sum((double[])obsSecondYear);
        double avgSecondYear = sum / (double)this.m_seasonCycleLength;
        this.m_bPrev = (this.m_sPrev - avgSecondYear) / (double)this.m_seasonCycleLength;
        for (int i = 1; i <= this.m_seasonCycleLength; ++i) {
            this.m_c[i - 1] = (this.m_twoSeasonsOfY[i - 1] - (double)(i - 1) * this.m_bPrev / 2.0) / this.m_sPrev;
        }
    }

    @Override
    public void updateForecaster(double primingOrPredictedTargetValue) {
        if (this.m_counter < 2 * this.m_seasonCycleLength) {
            if (!Utils.isMissingValue((double)primingOrPredictedTargetValue)) {
                this.m_twoSeasonsOfY[this.m_counter++] = primingOrPredictedTargetValue;
            }
            return;
        }
        if (this.m_counter == 2 * this.m_seasonCycleLength) {
            this.initialize();
        }
        if (this.m_counter >= 2 * this.m_seasonCycleLength && !Utils.isMissingValue((double)primingOrPredictedTargetValue)) {
            this.update(primingOrPredictedTargetValue);
        }
    }

    public double forecast() throws Exception {
        if (this.m_counter < this.m_seasonCycleLength * 2) {
            throw new Exception("Haven't seen enough training data to make a forecast yet");
        }
        double result = (this.m_s + (this.m_includeTrend ? this.m_b : 0.0)) * (this.m_includeSeason ? this.m_c[this.m_counter % this.m_seasonCycleLength] : 1.0);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.reset();
        for (int i = 0; i < data.numInstances(); ++i) {
            this.updateForecaster(data.instance(i).classValue());
        }
    }

    public double classifyInstance(Instance inst) throws Exception {
        return this.forecast();
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> opts = new Vector<Option>();
        opts.add(new Option("\tExclude trend correction.", "no-trend", 0, "no-trend"));
        opts.add(new Option("\tExclude seasonal correction.", "no-season", 0, "no-season"));
        opts.add(new Option("\tSet the value smoothing factor (default = 0.2)", "alpha", 1, "-alpha <number>"));
        opts.add(new Option("\tSet the trend smoothing factor (default = 0.2)", "beta", 1, "-beta <number>"));
        opts.add(new Option("\tSet the seasonal smoothing factor (default = 0.2)", "gamma", 1, "-gamma <number>"));
        opts.add(new Option("\tSet the season cycle length (default = 12 (for monthly data))", "cycle-length", 1, "-cycle-length <integer>"));
        return opts.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setExcludeTrendCorrection(Utils.getFlag((String)"no-trend", (String[])options));
        this.setExcludeSeasonalCorrection(Utils.getFlag((String)"no-season", (String[])options));
        String val = Utils.getOption((String)"alpha", (String[])options);
        if (val.length() > 0) {
            this.setValueSmoothingFactor(Double.parseDouble(val));
        }
        if ((val = Utils.getOption((String)"beta", (String[])options)).length() > 0) {
            this.setTrendSmoothingFactor(Double.parseDouble(val));
        }
        if ((val = Utils.getOption((String)"gamma", (String[])options)).length() > 0) {
            this.setSeasonalSmoothingFactor(Double.parseDouble(val));
        }
        if ((val = Utils.getOption((String)"cycle-length", (String[])options)).length() > 0) {
            this.setSeasonCycleLength(Integer.parseInt(val));
        }
    }

    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.getExcludeTrendCorrection()) {
            options.add("-no-trend");
        }
        if (this.getExcludeSeasonalCorrection()) {
            options.add("-no-season");
        }
        options.add("-alpha");
        options.add("" + this.getValueSmoothingFactor());
        options.add("-beta");
        options.add("" + this.getTrendSmoothingFactor());
        options.add("-gamma");
        options.add("" + this.getSeasonalSmoothingFactor());
        options.add("cycle-length");
        options.add("" + this.getSeasonCycleLength());
        return options.toArray(new String[options.size()]);
    }

    public String seasonCycleLengthTipText() {
        return "The length of the seasonal cycle (e.g. 12 for monthly data; 4 for quarterly data)";
    }

    public void setSeasonCycleLength(int length) {
        this.m_seasonCycleLength = length;
    }

    public int getSeasonCycleLength() {
        return this.m_seasonCycleLength;
    }

    public String excludeSeasonalCorrectionTipText() {
        return "Don't include the seasonal correction";
    }

    public void setExcludeSeasonalCorrection(boolean s) {
        this.m_includeSeason = !s;
    }

    public boolean getExcludeSeasonalCorrection() {
        return !this.m_includeSeason;
    }

    public String excludeTrendCorrection() {
        return "Don't include the trend correction";
    }

    public void setExcludeTrendCorrection(boolean t) {
        this.m_includeTrend = !t;
    }

    public boolean getExcludeTrendCorrection() {
        return !this.m_includeTrend;
    }

    public String valueSmoothingFactorTipText() {
        return "The smoothing factor, between 0 and 1, for the series values";
    }

    public void setValueSmoothingFactor(double s) {
        this.m_alpha = s;
    }

    public double getValueSmoothingFactor() {
        return this.m_alpha;
    }

    public String trendSmoothingFactorTipText() {
        return "The smoothing factor, between 0 and 1, for the trend";
    }

    public void setTrendSmoothingFactor(double t) {
        this.m_beta = t;
    }

    public double getTrendSmoothingFactor() {
        return this.m_beta;
    }

    public String seasonalSmoothingFactorTipText() {
        return "The smoothing factor, between 0 and 1, for the seasonal component";
    }

    public void setSeasonalSmoothingFactor(double s) {
        this.m_gamma = s;
    }

    public double getSeasonalSmoothingFactor() {
        return this.m_gamma;
    }

    public static void printUsage() {
        HoltWinters h = new HoltWinters();
        StringBuffer result = new StringBuffer();
        result.append("General options:\n\n-t <training data>\n\tThe training data ARFF file to use\n");
        result.append("-c <class index>\n\tThe index of the series to model\n");
        result.append("-f <integer>\n\tThe number of time steps to forecast beyond the end of the series\n");
        result.append("\n");
        result.append(h.getClass().getName().replaceAll(".*\\.", ""));
        result.append(" options:\n\n");
        Enumeration enm = h.listOptions();
        while (enm.hasMoreElements()) {
            Option option = (Option)enm.nextElement();
            result.append(option.synopsis() + "\n");
            result.append(option.description() + "\n");
        }
        System.err.println(result.toString());
    }

    public String toString() {
        return "Holt-Winters triple exponential smoothing.\n\tValue smoothing factor: " + this.m_alpha + "\n\tTrend smoothing factor: " + this.m_beta + "\n\tSeasonal " + "smoothing factor: " + this.m_gamma + "\n\tSeason cycle length: " + this.m_seasonCycleLength + "\n\n";
    }

    public static void main(String[] args) {
        try {
            String trainingData;
            HoltWinters h = new HoltWinters();
            if (Utils.getFlag((char)'h', (String[])args) || Utils.getFlag((String)"help", (String[])args)) {
                System.err.println("Help requested\n\n");
                HoltWinters.printUsage();
                System.exit(1);
            }
            if ((trainingData = Utils.getOption((char)'t', (String[])args)).length() == 0) {
                System.err.println("No training set specified!\n\n");
                HoltWinters.printUsage();
                System.exit(1);
            }
            Instances train = new Instances((Reader)new BufferedReader(new FileReader(trainingData)));
            String classIndex = Utils.getOption((char)'c', (String[])args);
            int classToUse = 0;
            if (classIndex.length() > 0) {
                if (classIndex.toLowerCase().equals("first")) {
                    classToUse = 0;
                } else if (classIndex.toLowerCase().equals("last")) {
                    classToUse = train.numAttributes() - 1;
                } else {
                    classToUse = Integer.parseInt(classIndex);
                    --classToUse;
                }
            }
            int horizon = 1;
            String horizS = Utils.getOption((char)'f', (String[])args);
            if (horizS.length() > 0) {
                horizon = Integer.parseInt(horizS);
            }
            train.setClassIndex(classToUse);
            h.buildClassifier(train);
            for (int i = 0; i < horizon; ++i) {
                double v = h.forecast();
                System.out.println("" + Utils.doubleToString((double)v, (int)4));
                h.update(v);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

