/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.core;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.timeseries.core.CustomPeriodicTest;
import weka.classifiers.timeseries.core.TimeSeriesTranslate;
import weka.classifiers.timeseries.core.Utils;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;
import weka.filters.unsupervised.attribute.AddExpression;
import weka.filters.unsupervised.attribute.AddID;
import weka.filters.unsupervised.attribute.Copy;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.RenameAttribute;

public class TSLagMaker
implements Serializable {
    private static final long serialVersionUID = -1697901820770907975L;
    protected List<String> m_fieldsToLag = null;
    protected List<String> m_overlayFields = null;
    protected int m_minLag = 1;
    protected int m_maxLag = 12;
    protected String m_lagFineTune = "";
    protected boolean m_averageConsecutiveLongLags = false;
    protected int m_averageLagsAfter = 2;
    protected int m_numConsecutiveToAverage = 2;
    protected String m_timeStampName = "";
    protected boolean m_adjustForTrends = true;
    protected boolean m_adjustForVariance = false;
    protected boolean m_useArtificialTimeIndex = false;
    protected boolean m_includeTimeLagCrossProducts = true;
    protected boolean m_includePowersOfTime = true;
    protected double m_lastTimeValue = -1.0;
    protected AddID m_artificialTimeMaker;
    protected List<Filter> m_varianceAdjusters;
    protected List<Filter> m_lagMakers;
    protected List<Filter> m_averagedLagMakers;
    protected List<Filter> m_timeIndexMakers;
    protected List<Filter> m_timeLagCrossProductMakers;
    protected Remove m_extraneousAttributeRemover;
    protected String m_primaryPeriodicName = "";
    protected Map<String, String> m_primaryPeriodicSequence;
    protected Map<Attribute, Map<String, String>> m_secondaryPeriodicLookups;
    protected Instances m_originalHeader;
    protected Instance m_lastHistoricInstance;
    protected boolean m_am = false;
    protected boolean m_dayOfWeek = false;
    protected boolean m_weekend = false;
    protected boolean m_monthOfYear = false;
    protected boolean m_quarter = false;
    protected boolean m_dayOfMonth = false;
    protected boolean m_numDaysInMonth = false;
    protected Map<String, ArrayList<CustomPeriodicTest>> m_customPeriodics;
    protected List<Filter> m_derivedPeriodicMakers;
    protected PeriodicityHandler m_dateBasedPeriodicity = new PeriodicityHandler();
    protected Periodicity m_userHintPeriodicity = null;
    protected boolean m_deleteMissingFromStartOfSeries;
    protected long m_dateTimeStampBase;
    protected Add m_addDateMap;
    protected String m_skipEntries;
    protected String m_dateFormat = "yyyy-MM-dd'T'HH:mm:ss";

    public static PeriodicityHandler determinePeriodicity(Instances insts, String timeName, Periodicity userHint) {
        double fiveMins = 300000.0;
        double oneHour = 3600000.0;
        double oneDay = oneHour * 24.0;
        double oneWeek = oneDay * 7.0;
        double thirtyDays = oneHour * 24.0 * 30.0;
        double approxQuarter = thirtyDays * 3.0;
        double oneYear = oneDay * 365.0;
        double averageDelta = weka.core.Utils.missingValue();
        int timeIndex = insts.attribute(timeName).index();
        PeriodicityHandler result = new PeriodicityHandler();
        if (timeIndex < 0) {
            result.setPeriodicity(Periodicity.UNKNOWN);
            result.setDeltaTime(weka.core.Utils.missingValue());
            return result;
        }
        if (userHint != null && userHint != Periodicity.UNKNOWN && insts.attribute(timeIndex).isDate()) {
            result.setPeriodicity(userHint);
            switch (userHint) {
                case HOURLY: {
                    result.setDeltaTime(oneHour);
                    break;
                }
                case DAILY: {
                    result.setDeltaTime(oneDay);
                    break;
                }
                case WEEKLY: {
                    result.setDeltaTime(oneWeek);
                    break;
                }
                case YEARLY: {
                    result.setDeltaTime(oneYear);
                }
            }
            long initialTS = (long)insts.instance(0).value(timeIndex);
            long finalTS = (long)insts.instance(insts.numInstances() - 1).value(timeIndex);
            result.setDateTimeStampInitial(initialTS);
            result.setDateTimeStampFinal(finalTS);
            return result;
        }
        ArrayList<Double> deltas = new ArrayList<Double>();
        for (int i = 1; i < insts.numInstances(); ++i) {
            if (insts.instance(i).isMissing(timeIndex) || insts.instance(i - 1).isMissing(timeIndex)) continue;
            deltas.add(new Double(insts.instance(i).value(timeIndex) - insts.instance(i - 1).value(timeIndex)));
        }
        double previousDelta = -1.0;
        double deltaSum = 0.0;
        for (int i = 0; i < deltas.size(); ++i) {
            if (i == 0) {
                previousDelta = (Double)deltas.get(i);
                deltaSum += previousDelta;
                continue;
            }
            double currentDelta = (Double)deltas.get(i);
            if (currentDelta - previousDelta != 0.0) {
                // empty if block
            }
            previousDelta = currentDelta;
            deltaSum += currentDelta;
        }
        averageDelta = deltaSum /= (double)deltas.size();
        if (insts.attribute(timeIndex).isDate()) {
            long initialTS = (long)insts.instance(0).value(timeIndex);
            long finalTS = (long)insts.instance(insts.numInstances() - 1).value(timeIndex);
            if (Math.abs(oneHour - averageDelta) <= fiveMins) {
                result.setPeriodicity(Periodicity.HOURLY);
                result.setDeltaTime(oneHour);
                result.setDateTimeStampInitial(initialTS);
                result.setDateTimeStampFinal(finalTS);
                return result;
            }
            if (Math.abs(oneDay - averageDelta) <= oneHour) {
                result.setPeriodicity(Periodicity.DAILY);
                result.setDeltaTime(oneDay);
                result.setDateTimeStampInitial(initialTS);
                result.setDateTimeStampFinal(finalTS);
                return result;
            }
            if (Math.abs(oneWeek - averageDelta) <= oneDay / 4.0) {
                result.setPeriodicity(Periodicity.WEEKLY);
                result.setDeltaTime(oneWeek);
                result.setDateTimeStampInitial(initialTS);
                result.setDateTimeStampFinal(finalTS);
                return result;
            }
            if (Math.abs(thirtyDays - averageDelta) <= oneDay * 3.0) {
                result.setPeriodicity(Periodicity.MONTHLY);
                result.setDeltaTime(thirtyDays);
                result.setDateTimeStampInitial(initialTS);
                result.setDateTimeStampFinal(finalTS);
                return result;
            }
            if (Math.abs(approxQuarter - averageDelta) <= oneWeek) {
                result.setPeriodicity(Periodicity.QUARTERLY);
                result.setDeltaTime(approxQuarter);
                result.setDateTimeStampInitial(initialTS);
                result.setDateTimeStampFinal(finalTS);
                return result;
            }
            if (Math.abs(oneYear - averageDelta) <= oneDay * 2.0) {
                result.setPeriodicity(Periodicity.YEARLY);
                result.setDeltaTime(oneYear);
                result.setDateTimeStampInitial(initialTS);
                result.setDateTimeStampFinal(finalTS);
                return result;
            }
            result.setPeriodicity(Periodicity.UNKNOWN);
            result.setIsDateBased(true);
            result.setDeltaTime(averageDelta);
            result.setDateTimeStampInitial(initialTS);
            result.setDateTimeStampFinal(finalTS);
            return result;
        }
        result.setPeriodicity(Periodicity.UNKNOWN);
        result.setIsDateBased(false);
        result.setDeltaTime(averageDelta);
        return result;
    }

    public void reset() {
        this.m_artificialTimeMaker = null;
        this.m_varianceAdjusters = null;
        this.m_lagMakers = null;
        this.m_averagedLagMakers = null;
        this.m_timeIndexMakers = null;
        this.m_timeLagCrossProductMakers = null;
        this.m_derivedPeriodicMakers = null;
        this.m_extraneousAttributeRemover = null;
        this.m_lastTimeValue = -1.0;
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.add(new Option("\tSet the fields to lag.", "F", 1, "-F <comma separated list of names>"));
        newVector.add(new Option("\tSet the fields to be considered as overlay data.", "overlay", 1, "-overlay <comma separated list of names>"));
        newVector.add(new Option("\tSet the minimum lag length to generate.\n\t(default = 1)", "L", 1, "-L <num>"));
        newVector.add(new Option("\tSet the maximum lag length to generate.\n\t(default = 12)", "M", 1, "-M <num>"));
        newVector.add(new Option("\tRemove leading instances where the values of lagged variables are unknown", "trim-leading", 0, "-trim-leading"));
        newVector.add(new Option("\tAverage consecutive long lags.", "A", 0, "-A"));
        newVector.add(new Option("\tAverage those lags longer than this number oftime steps.\n\tUse in conjuction with -A is selected.\n\t(default = 2)", "B", 1, "-B <num>"));
        newVector.add(new Option("\tFine tune selection of lags within min and max by specifying ranges", "R", 1, "-R <ranges>"));
        newVector.add(new Option("\tAverage this many consecutive long lags.\n\tUse in conjuction with -B (default = 2)", "C", 1, "-C <num>"));
        newVector.add(new Option("\tDon't adjust for trends.", "Z", 0, "-Z"));
        newVector.add(new Option("\tDon't include time powers of time", "no-powers-of-time", 1, "-no-powers-of-time"));
        newVector.add(new Option("\tDon't include time lag products", "no-time-lag-products", 1, "-no-time-lag-products"));
        newVector.add(new Option("\tSpecify the name of the timestamp field", "G", 1, "-G <timestamp name>"));
        newVector.add(new Option("\tAdjust for variance.", "V", 0, "-V"));
        newVector.add(new Option("\tAdd an AM/PM indicator (requires a date timestamp)", "am-pm", 0, "-am-pm"));
        newVector.add(new Option("\tAdd a day of the week field (requres a date timestamp)", "dayofweek", 0, "-dayofweek"));
        newVector.add(new Option("\tAdd a day of the month field (requres a date timestamp)", "dayofmonth", 0, "-dayofmonth"));
        newVector.add(new Option("\tAdd a number of days in the month field (requres a date timestamp)", "numdaysinmonth", 0, "-numdaysinmonth"));
        newVector.add(new Option("\tAdd a weekend indicator (requires a date timestamp)", "weekend", 0, "-weekend"));
        newVector.add(new Option("\tAdd a month field (requires a date timestamp)", "month", 0, "-month"));
        newVector.add(new Option("\tAdd a quarter of the year field (requires a date timestamp)", "quarter", 0, "-quarter"));
        newVector.add(new Option("\tAdd a custom date-derived boolean field (requires a date timestamp).\n\tFormat: \"fieldName=Test Test|Test Test| ...\n\twhere Test=OPERATORyear:month:week-of-yr:week-of-month:day-of-yr:day-of-month:day-of-week:hour:min:second\n\te.g.XmasHoliday=>:dec::::24::: <:jan::::3:::\n\tLegal OPERATORs are =,>,<,>=,<=. For = operator only\n\tone Test is needed rather than a pair.\n\tThis option may be specified more than once on the command line\n\tin order to define multiple variables.", "custom", 1, "-custom"));
        newVector.add(new Option("\tAdd a comma-separated 'skip' list of dates that should not\n\tbe considered as a time step. Days of the week,\n\tmonths of the year, 'weekend', integers (indicating day of year\n\t, hour of day etc.) or specific dates are all valid entries.\n\tE.g sat,sun,27-08-2011,28-08-2011", "skip", 1, "-skip"));
        return newVector.elements();
    }

    protected Range getLagRangeSelection(String lagRange) throws Exception {
        Range r = new Range(lagRange);
        try {
            r.setUpper(this.m_maxLag);
        }
        catch (IllegalArgumentException e) {
            throw new Exception("The lag selection range '" + lagRange + "' is" + "illegal with respect to the specified min and max" + "lags.");
        }
        int[] selectedIndexes = r.getSelection();
        int max = selectedIndexes[weka.core.Utils.maxIndex((int[])selectedIndexes)] + 1;
        int min = selectedIndexes[weka.core.Utils.minIndex((int[])selectedIndexes)] + 1;
        if (max < this.m_minLag || min > this.m_maxLag) {
            throw new Exception("The lag selection range '" + lagRange + "' is" + "illegal with respect to the specified min and max" + "lags.");
        }
        return r;
    }

    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        List<String> fieldsToLag = this.getFieldsToLag();
        options.add("-F");
        options.add(fieldsToLag.toString());
        if (this.getOverlayFields() != null && this.getOverlayFields().size() > 0) {
            options.add("-O");
            options.add(this.getOverlayFields().toString());
        }
        if (this.getRemoveLeadingInstancesWithUnknownLagValues()) {
            options.add("-trim-leading");
        }
        options.add("-L");
        options.add("" + this.getMinLag());
        options.add("-M");
        options.add("" + this.getMaxLag());
        if (this.m_lagFineTune.length() > 0) {
            options.add("-R");
            options.add(this.getLagRange());
        }
        if (this.getAverageConsecutiveLongLags()) {
            options.add("-A");
            options.add("-B");
            options.add("" + this.getAverageLagsAfter());
            options.add("-C");
            options.add("" + this.getNumConsecutiveLongLagsToAverage());
        }
        if (!this.getAdjustForTrends()) {
            options.add("-Z");
        }
        if (!this.getIncludeTimeLagProducts()) {
            options.add("-no-time-lag_products");
        }
        if (!this.getIncludeTimeLagProducts()) {
            options.add("-no-powers-of-time");
        }
        if (this.getAdjustForVariance()) {
            options.add("-V");
        }
        if (this.getTimeStampField() != null && this.getTimeStampField().length() > 0) {
            options.add("-G");
            options.add(this.getTimeStampField());
        }
        if (this.getAddAMIndicator()) {
            options.add("-am-pm");
        }
        if (this.getAddDayOfWeek()) {
            options.add("-dayofweek");
        }
        if (this.getAddDayOfMonth()) {
            options.add("-dayofmonth");
        }
        if (this.getAddNumDaysInMonth()) {
            options.add("-numdaysinmonth");
        }
        if (this.getAddWeekendIndicator()) {
            options.add("-weekend");
        }
        if (this.getAddMonthOfYear()) {
            options.add("-month");
        }
        if (this.getAddQuarterOfYear()) {
            options.add("-quarter");
        }
        if (this.getSkipEntries() != null && this.getSkipEntries().length() > 0) {
            options.add("-skip");
            options.add(this.getSkipEntries());
        }
        if (this.m_customPeriodics != null && this.m_customPeriodics.keySet().size() > 0) {
            for (String name : this.m_customPeriodics.keySet()) {
                List tests = this.m_customPeriodics.get(name);
                options.add("-custom");
                StringBuffer tempBuff = new StringBuffer();
                tempBuff.append("\"");
                for (int i = 0; i < tests.size(); ++i) {
                    tempBuff.append(((CustomPeriodicTest)tests.get(i)).toString());
                    if (i < tests.size() - 1) {
                        tempBuff.append("|");
                        continue;
                    }
                    tempBuff.append("\"");
                }
                options.add(tempBuff.toString());
            }
        }
        return options.toArray(new String[1]);
    }

    public void setOptions(String[] options) throws Exception {
        String skipString;
        boolean dontAdjTrends;
        String consecutiveLongLagS;
        String lagRange;
        String maxL;
        String fieldsToLag = weka.core.Utils.getOption((char)'F', (String[])options);
        if (fieldsToLag.length() == 0) {
            throw new Exception("Must specify the name of at least one field to create lags for!");
        }
        String[] fieldNames = fieldsToLag.split(",");
        ArrayList<String> fieldList = new ArrayList<String>();
        for (String f : fieldNames) {
            fieldList.add(f);
        }
        this.setFieldsToLag(fieldList);
        String overlayFields = weka.core.Utils.getOption((String)"overlay", (String[])options);
        if (overlayFields.length() > 0) {
            String[] names = overlayFields.split(",");
            ArrayList<String> nameList = new ArrayList<String>();
            for (String f : names) {
                nameList.add(f);
            }
            this.setOverlayFields(nameList);
        }
        this.setRemoveLeadingInstancesWithUnknownLagValues(weka.core.Utils.getFlag((String)"trim-leading", (String[])options));
        String minL = weka.core.Utils.getOption((char)'L', (String[])options);
        if (minL.length() > 0) {
            int mL = Integer.parseInt(minL);
            this.setMinLag(mL);
            if (mL < 1) {
                throw new Exception("Minimum lag can't be less than 1!");
            }
        }
        if ((maxL = weka.core.Utils.getOption((char)'M', (String[])options)).length() > 0) {
            int mL = Integer.parseInt(maxL);
            this.setMaxLag(mL);
        }
        if (this.getMaxLag() < this.getMinLag()) {
            throw new Exception("Can't have the maximum lag set lower than the minimum lag!");
        }
        this.m_lagFineTune = lagRange = weka.core.Utils.getOption((char)'R', (String[])options);
        if (this.m_lagFineTune.length() > 0) {
            this.getLagRangeSelection(lagRange);
        }
        boolean avLongLags = weka.core.Utils.getFlag((char)'A', (String[])options);
        this.setAverageConsecutiveLongLags(avLongLags);
        String avLongerThan = weka.core.Utils.getOption((char)'B', (String[])options);
        if (avLongerThan.length() > 0) {
            int avL = Integer.parseInt(avLongerThan);
            if (avL < this.getMinLag() || avL > this.getMaxLag()) {
                throw new Exception("Average consecutive long lags value can't be less than the minimum lag or greater than the maximum lag!");
            }
            this.setAverageLagsAfter(avL);
        }
        if ((consecutiveLongLagS = weka.core.Utils.getOption((char)'C', (String[])options)).length() > 0) {
            int consecutive = Integer.parseInt(consecutiveLongLagS);
            if (consecutive < 1 || consecutive > this.getMaxLag() - this.getMinLag()) {
                throw new Exception("Number of consecutive long lags to average must be greater than 0 and less than " + (this.getMaxLag() - this.getMinLag()));
            }
            this.setNumConsecutiveLongLagsToAverage(consecutive);
        }
        this.setAdjustForTrends(!(dontAdjTrends = weka.core.Utils.getFlag((char)'Z', (String[])options)));
        boolean noTimeLagProds = weka.core.Utils.getFlag((String)"no-time-lag-products", (String[])options);
        this.setIncludeTimeLagProducts(!noTimeLagProds);
        boolean noPowersOfTime = weka.core.Utils.getFlag((String)"no-powers-of-time", (String[])options);
        this.setIncludePowersOfTime(noPowersOfTime);
        boolean adjVariance = weka.core.Utils.getFlag((String)"V", (String[])options);
        this.setAdjustForVariance(adjVariance);
        String timeStampF = weka.core.Utils.getOption((char)'G', (String[])options);
        if (timeStampF.length() > 0) {
            this.setTimeStampField(timeStampF);
        }
        this.setAddAMIndicator(weka.core.Utils.getFlag((String)"am-pm", (String[])options));
        this.setAddDayOfWeek(weka.core.Utils.getFlag((String)"dayofweek", (String[])options));
        this.setAddDayOfMonth(weka.core.Utils.getFlag((String)"dayofmonth", (String[])options));
        this.setAddNumDaysInMonth(weka.core.Utils.getFlag((String)"numdaysinmonth", (String[])options));
        this.setAddWeekendIndicator(weka.core.Utils.getFlag((String)"weekend", (String[])options));
        this.setAddMonthOfYear(weka.core.Utils.getFlag((String)"month", (String[])options));
        this.setAddQuarterOfYear(weka.core.Utils.getFlag((String)"quarter", (String[])options));
        String customPeriodic = weka.core.Utils.getOption((String)"custom", (String[])options);
        while (customPeriodic.length() > 0) {
            this.addCustomPeriodic(customPeriodic);
        }
        String primaryPeriodicN = weka.core.Utils.getOption((String)"periodic", (String[])options);
        if (primaryPeriodicN.length() > 0) {
            this.setPrimaryPeriodicFieldName(primaryPeriodicN);
        }
        if ((skipString = weka.core.Utils.getOption((String)"skip", (String[])options)).length() > 0) {
            this.setSkipEntries(skipString);
        }
    }

    public Map<String, ArrayList<CustomPeriodicTest>> getCustomPeriodics() {
        return this.m_customPeriodics;
    }

    public void setCustomPeriodics(Map<String, ArrayList<CustomPeriodicTest>> custom) {
        this.m_customPeriodics = custom;
    }

    public void addCustomPeriodic(String customPeriodic) {
        String[] parts;
        if (this.m_customPeriodics == null) {
            this.m_customPeriodics = new HashMap<String, ArrayList<CustomPeriodicTest>>();
        }
        ArrayList<CustomPeriodicTest> tests = new ArrayList<CustomPeriodicTest>();
        int nameSplit = customPeriodic.indexOf(61);
        String fieldName = customPeriodic.substring(0, nameSplit);
        customPeriodic = customPeriodic.substring(nameSplit + 1, customPeriodic.length());
        for (String p : parts = customPeriodic.split("|")) {
            CustomPeriodicTest c = new CustomPeriodicTest(p);
            tests.add(c);
        }
        this.m_customPeriodics.put(fieldName, tests);
    }

    public void clearCustomPeriodics() {
        this.m_customPeriodics = null;
    }

    public List<String> getFieldsToLag() {
        return this.m_fieldsToLag;
    }

    public void setFieldsToLag(List<String> names) throws Exception {
        this.m_fieldsToLag = names;
    }

    public List<String> getOverlayFields() {
        return this.m_overlayFields;
    }

    public void setOverlayFields(List<String> overlayNames) {
        this.m_overlayFields = overlayNames;
    }

    public String getTimeStampField() {
        return this.m_timeStampName;
    }

    public void setTimeStampField(String name) {
        this.m_timeStampName = name;
    }

    public boolean getRemoveLeadingInstancesWithUnknownLagValues() {
        return this.m_deleteMissingFromStartOfSeries;
    }

    public void setRemoveLeadingInstancesWithUnknownLagValues(boolean b) {
        this.m_deleteMissingFromStartOfSeries = b;
    }

    public boolean getAdjustForTrends() {
        return this.m_adjustForTrends;
    }

    public void setAdjustForTrends(boolean a) {
        this.m_adjustForTrends = a;
    }

    public boolean getIncludeTimeLagProducts() {
        return this.m_includeTimeLagCrossProducts;
    }

    public void setIncludeTimeLagProducts(boolean includeTimeLagProducts) {
        this.m_includeTimeLagCrossProducts = includeTimeLagProducts;
    }

    public boolean getIncludePowersOfTime() {
        return this.m_includePowersOfTime;
    }

    public void setIncludePowersOfTime(boolean p) {
        this.m_includePowersOfTime = p;
    }

    public boolean getAdjustForVariance() {
        return this.m_adjustForVariance;
    }

    public void setAdjustForVariance(boolean v) {
        this.m_adjustForVariance = v;
    }

    public String getFineTuneLags() {
        return this.m_lagFineTune;
    }

    public void setFineTuneLags(String ranges) {
        this.m_lagFineTune = ranges;
    }

    public int getMinLag() {
        return this.m_minLag;
    }

    public void setMinLag(int min) {
        this.m_minLag = min;
    }

    public int getMaxLag() {
        return this.m_maxLag;
    }

    public void setMaxLag(int max) {
        this.m_maxLag = max;
    }

    public String getLagRange() {
        return this.m_lagFineTune;
    }

    public void setLagRange(String lagRange) {
        this.m_lagFineTune = lagRange;
    }

    public boolean getAverageConsecutiveLongLags() {
        return this.m_averageConsecutiveLongLags;
    }

    public void setAverageConsecutiveLongLags(boolean avg) {
        this.m_averageConsecutiveLongLags = avg;
    }

    public int getAverageLagsAfter() {
        return this.m_averageLagsAfter;
    }

    public void setAverageLagsAfter(int a) {
        this.m_averageLagsAfter = a;
    }

    public int getNumConsecutiveLongLagsToAverage() {
        return this.m_numConsecutiveToAverage;
    }

    public void setNumConsecutiveLongLagsToAverage(int c) {
        this.m_numConsecutiveToAverage = c;
    }

    public String getPrimaryPeriodicFieldName() {
        return this.m_primaryPeriodicName;
    }

    public void setPrimaryPeriodicFieldName(String p) {
        this.m_primaryPeriodicName = p;
    }

    public boolean getAddAMIndicator() {
        return this.m_am;
    }

    public void setAddAMIndicator(boolean am) {
        this.m_am = am;
    }

    public boolean getAddDayOfWeek() {
        return this.m_dayOfWeek;
    }

    public void setAddDayOfWeek(boolean d) {
        this.m_dayOfWeek = d;
    }

    public boolean getAddDayOfMonth() {
        return this.m_dayOfMonth;
    }

    public void setAddDayOfMonth(boolean d) {
        this.m_dayOfMonth = d;
    }

    public boolean getAddNumDaysInMonth() {
        return this.m_numDaysInMonth;
    }

    public void setAddNumDaysInMonth(boolean d) {
        this.m_numDaysInMonth = d;
    }

    public boolean getAddWeekendIndicator() {
        return this.m_weekend;
    }

    public void setAddWeekendIndicator(boolean w) {
        this.m_weekend = w;
    }

    public boolean getAddMonthOfYear() {
        return this.m_monthOfYear;
    }

    public void setAddMonthOfYear(boolean m) {
        this.m_monthOfYear = m;
    }

    public boolean getAddQuarterOfYear() {
        return this.m_quarter;
    }

    public void setAddQuarterOfYear(boolean q) {
        this.m_quarter = q;
    }

    public boolean isUsingAnArtificialTimeIndex() {
        return this.m_useArtificialTimeIndex;
    }

    public double getArtificialTimeStartValue() throws Exception {
        if (!this.isUsingAnArtificialTimeIndex()) {
            throw new Exception("Not using an artificial time index!");
        }
        return this.m_lastTimeValue;
    }

    public void setArtificialTimeStartValue(double value) throws Exception {
        if (!this.isUsingAnArtificialTimeIndex()) {
            throw new Exception("Not using an artificial time index");
        }
        this.m_lastTimeValue = value;
    }

    public double getCurrentTimeStampValue() throws Exception {
        if (this.m_adjustForTrends && this.m_timeStampName.length() > 0) {
            return this.m_lastTimeValue;
        }
        throw new Exception("Not using a time stamp!");
    }

    public void incrementArtificialTimeValue(int increment) {
        this.m_lastTimeValue += (double)increment;
    }

    public double getDeltaTime() {
        return this.m_dateBasedPeriodicity.deltaTime();
    }

    public Periodicity getPeriodicity() {
        if (!this.m_adjustForTrends || this.m_useArtificialTimeIndex) {
            return null;
        }
        return this.m_userHintPeriodicity != null && this.m_userHintPeriodicity != Periodicity.UNKNOWN ? this.m_userHintPeriodicity : this.m_dateBasedPeriodicity.getPeriodicity();
    }

    public void setPeriodicity(Periodicity toUse) {
        this.m_userHintPeriodicity = toUse;
        this.m_dateBasedPeriodicity.setPeriodicity(toUse);
    }

    public String getSkipEntries() {
        return this.m_skipEntries;
    }

    public void setSkipEntries(String skipEntries) {
        this.m_skipEntries = skipEntries;
    }

    private List<Object> createLagFiller(Instances insts, String targetName) throws Exception {
        LinearRegression lagFiller = new LinearRegression();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("time"));
        atts.add(new Attribute("target"));
        Instances simple = new Instances("simple", atts, insts.numInstances());
        int targetIndex = insts.attribute(targetName).index();
        for (int i = 0; i < insts.numInstances(); ++i) {
            double targetValue = insts.instance(i).value(targetIndex);
            double time = i;
            double[] vals = new double[]{time, targetValue};
            DenseInstance d = new DenseInstance(1.0, vals);
            simple.add((Instance)d);
        }
        simple.setClassIndex(1);
        lagFiller.buildClassifier(simple);
        System.err.println(lagFiller);
        simple = new Instances(simple, 0);
        ArrayList<Object> results = new ArrayList<Object>();
        results.add(lagFiller);
        results.add(simple);
        return results;
    }

    private Instances createLags(Instances insts) throws Exception {
        if (this.m_fieldsToLag == null || this.m_fieldsToLag.get(0).length() == 0) {
            throw new Exception("Field to forecast is not specified!");
        }
        this.m_lagMakers = new ArrayList<Filter>();
        Range r = null;
        int[] rangeIndexes = null;
        if (this.m_lagFineTune.length() > 0) {
            r = this.getLagRangeSelection(this.m_lagFineTune);
            rangeIndexes = r.getSelection();
        }
        for (int j = 0; j < this.m_fieldsToLag.size(); ++j) {
            int classIndex = insts.attribute(this.m_fieldsToLag.get(j)).index();
            if (classIndex < 0) {
                throw new Exception("Can't find field '" + this.m_fieldsToLag.get(j) + "'!");
            }
            for (int i = this.m_minLag; i <= this.m_maxLag; ++i) {
                if (rangeIndexes != null) {
                    boolean ok = false;
                    for (int rangeIndexe : rangeIndexes) {
                        if (rangeIndexe + 1 != i) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) continue;
                }
                Copy c = new Copy();
                c.setAttributeIndices("" + (classIndex + 1));
                c.setInputFormat(insts);
                insts = Filter.useFilter((Instances)insts, (Filter)c);
                this.m_lagMakers.add((Filter)c);
                RenameAttribute rename = new RenameAttribute();
                rename.setAttributeIndices("last");
                rename.setReplace("Lag_" + this.m_fieldsToLag.get(j));
                rename.setInputFormat(insts);
                insts = Filter.useFilter((Instances)insts, (Filter)rename);
                this.m_lagMakers.add((Filter)rename);
                TimeSeriesTranslate timeS = new TimeSeriesTranslate();
                timeS.setAttributeIndices("last");
                timeS.setInstanceRange(-i);
                timeS.setInputFormat(insts);
                insts = Filter.useFilter((Instances)insts, (Filter)timeS);
                this.m_lagMakers.add(timeS);
            }
        }
        return insts;
    }

    private Instances createAveragedLags(Instances insts) throws Exception {
        if (!this.m_averageConsecutiveLongLags) {
            this.m_averagedLagMakers = null;
            return insts;
        }
        if (this.m_numConsecutiveToAverage > this.getMaxLag() - this.getAverageLagsAfter()) {
            if (this.getMaxLag() - this.getAverageLagsAfter() > 1) {
                this.m_numConsecutiveToAverage = this.getMaxLag() - this.getAverageLagsAfter();
            } else {
                this.m_averagedLagMakers = null;
                return insts;
            }
        }
        this.m_averagedLagMakers = new ArrayList<Filter>();
        int numAtts = insts.numAttributes();
        String removeLongLagIndexes = "";
        for (int z = 0; z < this.m_fieldsToLag.size(); ++z) {
            int i;
            int firstLagIndex = -1;
            for (i = 0; i < insts.numAttributes(); ++i) {
                if (!insts.attribute(i).name().startsWith("Lag_" + this.m_fieldsToLag.get(z))) continue;
                firstLagIndex = i;
                break;
            }
            if (firstLagIndex < 0) {
                throw new Exception("Can't find the first lag attribute for " + this.m_fieldsToLag.get(z) + "!");
            }
            i = firstLagIndex;
            while (i < numAtts && insts.attribute(i).name().startsWith("Lag_" + this.m_fieldsToLag.get(z))) {
                int lagNum;
                String lagNumS = insts.attribute(i).name().replace("Lag_" + this.m_fieldsToLag.get(z) + "-", "");
                int lastLagNum = lagNum = Integer.parseInt(lagNumS);
                if (lagNum > this.m_averageLagsAfter) {
                    String currNumS;
                    int currentLagNum;
                    int attNumber = i + 1;
                    removeLongLagIndexes = removeLongLagIndexes + (i + 1) + ",";
                    String avExpression = "(a" + attNumber;
                    String avAttName = "Avg(" + insts.attribute(i).name();
                    int denom = 1;
                    for (int j = 1; j < this.m_numConsecutiveToAverage && i + j < insts.numAttributes() && insts.attribute(i + j).name().startsWith("Lag_" + this.m_fieldsToLag.get(z)) && (currentLagNum = Integer.parseInt(currNumS = insts.attribute(i + j).name().replace("Lag_" + this.m_fieldsToLag.get(z) + "-", ""))) - lastLagNum == 1; ++j) {
                        avExpression = avExpression + " + a" + (attNumber + j);
                        avAttName = avAttName + "," + insts.attribute(i + j).name();
                        ++denom;
                        removeLongLagIndexes = removeLongLagIndexes + (i + j + 1) + ",";
                        lastLagNum = currentLagNum;
                    }
                    avExpression = avExpression + ")/" + denom;
                    avAttName = avAttName + ")";
                    AddExpression addE = new AddExpression();
                    addE.setName(avAttName);
                    addE.setExpression(avExpression);
                    addE.setInputFormat(insts);
                    insts = Filter.useFilter((Instances)insts, (Filter)addE);
                    this.m_averagedLagMakers.add((Filter)addE);
                    i += denom;
                    continue;
                }
                ++i;
            }
        }
        if (removeLongLagIndexes.length() > 0) {
            removeLongLagIndexes = removeLongLagIndexes.substring(0, removeLongLagIndexes.lastIndexOf(44));
            Remove r = new Remove();
            r.setAttributeIndices(removeLongLagIndexes);
            r.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)r);
            this.m_averagedLagMakers.add((Filter)r);
        }
        return insts;
    }

    private Instances createTimeIndexes(Instances insts) throws Exception {
        this.m_timeIndexMakers = null;
        if (this.m_timeStampName != null && this.m_timeStampName.length() > 0 && this.m_adjustForTrends) {
            int timeStampIndex = insts.attribute(this.m_timeStampName).index();
            if (timeStampIndex < 0) {
                throw new Exception("Can't find time stamp attribute '" + this.m_timeStampName + "' in the data!");
            }
            String timeStampName = this.m_timeStampName;
            if (insts.attribute(timeStampIndex).isDate()) {
                timeStampIndex = insts.attribute(this.m_timeStampName + "-remapped").index();
                timeStampName = timeStampName + "-remapped";
            }
            if (!insts.attribute(timeStampIndex).isNumeric()) {
                throw new Exception("Time stamp attribute '" + this.m_timeStampName + "' is not numeric!");
            }
            this.m_timeIndexMakers = new ArrayList<Filter>();
            AddExpression addE = new AddExpression();
            addE.setName(timeStampName + "^2");
            addE.setExpression("a" + (timeStampIndex + 1) + "^2");
            addE.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)addE);
            this.m_timeIndexMakers.add((Filter)addE);
            addE = new AddExpression();
            addE.setName(timeStampName + "^3");
            addE.setExpression("a" + (timeStampIndex + 1) + "^3");
            addE.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)addE);
            this.m_timeIndexMakers.add((Filter)addE);
        }
        return insts;
    }

    public Instances createTimeLagCrossProducts(Instances insts) throws Exception {
        this.m_timeLagCrossProductMakers = null;
        if (this.m_timeStampName == null || this.m_timeStampName.length() == 0 || !this.m_adjustForTrends) {
            return insts;
        }
        int numAtts = insts.numAttributes();
        int firstLagIndex = -1;
        for (int i = 0; i < numAtts; ++i) {
            if (!insts.attribute(i).name().startsWith("Lag_")) continue;
            firstLagIndex = i;
            break;
        }
        if (firstLagIndex < 0) {
            this.m_timeLagCrossProductMakers = null;
            return insts;
        }
        int timeStampIndex = insts.attribute(this.m_timeStampName).index();
        if (timeStampIndex < 0) {
            return insts;
        }
        String timeStampName = this.m_timeStampName;
        if (insts.attribute(timeStampIndex).isDate()) {
            timeStampIndex = insts.attribute(this.m_timeStampName + "-remapped").index();
            timeStampName = timeStampName + "-remapped";
        }
        this.m_timeLagCrossProductMakers = new ArrayList<Filter>();
        for (int i = firstLagIndex; i < insts.numAttributes() && (insts.attribute(i).name().startsWith("Lag_") || insts.attribute(i).name().startsWith("Avg(")); ++i) {
            AddExpression addE = new AddExpression();
            addE.setName(timeStampName + "*" + insts.attribute(i).name());
            addE.setExpression("a" + (timeStampIndex + 1) + "*a" + (i + 1));
            addE.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)addE);
            this.m_timeLagCrossProductMakers.add((Filter)addE);
        }
        return insts;
    }

    private Instances createVarianceAdjusters(Instances insts) throws Exception {
        if (!this.m_adjustForVariance) {
            return insts;
        }
        if (this.m_fieldsToLag == null || this.m_fieldsToLag.get(0).length() == 0) {
            throw new Exception("Fields to lag is not specified!");
        }
        this.m_varianceAdjusters = new ArrayList<Filter>();
        for (String field : this.m_fieldsToLag) {
            int index = insts.attribute(field).index();
            if (index < 0) {
                throw new Exception("Can't find field '" + field + "'!");
            }
            LogFilter logF = new LogFilter();
            logF.setAttIndex(index);
            logF.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)logF);
            this.m_varianceAdjusters.add(logF);
        }
        return insts;
    }

    protected Instances createDateTimestampRemap(Instances insts) throws Exception {
        Instances result = insts;
        if (this.m_adjustForTrends && !this.m_useArtificialTimeIndex && this.m_timeStampName != null && this.m_timeStampName.length() > 0 && result.attribute(this.m_timeStampName).isDate()) {
            int origIndex = result.attribute(this.m_timeStampName).index();
            GregorianCalendar c = new GregorianCalendar();
            for (int i = 0; i < result.numInstances(); ++i) {
                if (result.instance(i).isMissing(origIndex)) continue;
                if (this.m_dateBasedPeriodicity.getPeriodicity() == Periodicity.MONTHLY || this.m_dateBasedPeriodicity.getPeriodicity() == Periodicity.WEEKLY || this.m_dateBasedPeriodicity.getPeriodicity() == Periodicity.QUARTERLY) {
                    Date d = new Date((long)result.instance(i).value(origIndex));
                    c.setTime(d);
                    this.m_dateTimeStampBase = c.get(1);
                    break;
                }
                this.m_dateTimeStampBase = (long)result.instance(i).value(origIndex);
                break;
            }
            this.m_addDateMap = new Add();
            this.m_addDateMap.setAttributeName(this.m_timeStampName + "-remapped");
            this.m_addDateMap.setInputFormat(result);
            result = Filter.useFilter((Instances)result, (Filter)this.m_addDateMap);
            Instance previous = result.instance(0);
            for (int i = 0; i < result.numInstances(); ++i) {
                Instance current = result.instance(i);
                previous = current = this.m_dateBasedPeriodicity.remapDateTimeStamp(current, previous, this.m_timeStampName);
            }
        }
        return result;
    }

    protected Instance remapDateTimeStamp(Instance inst) throws Exception {
        Instance result = inst;
        if (this.m_addDateMap != null) {
            this.m_addDateMap.input(result);
            result = this.m_addDateMap.output();
            result = this.m_dateBasedPeriodicity.remapDateTimeStamp(result, null, this.m_timeStampName);
        }
        return result;
    }

    protected Instances setupDerivedPeriodics(Instances insts) throws Exception {
        Instances result = insts;
        if (this.m_adjustForTrends && !this.m_useArtificialTimeIndex) {
            this.m_dateBasedPeriodicity = TSLagMaker.determinePeriodicity(insts, this.m_timeStampName, this.m_userHintPeriodicity);
            if (this.m_skipEntries != null && this.m_skipEntries.length() > 0) {
                this.m_dateBasedPeriodicity.setSkipList(this.m_skipEntries, this.m_dateFormat);
            }
            if (insts.attribute(this.m_timeStampName).isDate()) {
                Add a;
                this.m_derivedPeriodicMakers = new ArrayList<Filter>();
                if (this.m_am) {
                    a = new Add();
                    a.setAttributeName("AM");
                    a.setInputFormat(insts);
                    result = Filter.useFilter((Instances)result, (Filter)a);
                    this.m_derivedPeriodicMakers.add((Filter)a);
                }
                if (this.m_dayOfWeek) {
                    a = new Add();
                    a.setAttributeName("DayOfWeek");
                    a.setNominalLabels("sun,mon,tue,wed,thu,fri,sat");
                    a.setInputFormat(result);
                    result = Filter.useFilter((Instances)result, (Filter)a);
                    this.m_derivedPeriodicMakers.add((Filter)a);
                }
                if (this.m_dayOfMonth) {
                    a = new Add();
                    a.setAttributeName("DayOfMonth");
                    a.setNominalLabels("1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31");
                    a.setInputFormat(result);
                    result = Filter.useFilter((Instances)result, (Filter)a);
                    this.m_derivedPeriodicMakers.add((Filter)a);
                }
                if (this.m_numDaysInMonth) {
                    a = new Add();
                    a.setAttributeName("NumDaysInMonth");
                    a.setInputFormat(result);
                    result = Filter.useFilter((Instances)result, (Filter)a);
                    this.m_derivedPeriodicMakers.add((Filter)a);
                }
                if (this.m_weekend) {
                    a = new Add();
                    a.setAttributeName("Weekend");
                    a.setInputFormat(result);
                    result = Filter.useFilter((Instances)result, (Filter)a);
                    this.m_derivedPeriodicMakers.add((Filter)a);
                }
                if (this.m_monthOfYear) {
                    a = new Add();
                    a.setAttributeName("Month");
                    a.setNominalLabels("jan,feb,mar,apr,may,jun,jul,aug,sep,oct,nov,dec");
                    a.setInputFormat(result);
                    result = Filter.useFilter((Instances)result, (Filter)a);
                    this.m_derivedPeriodicMakers.add((Filter)a);
                }
                if (this.m_quarter) {
                    a = new Add();
                    a.setAttributeName("Quarter");
                    a.setNominalLabels("Q1,Q2,Q3,Q4");
                    a.setInputFormat(result);
                    result = Filter.useFilter((Instances)result, (Filter)a);
                    this.m_derivedPeriodicMakers.add((Filter)a);
                }
                if (this.m_customPeriodics != null) {
                    for (String name : this.m_customPeriodics.keySet()) {
                        List l = this.m_customPeriodics.get(name);
                        boolean binary = false;
                        String labels = "";
                        HashSet<String> uniqueLabels = new HashSet<String>();
                        for (CustomPeriodicTest t : l) {
                            if (t.getLabel() == null || t.getLabel().length() == 0) {
                                binary = true;
                                break;
                            }
                            if (!uniqueLabels.add(t.getLabel())) continue;
                            labels = labels + t.getLabel() + ",";
                        }
                        Add a2 = new Add();
                        a2.setAttributeName("c_" + name);
                        if (!binary) {
                            labels = labels.substring(0, labels.lastIndexOf(44));
                            a2.setAttributeType(new SelectedTag("NOM", Add.TAGS_TYPE));
                            a2.setNominalLabels(labels);
                        }
                        a2.setInputFormat(result);
                        result = Filter.useFilter((Instances)result, (Filter)a2);
                        this.m_derivedPeriodicMakers.add((Filter)a2);
                    }
                }
                for (int i = 0; i < result.numInstances(); ++i) {
                    this.setDerivedPeriodicValues(result.instance(i));
                }
            }
        }
        return result;
    }

    protected void setDerivedPeriodicValues(Instance inst) {
        if (this.m_adjustForTrends && !this.m_useArtificialTimeIndex && inst.dataset().attribute(this.m_timeStampName).isDate()) {
            int timeIndex = inst.dataset().attribute(this.m_timeStampName).index();
            long time = inst.isMissing(timeIndex) ? -1L : (long)inst.value(timeIndex);
            Date instDate = null;
            GregorianCalendar cal = new GregorianCalendar();
            if (time != -1L) {
                instDate = new Date(time);
                cal.setTime(instDate);
            }
            if (this.m_am) {
                if (instDate == null) {
                    inst.setMissing(inst.dataset().attribute("AM"));
                } else if (cal.get(9) == 0) {
                    inst.setValue(inst.dataset().attribute("AM"), 1.0);
                } else {
                    inst.setValue(inst.dataset().attribute("AM"), 0.0);
                }
            }
            if (this.m_dayOfWeek || this.m_weekend) {
                if (instDate == null) {
                    if (this.m_dayOfWeek) {
                        inst.setMissing(inst.dataset().attribute("DayOfWeek"));
                    }
                    if (this.m_weekend) {
                        inst.setMissing(inst.dataset().attribute("Weekend"));
                    }
                } else {
                    int dow = cal.get(7);
                    String day = "";
                    switch (dow) {
                        case 1: {
                            day = "sun";
                            break;
                        }
                        case 2: {
                            day = "mon";
                            break;
                        }
                        case 3: {
                            day = "tue";
                            break;
                        }
                        case 4: {
                            day = "wed";
                            break;
                        }
                        case 5: {
                            day = "thu";
                            break;
                        }
                        case 6: {
                            day = "fri";
                            break;
                        }
                        case 7: {
                            day = "sat";
                        }
                    }
                    if (day.length() > 0) {
                        if (this.m_dayOfWeek) {
                            inst.setValue(inst.dataset().attribute("DayOfWeek"), day);
                        }
                        if (this.m_weekend) {
                            if (day.equals("sat") || day.equals("sun")) {
                                inst.setValue(inst.dataset().attribute("Weekend"), 1.0);
                            } else {
                                inst.setValue(inst.dataset().attribute("Weekend"), 0.0);
                            }
                        }
                    } else {
                        if (this.m_dayOfWeek) {
                            inst.setMissing(inst.dataset().attribute("DayOfWeek"));
                        }
                        if (this.m_weekend) {
                            inst.setMissing(inst.dataset().attribute("Weekend"));
                        }
                    }
                }
            }
            if (this.m_dayOfMonth) {
                if (instDate == null) {
                    inst.setMissing(inst.dataset().attribute("DayOfWeek"));
                } else {
                    int dom = cal.get(5);
                    inst.setValue(inst.dataset().attribute("DayOfMonth"), (double)(dom - 1));
                }
            }
            if (this.m_numDaysInMonth) {
                if (instDate == null) {
                    inst.setMissing(inst.dataset().attribute("NumDaysInMonth"));
                } else {
                    boolean isLeap = cal.isLeapYear(cal.get(1));
                    int daysInMonth = 0;
                    int month = cal.get(2);
                    if (month == 1) {
                        daysInMonth = 28;
                        if (isLeap) {
                            ++daysInMonth;
                        }
                    } else {
                        daysInMonth = month == 3 || month == 5 || month == 8 || month == 10 ? 30 : 31;
                    }
                    inst.setValue(inst.dataset().attribute("NumDaysInMonth"), (double)daysInMonth);
                }
            }
            if (this.m_monthOfYear || this.m_quarter) {
                if (instDate == null) {
                    if (this.m_monthOfYear) {
                        inst.setMissing(inst.dataset().attribute("Month"));
                    }
                    if (this.m_quarter) {
                        inst.setMissing(inst.dataset().attribute("Quarter"));
                    }
                } else {
                    int moy = cal.get(2);
                    if (this.m_monthOfYear) {
                        String month = inst.dataset().attribute("Month").value(moy);
                        inst.setValue(inst.dataset().attribute("Month"), month);
                    }
                    if (this.m_quarter) {
                        String quarter = "";
                        quarter = moy == 0 || moy == 1 || moy == 2 ? "Q1" : (moy == 3 || moy == 4 || moy == 5 ? "Q2" : (moy == 6 || moy == 7 || moy == 8 ? "Q3" : "Q4"));
                        inst.setValue(inst.dataset().attribute("Quarter"), quarter);
                    }
                }
            }
            if (this.m_customPeriodics != null) {
                for (String name : this.m_customPeriodics.keySet()) {
                    Attribute att = inst.dataset().attribute("c_" + name);
                    if (att != null) {
                        if (instDate == null) {
                            inst.setMissing(att);
                            continue;
                        }
                        List l = this.m_customPeriodics.get(name);
                        boolean result = false;
                        String label = null;
                        for (CustomPeriodicTest t : l) {
                            boolean bl = result = result || t.evaluate(instDate);
                            if (result) {
                                label = t.getLabel();
                                break;
                            }
                            label = null;
                        }
                        if (result) {
                            if (att.isNominal()) {
                                if (label == null) {
                                    System.err.println("This shouldn't happen!!");
                                    continue;
                                }
                                inst.setValue(att, (double)att.indexOfValue(label));
                                continue;
                            }
                            inst.setValue(att, 1.0);
                            continue;
                        }
                        if (att.isNominal()) {
                            inst.setMissing(att);
                            continue;
                        }
                        inst.setValue(att, 0.0);
                        continue;
                    }
                    System.err.println("WARNING: custom periodic att c_" + name + " not found in instances!");
                }
            }
        }
    }

    protected void setupPeriodicMaps(Instances insts) {
        this.m_primaryPeriodicSequence = null;
        this.m_secondaryPeriodicLookups = null;
        if (this.m_primaryPeriodicName != null && this.m_primaryPeriodicName.length() > 0) {
            int i;
            int primaryIndex = insts.attribute(this.m_primaryPeriodicName).index();
            if (primaryIndex < 0) {
                return;
            }
            this.m_primaryPeriodicSequence = new HashMap<String, String>();
            for (i = 0; i < insts.numInstances() - 1; ++i) {
                Instance current = insts.instance(i);
                Instance next = insts.instance(i + 1);
                if (weka.core.Utils.isMissingValue((double)current.value(primaryIndex)) || weka.core.Utils.isMissingValue((double)next.value(primaryIndex))) continue;
                String key = current.stringValue(primaryIndex);
                String value = next.stringValue(primaryIndex);
                if (this.m_primaryPeriodicSequence.get(key) == null) {
                    this.m_primaryPeriodicSequence.put(key, value);
                    continue;
                }
                String previous = this.m_primaryPeriodicSequence.get(key);
                if (previous.equals(value)) continue;
                this.m_primaryPeriodicSequence = null;
                break;
            }
            if (this.m_primaryPeriodicSequence != null) {
                this.m_secondaryPeriodicLookups = new HashMap<Attribute, Map<String, String>>();
                for (i = 0; i < insts.numAttributes(); ++i) {
                    if (!insts.attribute(i).isNominal() || i == primaryIndex) continue;
                    Attribute candidate = insts.attribute(i);
                    HashMap<String, String> candidateMap = new HashMap<String, String>();
                    for (int j = 0; j < insts.numInstances(); ++j) {
                        Instance current = insts.instance(j);
                        if (weka.core.Utils.isMissingValue((double)current.value(primaryIndex)) || weka.core.Utils.isMissingValue((double)j)) continue;
                        String key = current.stringValue(primaryIndex);
                        String value = current.stringValue(j);
                        if (candidateMap.get(key) == null) {
                            candidateMap.put(key, value);
                            continue;
                        }
                        String previous = (String)candidateMap.get(key);
                        if (previous.equals(value)) continue;
                        candidateMap = null;
                        break;
                    }
                    if (candidateMap == null) continue;
                    this.m_secondaryPeriodicLookups.put(candidate, candidateMap);
                }
            }
        }
    }

    private void setPeriodicValues(Instance inst) throws Exception {
        if (this.m_primaryPeriodicName != null && this.m_primaryPeriodicName.length() > 0) {
            int primaryIndex = this.m_originalHeader.attribute(this.m_primaryPeriodicName).index();
            if (primaryIndex < 0) {
                throw new Exception("Can't find the primary periodic variable in the data!");
            }
            double lastPeriodicIndex = this.m_lastHistoricInstance.value(primaryIndex);
            if (!weka.core.Utils.isMissingValue((double)lastPeriodicIndex)) {
                String lastPeriodicValue = this.m_lastHistoricInstance.stringValue(primaryIndex);
                String successor = this.m_primaryPeriodicSequence.get(lastPeriodicValue);
                if (successor != null) {
                    inst.setValue(primaryIndex, (double)this.m_originalHeader.attribute(primaryIndex).indexOfValue(successor));
                    if (this.m_secondaryPeriodicLookups != null) {
                        for (int i = 0; i < this.m_originalHeader.numAttributes(); ++i) {
                            Attribute current = this.m_originalHeader.attribute(i);
                            Map<String, String> correspondingL = this.m_secondaryPeriodicLookups.get(current);
                            if (correspondingL == null) continue;
                            String correspondingV = correspondingL.get(successor);
                            if (correspondingV != null) {
                                inst.setValue(i, (double)this.m_originalHeader.attribute(i).indexOfValue(correspondingV));
                                continue;
                            }
                            inst.setMissing(i);
                        }
                    }
                } else {
                    inst.setMissing(primaryIndex);
                }
            } else {
                inst.setMissing(primaryIndex);
            }
        }
    }

    protected Instances removeExtraneousAttributes(Instances insts) throws Exception {
        int primaryIndex = -1;
        String removeList = "";
        if (this.m_primaryPeriodicName != null && this.m_primaryPeriodicName.length() > 0) {
            primaryIndex = insts.attribute(this.m_primaryPeriodicName).index();
        }
        for (int i = 0; i < insts.numAttributes(); ++i) {
            if (i == primaryIndex || this.m_secondaryPeriodicLookups != null && this.m_secondaryPeriodicLookups.containsKey(insts.attribute(i))) continue;
            boolean target = false;
            for (String s : this.m_fieldsToLag) {
                if (!insts.attribute(i).name().equals(s)) continue;
                target = true;
                break;
            }
            if (target) continue;
            if (this.m_overlayFields != null) {
                boolean overlay = false;
                for (String s : this.m_overlayFields) {
                    if (!insts.attribute(i).name().equals(s)) continue;
                    overlay = true;
                    break;
                }
                if (overlay) continue;
            }
            if (this.m_adjustForTrends && this.m_timeStampName != null && this.m_timeStampName.length() > 0 && i == insts.attribute(this.m_timeStampName).index()) continue;
            removeList = removeList + "" + (i + 1) + ",";
        }
        if (removeList.length() > 0) {
            removeList = removeList.substring(0, removeList.lastIndexOf(44));
            this.m_extraneousAttributeRemover = new Remove();
            this.m_extraneousAttributeRemover.setAttributeIndices(removeList);
            this.m_extraneousAttributeRemover.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_extraneousAttributeRemover);
        }
        return insts;
    }

    public Instances getTransformedData(Instances insts) throws Exception {
        this.m_originalHeader = new Instances(insts, 0);
        Instances result = insts;
        this.m_lastHistoricInstance = result.instance(result.numInstances() - 1);
        this.setupPeriodicMaps(result);
        result = this.removeExtraneousAttributes(insts);
        this.m_lastTimeValue = -1.0;
        if (this.m_adjustForTrends && (this.m_timeStampName == null || this.m_timeStampName.length() == 0 || insts.attribute(this.m_timeStampName) == null)) {
            this.m_artificialTimeMaker = new AddID();
            this.m_artificialTimeMaker.setAttributeName("ArtificialTimeIndex");
            this.m_artificialTimeMaker.setIDIndex("last");
            this.m_artificialTimeMaker.setInputFormat(result);
            result = Filter.useFilter((Instances)result, (Filter)this.m_artificialTimeMaker);
            this.m_useArtificialTimeIndex = true;
            this.m_timeStampName = "ArtificialTimeIndex";
        } else {
            this.m_useArtificialTimeIndex = false;
        }
        if (this.m_adjustForTrends) {
            int timeStampIndex = result.attribute(this.m_timeStampName).index();
            this.m_lastTimeValue = result.instance(result.numInstances() - 1).value(timeStampIndex);
            Instance last = result.instance(result.numInstances() - 1);
            Instance secondToLast = result.instance(result.numInstances() - 2);
            result = this.setupDerivedPeriodics(result);
            result = this.createDateTimestampRemap(result);
        }
        result = this.createVarianceAdjusters(result);
        result = this.createLags(result);
        result = this.createAveragedLags(result);
        if (this.m_includePowersOfTime) {
            result = this.createTimeIndexes(result);
        }
        if (this.m_includeTimeLagCrossProducts) {
            result = this.createTimeLagCrossProducts(result);
        }
        if (this.m_deleteMissingFromStartOfSeries) {
            int start = 0;
            for (int i = 0; i <= this.m_maxLag; ++i) {
                boolean ok = true;
                for (int j = 0; j < result.numAttributes(); ++j) {
                    if (!result.instance(i).isMissing(j)) continue;
                    ok = false;
                    break;
                }
                if (ok) break;
                ++start;
            }
            result = new Instances(result, start, result.numInstances() - start);
        }
        return result;
    }

    public Instance processInstance(Instance source, boolean incrementTime, boolean setAnyPeriodic) throws Exception {
        return this.processInstance(source, incrementTime, setAnyPeriodic, false);
    }

    public Instance processInstancePreview(Instance source, boolean incrementTime, boolean setAnyPeriodic) throws Exception {
        return this.processInstance(source, incrementTime, setAnyPeriodic, true);
    }

    public Instance processInstance(Instance source, boolean incrementTime, boolean setAnyPeriodic, boolean temporary) throws Exception {
        String message = null;
        message = source.dataset().equalHeadersMsg(this.m_originalHeader);
        if (message != null) {
            throw new Exception("[TSLagMaker] cannot process instance because the structure\ndiffers from what we were configured with:\n\n" + message);
        }
        Instance result = source;
        if (setAnyPeriodic) {
            this.setPeriodicValues(result);
        }
        this.m_lastHistoricInstance = new DenseInstance(result);
        this.m_lastHistoricInstance.setDataset(result.dataset());
        if (this.m_extraneousAttributeRemover != null) {
            this.m_extraneousAttributeRemover.input(result);
            result = this.m_extraneousAttributeRemover.output();
        }
        if (this.m_artificialTimeMaker != null) {
            this.m_artificialTimeMaker.input(result);
            result = this.m_artificialTimeMaker.output();
            if (incrementTime) {
                double newTime = this.m_lastTimeValue + 1.0;
                int timeIndex = result.dataset().attribute(this.m_timeStampName).index();
                result.setValue(timeIndex, newTime);
                this.m_lastTimeValue = newTime;
            }
        } else if (this.m_adjustForTrends) {
            int timeIndex = result.dataset().attribute(this.m_timeStampName).index();
            if (incrementTime) {
                double newTime = Utils.advanceSuppliedTimeValue(this.m_lastTimeValue, this.m_dateBasedPeriodicity);
                result.setValue(timeIndex, newTime);
                this.m_lastTimeValue = newTime;
            } else if (!result.isMissing(timeIndex)) {
                this.m_lastTimeValue = result.value(timeIndex);
            }
            if (this.m_derivedPeriodicMakers != null && this.m_derivedPeriodicMakers.size() > 0) {
                for (Filter f : this.m_derivedPeriodicMakers) {
                    f.input(result);
                    result = f.output();
                }
                this.setDerivedPeriodicValues(result);
            }
            result = this.remapDateTimeStamp(result);
        }
        if (this.m_adjustForVariance) {
            for (Filter f : this.m_varianceAdjusters) {
                f.input(result);
                result = f.output();
            }
        }
        for (Filter f : this.m_lagMakers) {
            if (temporary && f instanceof TimeSeriesTranslate) {
                result = ((TimeSeriesTranslate)f).inputOneTemporarily(result);
                continue;
            }
            f.input(result);
            result = f.output();
        }
        if (this.m_averagedLagMakers != null) {
            for (Filter f : this.m_averagedLagMakers) {
                f.input(result);
                result = f.output();
            }
        }
        if (this.m_timeIndexMakers != null) {
            for (Filter f : this.m_timeIndexMakers) {
                f.input(result);
                result = f.output();
            }
        }
        if (this.m_includeTimeLagCrossProducts && this.m_timeLagCrossProductMakers != null) {
            for (Filter f : this.m_timeLagCrossProductMakers) {
                f.input(result);
                result = f.output();
            }
        }
        return result;
    }

    public void clearLagHistories() throws Exception {
        if (this.m_artificialTimeMaker != null) {
            this.m_artificialTimeMaker.batchFinished();
        }
        for (Filter f : this.m_lagMakers) {
            f.batchFinished();
        }
        if (this.m_averagedLagMakers != null) {
            for (Filter f : this.m_averagedLagMakers) {
                f.batchFinished();
            }
        }
        if (this.m_timeIndexMakers != null) {
            for (Filter f : this.m_timeIndexMakers) {
                f.batchFinished();
            }
        }
        if (this.m_includeTimeLagCrossProducts && this.m_timeLagCrossProductMakers != null) {
            for (Filter f : this.m_timeLagCrossProductMakers) {
                f.batchFinished();
            }
        }
    }

    public double advanceSuppliedTimeValue(double valueToAdvance) {
        return Utils.advanceSuppliedTimeValue(valueToAdvance, this.m_dateBasedPeriodicity);
    }

    public double decrementSuppliedTimeValue(double valueToDecrement) {
        return Utils.decrementSuppliedTimeValue(valueToDecrement, this.m_dateBasedPeriodicity);
    }

    public static class PeriodicityHandler
    implements Serializable {
        private static final long serialVersionUID = 6330232772323425050L;
        protected Periodicity m_handlerPeriodicity = Periodicity.UNKNOWN;
        private double m_deltaTime;
        private boolean m_isDateBased;
        private long m_dateTimeStampInitialVal;
        private long m_dateTimeStampFinalVal;
        private long m_dateTimeStampBaseVal;
        private List<Object> m_skipList;
        private long m_trainingRemapSkipAdjust = 0L;

        public Periodicity getPeriodicity() {
            return this.m_handlerPeriodicity;
        }

        public void setPeriodicity(Periodicity p) {
            this.m_handlerPeriodicity = p;
        }

        public void setSkipList(String aList, String dateFormat) throws Exception {
            if (aList != null && aList.length() > 0) {
                String[] parts;
                this.m_skipList = new ArrayList<Object>();
                this.m_trainingRemapSkipAdjust = 0L;
                for (String p : parts = aList.split(",")) {
                    p = p.trim();
                    if (this.m_handlerPeriodicity == Periodicity.UNKNOWN || this.m_handlerPeriodicity == Periodicity.HOURLY || this.m_handlerPeriodicity == Periodicity.DAILY || this.m_handlerPeriodicity == Periodicity.MONTHLY) {
                        if (p.equalsIgnoreCase("mon") || p.equalsIgnoreCase("monday")) {
                            if (this.m_handlerPeriodicity == Periodicity.MONTHLY) continue;
                            this.m_skipList.add("mon");
                            continue;
                        }
                        if (p.equalsIgnoreCase("tue") || p.equalsIgnoreCase("tuesday")) {
                            if (this.m_handlerPeriodicity == Periodicity.MONTHLY) continue;
                            this.m_skipList.add("tue");
                            continue;
                        }
                        if (p.equalsIgnoreCase("wed") || p.equalsIgnoreCase("wednesday")) {
                            if (this.m_handlerPeriodicity == Periodicity.MONTHLY) continue;
                            this.m_skipList.add("wed");
                            continue;
                        }
                        if (p.equalsIgnoreCase("thu") || p.equalsIgnoreCase("thursday")) {
                            if (this.m_handlerPeriodicity == Periodicity.MONTHLY) continue;
                            this.m_skipList.add("thu");
                            continue;
                        }
                        if (p.equalsIgnoreCase("fri") || p.equalsIgnoreCase("friday")) {
                            if (this.m_handlerPeriodicity == Periodicity.MONTHLY) continue;
                            this.m_skipList.add("fri");
                            continue;
                        }
                        if (p.equalsIgnoreCase("sat") || p.equalsIgnoreCase("saturday")) {
                            if (this.m_handlerPeriodicity == Periodicity.MONTHLY) continue;
                            this.m_skipList.add("sat");
                            continue;
                        }
                        if (p.equalsIgnoreCase("sun") || p.equalsIgnoreCase("sunday")) {
                            if (this.m_handlerPeriodicity == Periodicity.MONTHLY) continue;
                            this.m_skipList.add("sun");
                            continue;
                        }
                        if (p.equalsIgnoreCase("weekend")) {
                            if (this.m_handlerPeriodicity != Periodicity.MONTHLY) {
                                this.m_skipList.add("sat");
                                this.m_skipList.add("sun");
                                continue;
                            }
                        } else {
                            if (p.equalsIgnoreCase("jan") || p.equalsIgnoreCase("january")) {
                                this.m_skipList.add("jan");
                                continue;
                            }
                            if (p.equalsIgnoreCase("feb") || p.equalsIgnoreCase("february")) {
                                this.m_skipList.add("feb");
                                continue;
                            }
                            if (p.equalsIgnoreCase("mar") || p.equalsIgnoreCase("march")) {
                                this.m_skipList.add("mar");
                                continue;
                            }
                            if (p.equalsIgnoreCase("apr") || p.equalsIgnoreCase("april")) {
                                this.m_skipList.add("apr");
                                continue;
                            }
                            if (p.equalsIgnoreCase("may")) {
                                this.m_skipList.add("may");
                                continue;
                            }
                            if (p.equalsIgnoreCase("jun") || p.equalsIgnoreCase("june")) {
                                this.m_skipList.add("jun");
                                continue;
                            }
                            if (p.equalsIgnoreCase("jul") || p.equalsIgnoreCase("july")) {
                                this.m_skipList.add("jul");
                                continue;
                            }
                            if (p.equalsIgnoreCase("aug") || p.equalsIgnoreCase("august")) {
                                this.m_skipList.add("aug");
                                continue;
                            }
                            if (p.equalsIgnoreCase("sep") || p.equalsIgnoreCase("september")) {
                                this.m_skipList.add("sep");
                                continue;
                            }
                            if (p.equalsIgnoreCase("oct") || p.equalsIgnoreCase("october")) {
                                this.m_skipList.add("oct");
                                continue;
                            }
                            if (p.equalsIgnoreCase("nov") || p.equalsIgnoreCase("november")) {
                                this.m_skipList.add("nov");
                                continue;
                            }
                            if (p.equalsIgnoreCase("dec") || p.equalsIgnoreCase("december")) {
                                this.m_skipList.add("dec");
                                continue;
                            }
                        }
                    }
                    try {
                        int num = Integer.parseInt(p);
                        this.m_skipList.add(new Integer(p));
                    }
                    catch (NumberFormatException n) {
                        if (dateFormat != null && dateFormat.length() > 0) {
                            String datePart = p;
                            if (p.indexOf(64) > 0) {
                                String[] dateParts = p.split("@");
                                datePart = dateParts[0];
                                dateFormat = dateParts[1];
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat();
                            sdf.applyPattern(dateFormat);
                            try {
                                Date d = sdf.parse(datePart);
                                this.m_skipList.add(d);
                                continue;
                            }
                            catch (ParseException e) {
                                // empty catch block
                            }
                        }
                        throw new Exception("Unrecognized skip entry string : " + p);
                    }
                }
            }
        }

        public double deltaTime() {
            return this.m_deltaTime;
        }

        public void setDeltaTime(double deltaTime) {
            this.m_deltaTime = deltaTime;
            this.m_handlerPeriodicity.setDeltaTime(this.m_deltaTime);
        }

        public long getDateTimeStampInitial() throws Exception {
            if (!this.isDateBased()) {
                throw new Exception("This periodicity is not date timestamp-based");
            }
            return this.m_dateTimeStampInitialVal;
        }

        public void setDateTimeStampInitial(long tsbase) {
            this.m_isDateBased = true;
            this.m_dateTimeStampInitialVal = tsbase;
            GregorianCalendar c = new GregorianCalendar();
            Date d = new Date(this.m_dateTimeStampInitialVal);
            c.setTime(d);
            this.m_dateTimeStampBaseVal = this.m_handlerPeriodicity == Periodicity.MONTHLY || this.m_handlerPeriodicity == Periodicity.WEEKLY || this.m_handlerPeriodicity == Periodicity.QUARTERLY ? (long)c.get(1) : this.m_dateTimeStampInitialVal;
        }

        public long getDateTimeStampFinal() throws Exception {
            if (!this.isDateBased()) {
                throw new Exception("This periodicity is not date timestamp-based");
            }
            return this.m_dateTimeStampFinalVal;
        }

        public void setDateTimeStampFinal(long tsfinal) {
            this.m_isDateBased = true;
            this.m_dateTimeStampFinalVal = tsfinal;
        }

        public void setIsDateBased(boolean isDateBased) {
            this.m_isDateBased = isDateBased;
        }

        public boolean isDateBased() {
            return this.m_isDateBased;
        }

        public boolean dateInSkipList(Date toCheck) {
            if (this.m_skipList == null || this.m_skipList.size() == 0) {
                return false;
            }
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(toCheck);
            for (Object o : this.m_skipList) {
                if (o instanceof String) {
                    if (o.toString().equals("mon") && c.get(7) == 2) {
                        return true;
                    }
                    if (o.toString().equals("tue") && c.get(7) == 3) {
                        return true;
                    }
                    if (o.toString().equals("wed") && c.get(7) == 4) {
                        return true;
                    }
                    if (o.toString().equals("thu") && c.get(7) == 5) {
                        return true;
                    }
                    if (o.toString().equals("fri") && c.get(7) == 6) {
                        return true;
                    }
                    if ((o.toString().equals("sat") || o.toString().equals("weekend")) && c.get(7) == 7) {
                        return true;
                    }
                    if ((o.toString().equals("sun") || o.toString().equals("weekend")) && c.get(7) == 1) {
                        return true;
                    }
                    if (o.toString().equals("jan") && c.get(2) == 0) {
                        return true;
                    }
                    if (o.toString().equals("feb") && c.get(2) == 1) {
                        return true;
                    }
                    if (o.toString().equals("mar") && c.get(2) == 2) {
                        return true;
                    }
                    if (o.toString().equals("apr") && c.get(2) == 3) {
                        return true;
                    }
                    if (o.toString().equals("may") && c.get(2) == 4) {
                        return true;
                    }
                    if (o.toString().equals("jun") && c.get(2) == 5) {
                        return true;
                    }
                    if (o.toString().equals("jul") && c.get(2) == 6) {
                        return true;
                    }
                    if (o.toString().equals("aug") && c.get(2) == 7) {
                        return true;
                    }
                    if (o.toString().equals("sep") && c.get(2) == 8) {
                        return true;
                    }
                    if (o.toString().equals("oct") && c.get(2) == 9) {
                        return true;
                    }
                    if (o.toString().equals("nov") && c.get(2) == 10) {
                        return true;
                    }
                    if (!o.toString().equals("dec") || c.get(2) != 11) continue;
                    return true;
                }
                if (!(o instanceof Integer ? (this.m_handlerPeriodicity == Periodicity.DAILY || this.m_handlerPeriodicity == Periodicity.UNKNOWN ? c.get(6) == ((Integer)o).intValue() : (this.m_handlerPeriodicity == Periodicity.HOURLY ? c.get(11) == ((Integer)o).intValue() : (this.m_handlerPeriodicity == Periodicity.WEEKLY ? c.get(3) == ((Integer)o).intValue() : this.m_handlerPeriodicity == Periodicity.MONTHLY && c.get(2) == ((Integer)o).intValue()))) : o instanceof Date && ((Date)o).equals(toCheck))) continue;
                return true;
            }
            return false;
        }

        public Instance remapDateTimeStamp(Instance inst, Instance previous, String timeStampName) throws Exception {
            Instance result = inst;
            if (!this.isDateBased()) {
                throw new Exception("This periodicity is not date timestamp-based");
            }
            int origIndex = result.dataset().attribute(timeStampName).index();
            GregorianCalendar c = new GregorianCalendar();
            boolean applyTrainingSkipAdjust = true;
            long localSkipAdjust = 0L;
            if (!result.isMissing(origIndex)) {
                Date d = new Date((long)result.value(origIndex));
                double origValue = result.value(origIndex);
                if (this.m_skipList != null && this.m_skipList.size() > 0 && previous != null) {
                    if (this.dateInSkipList(d)) {
                        throw new Exception("This instance contains a date time stamp that is a member of the skip list - skip list entries are not time units with respect to the model and should not be present : " + inst.toString());
                    }
                    if (!previous.isMissing(origIndex)) {
                        if (result.value(origIndex) >= previous.value(origIndex)) {
                            double start = previous.value(origIndex);
                            double end = origValue;
                            while (start < end) {
                                if (!((start = Utils.advanceSuppliedTimeValue(start, this)) < end)) continue;
                                if (this.dateInSkipList(new Date((long)start))) {
                                    --this.m_trainingRemapSkipAdjust;
                                    continue;
                                }
                                throw new Exception("There is an increment of more than one time step between\n" + previous.toString() + "\nand\n" + inst.toString() + "\n but none of the " + "intervening time steps are in the " + "skip list.");
                            }
                        } else {
                            throw new Exception("The data does not seem to be sorted in ascending order of the date time stamp!");
                        }
                    }
                }
                if (this.m_skipList != null && this.m_skipList.size() > 0 && previous == null) {
                    if (origValue < (double)this.m_dateTimeStampInitialVal) {
                        throw new Exception("The timestamp for this instance occurs before the timestamp of the first training instance!");
                    }
                    double end = result.value(origIndex);
                    while (this.dateInSkipList(new Date((long)end))) {
                        end = Utils.advanceSuppliedTimeValue(end, this);
                    }
                    double start = 0.0;
                    if (end < (double)this.m_dateTimeStampFinalVal) {
                        applyTrainingSkipAdjust = false;
                        start = this.m_dateTimeStampInitialVal;
                    } else {
                        start = this.m_dateTimeStampFinalVal;
                    }
                    while (start < end) {
                        if (!((start = Utils.advanceSuppliedTimeValue(start, this)) < end) || !this.dateInSkipList(new Date((long)start))) continue;
                        --localSkipAdjust;
                    }
                    d = new Date((long)end);
                    origValue = end;
                }
                if (this.m_handlerPeriodicity == Periodicity.MONTHLY || this.m_handlerPeriodicity == Periodicity.WEEKLY || this.m_handlerPeriodicity == Periodicity.QUARTERLY) {
                    c.setTime(d);
                    long year = c.get(1);
                    long month = c.get(2);
                    long week = c.get(3);
                    long remapped = 0L;
                    if (this.m_handlerPeriodicity == Periodicity.MONTHLY) {
                        remapped = (year - this.m_dateTimeStampBaseVal) * 12L + month;
                    } else if (this.m_handlerPeriodicity == Periodicity.WEEKLY) {
                        remapped = (year - this.m_dateTimeStampBaseVal) * 52L + week;
                        if (month == 11L && week == 1L) {
                            remapped += 52L;
                        }
                    } else if (this.m_handlerPeriodicity == Periodicity.QUARTERLY) {
                        remapped = (year - this.m_dateTimeStampBaseVal) * 4L + (month / 3L + 1L);
                    }
                    if (this.m_skipList != null && this.m_skipList.size() > 0) {
                        remapped += applyTrainingSkipAdjust ? this.m_trainingRemapSkipAdjust : 0L;
                        remapped += localSkipAdjust;
                    }
                    result.setValue(result.numAttributes() - 1, (double)remapped);
                } else {
                    double remapped = origValue - (double)this.m_dateTimeStampInitialVal;
                    remapped /= this.deltaTime();
                    if (this.m_skipList != null && this.m_skipList.size() > 0) {
                        remapped += applyTrainingSkipAdjust ? (double)this.m_trainingRemapSkipAdjust : 0.0;
                        remapped += (double)localSkipAdjust;
                    }
                    result.setValue(result.numAttributes() - 1, remapped);
                }
            }
            return result;
        }
    }

    protected static class LogFilter
    extends Filter {
        private static final long serialVersionUID = 5427729966639957517L;
        protected int m_attIndex;

        protected LogFilter() {
        }

        public Capabilities getCapabilities() {
            Capabilities result = super.getCapabilities();
            result.disableAll();
            result.enableAllAttributes();
            result.enable(Capabilities.Capability.MISSING_VALUES);
            result.enableAllClasses();
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
            result.enable(Capabilities.Capability.NO_CLASS);
            return result;
        }

        public void setAttIndex(int index) {
            this.m_attIndex = index;
        }

        public boolean setInputFormat(Instances instanceInfo) throws Exception {
            super.setInputFormat(instanceInfo);
            this.setOutputFormat(instanceInfo);
            return true;
        }

        public boolean input(Instance instance) throws Exception {
            if (this.getInputFormat() == null) {
                throw new IllegalStateException("No input instance format defined");
            }
            if (this.m_NewBatch) {
                this.resetQueue();
                this.m_NewBatch = false;
            }
            double[] vals = new double[instance.numAttributes() + 1];
            for (int i = 0; i < instance.numAttributes(); ++i) {
                vals[i] = instance.isMissing(i) ? weka.core.Utils.missingValue() : instance.value(i);
            }
            if (!instance.isMissing(this.m_attIndex)) {
                vals[this.m_attIndex] = Math.log(instance.value(this.m_attIndex));
            }
            DenseInstance inst = new DenseInstance(1.0, vals);
            inst.setDataset(this.getOutputFormat());
            this.push((Instance)inst);
            return true;
        }
    }

    public static enum Periodicity {
        UNKNOWN,
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        QUARTERLY,
        YEARLY;

        private double m_deltaTime;

        public double deltaTime() {
            return this.m_deltaTime;
        }

        public void setDeltaTime(double deltaTime) {
            this.m_deltaTime = deltaTime;
        }
    }
}

