/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.timeseries.PrimingDataLearner;
import weka.classifiers.timeseries.WekaForecaster;
import weka.classifiers.timeseries.core.CustomPeriodicTest;
import weka.classifiers.timeseries.core.OverlayForecaster;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.classifiers.timeseries.eval.TSEvalModule;
import weka.classifiers.timeseries.eval.TSEvaluation;
import weka.classifiers.timeseries.gui.CustomPeriodicEditor;
import weka.classifiers.timeseries.gui.SimpleConfigPanel;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Range;
import weka.core.SerializedObject;
import weka.gui.AttributeSelectionPanel;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;

public class AdvancedConfigPanel
extends JPanel {
    protected static final int NUM_PREDEFINED_PERIODICS = 7;
    private static final long serialVersionUID = 5465960083615138964L;
    protected Instances m_instances;
    protected SimpleConfigPanel m_simpleConfig;
    protected GenericObjectEditor m_baseLearnerEditor = new GenericObjectEditor();
    protected PropertyPanel m_baseLearnerPanel = new PropertyPanel((PropertyEditor)this.m_baseLearnerEditor);
    protected JCheckBox m_useCustomLags = new JCheckBox("Use custom lag lengths");
    protected JSpinner m_minLagSpinner;
    protected JSpinner m_maxLagSpinner;
    protected JCheckBox m_removeLeadingInstancesWithMissingLags = new JCheckBox("Remove leading instances with unknown lag values");
    protected JCheckBox m_powersOfTime = new JCheckBox("Include powers of time");
    protected JCheckBox m_timeLagProducts = new JCheckBox("Included products of time and lagged variables");
    protected JButton m_moreOptsBut = new JButton("More options...");
    protected JCheckBox m_adjustForVarianceCheckBox = new JCheckBox("Adjust for variance");
    protected JTextField m_fineTuneLagsField = new JTextField();
    protected JCheckBox m_averageLongLags = new JCheckBox("Average consecutive long lags");
    protected JSpinner m_averageLagsAfter;
    protected JSpinner m_numConsecutiveToAverage;
    protected Instances m_dateDerivedPeriodicsHeader;
    protected JCheckBox m_customizeDateDerivedPeriodics = new JCheckBox("Customize");
    protected JButton m_editCustomPeriodicBut = new JButton("Edit");
    protected JButton m_addCustomPeriodicBut = new JButton("New");
    protected JButton m_deleteCustomPeriodicBut = new JButton("Delete");
    protected JButton m_savePeriodicBut = new JButton("Save");
    protected JButton m_loadPeriodicBut = new JButton("Load");
    protected JFileChooser m_fileChooser;
    protected Map<String, ArrayList<CustomPeriodicTest>> m_customPeriodics = new HashMap<String, ArrayList<CustomPeriodicTest>>();
    protected AttributeSelectionPanelExtended m_dateDerivedPeriodicSelector = new AttributeSelectionPanelExtended(false, false, false, false);
    protected JComboBox m_primaryPeriodicCombo = new JComboBox();
    protected AttributeSelectionPanelExtended m_overlaySelector = new AttributeSelectionPanelExtended(true, true, true, true);
    protected JCheckBox m_useOverlayData = new JCheckBox("Use overlay data");
    protected Instances m_overlayHeader;
    protected Instances m_evaluationModsHeader;
    protected AttributeSelectionPanel m_evaluationMetrics = new AttributeSelectionPanel(false, false, false, false);
    protected JCheckBox m_trainingCheckBox = new JCheckBox("Evaluate on training");
    protected JCheckBox m_holdoutCheckBox = new JCheckBox("Evaluate on held out training");
    protected JTextField m_holdoutSize = new JTextField();
    protected boolean m_allowSeparateTestSet = true;
    protected JCheckBox m_separateTestSetCheckBox = new JCheckBox("Evaluate on a separate test set");
    protected JButton m_testSetBut = new JButton("Separate test set");
    protected JCheckBox m_outputPredsCheckBox = new JCheckBox("Output predictions at step");
    protected JComboBox m_outputPredsCombo = new JComboBox();
    protected JLabel m_outputPredsComboLabel = new JLabel("Target to output", 4);
    protected JSpinner m_outputStepSpinner;
    protected JLabel m_outputStepLabel = new JLabel("Step to output", 4);
    protected JCheckBox m_outputFutureCheckBox = new JCheckBox("Output future predictions beyond end of series ");
    protected JCheckBox m_graphPredsAtStepCheckBox = new JCheckBox("Graph predictions at step");
    protected JSpinner m_graphPredsAtStepSpinner;
    protected JLabel m_stepLab = new JLabel("Steps to graph");
    protected JCheckBox m_graphTargetForStepsCheckBox = new JCheckBox("Graph target at steps:");
    protected JComboBox m_graphTargetAtStepsCombo = new JComboBox();
    protected JLabel m_targetComboLabel = new JLabel("Target to graph", 4);
    protected JTextField m_stepRange = new JTextField("1");
    protected JCheckBox m_graphFutureCheckBox = new JCheckBox("Graph future predictions beyond end of series");
    JTabbedPane m_configHolder = new JTabbedPane();

    public AdvancedConfigPanel(SimpleConfigPanel s, boolean allowSeparateTestSet) {
        this.m_allowSeparateTestSet = allowSeparateTestSet;
        this.m_simpleConfig = s;
        this.setLayout(new BorderLayout());
        this.layoutLearnerPanel();
        this.layoutLagPanel();
        this.layoutDateDerivedPeriodicPanel();
        this.layoutOverlayPanel();
        this.layoutEvaluationPanel();
        this.layoutOutputPanel();
        this.add((Component)this.m_configHolder, "Center");
    }

    public AdvancedConfigPanel(SimpleConfigPanel s) {
        this(s, true);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            Instances i = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            SimpleConfigPanel scp = new SimpleConfigPanel(null);
            scp.setInstances(i);
            AdvancedConfigPanel acp = new AdvancedConfigPanel(scp);
            final JFrame jf = new JFrame("Weka Forecasting");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)acp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public String getTabTitle() {
        return "Advanced configuration";
    }

    public String getTabTitleToolTip() {
        return "Advanced configuration";
    }

    public Classifier getBaseClassifier() {
        return (Classifier)this.m_baseLearnerEditor.getValue();
    }

    public void setInstances(Instances train) {
        this.m_instances = train;
        this.updatePanel();
    }

    public void enableDateDerivedPeriodics(boolean s) {
        this.m_customizeDateDerivedPeriodics.setEnabled(s);
        if (!s) {
            this.m_customizeDateDerivedPeriodics.setSelected(false);
            this.m_addCustomPeriodicBut.setEnabled(false);
            this.m_editCustomPeriodicBut.setEnabled(false);
            this.m_deleteCustomPeriodicBut.setEnabled(false);
            this.m_savePeriodicBut.setEnabled(false);
            this.m_loadPeriodicBut.setEnabled(false);
        }
    }

    public boolean isEnabledCustomizeDateDerivedPeriodics() {
        return this.m_customizeDateDerivedPeriodics.isEnabled();
    }

    public boolean getCustomizeDateDerivedPeriodics() {
        return this.m_customizeDateDerivedPeriodics.isSelected();
    }

    public boolean isUsingCustomLags() {
        return this.m_useCustomLags.isSelected();
    }

    public double getHoldoutSetSize() {
        double result = 0.0;
        if (this.m_holdoutCheckBox.isSelected()) {
            try {
                result = Double.parseDouble(this.m_holdoutSize.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getOutputFuturePredictions() {
        return this.m_outputFutureCheckBox.isSelected();
    }

    public int getOutputPredictionsAtStep() {
        if (!this.m_outputPredsCheckBox.isSelected()) {
            return 0;
        }
        return ((SpinnerNumberModel)this.m_outputStepSpinner.getModel()).getNumber().intValue();
    }

    public boolean getGraphTargetForSteps() {
        return this.m_graphTargetForStepsCheckBox.isSelected();
    }

    public String getGraphTargetForStepsTarget() {
        if (!this.getGraphTargetForSteps()) {
            return null;
        }
        return this.m_graphTargetAtStepsCombo.getSelectedItem().toString();
    }

    public List<Integer> getGraphTargetForStepsStepList() {
        String rng = this.m_stepRange.getText();
        if (rng == null || rng.length() == 0) {
            return null;
        }
        Range range = new Range(rng);
        range.setUpper(this.m_simpleConfig.getHorizonValue());
        int[] indices = range.getSelection();
        ArrayList<Integer> rangeList = new ArrayList<Integer>();
        for (int i : indices) {
            rangeList.add(i + 1);
        }
        return rangeList;
    }

    public String getOutputPredictionsTarget() {
        if (!this.m_outputPredsCheckBox.isSelected()) {
            return null;
        }
        return this.m_outputPredsCombo.getSelectedItem().toString();
    }

    public int getGraphPredictionsAtStep() {
        if (!this.m_graphPredsAtStepCheckBox.isSelected()) {
            return 0;
        }
        return ((SpinnerNumberModel)this.m_graphPredsAtStepSpinner.getModel()).getNumber().intValue();
    }

    public boolean getGraphFuturePredictions() {
        return this.m_graphFutureCheckBox.isSelected();
    }

    public void updatePanel() {
        this.updateDateDerivedPanel();
        this.updatePrimaryPeriodic();
        this.updateOutputPanel();
        this.updateOverlayPanel();
    }

    public void updateOverlayPanel() {
        Instances newI = this.createAvailableOverlayList();
        if (newI == null) {
            this.m_useOverlayData.setSelected(false);
            this.m_useOverlayData.setEnabled(false);
            this.m_overlaySelector.clearTableModel();
        } else {
            this.m_useOverlayData.setEnabled(true);
            if (this.m_useOverlayData.isSelected() && (this.m_overlayHeader == null || !newI.equalHeaders(this.m_overlayHeader))) {
                this.m_overlayHeader = newI;
                this.m_overlaySelector.setInstances(newI);
            }
        }
    }

    private Instances createAvailableOverlayList() {
        String ppfn = this.m_primaryPeriodicCombo.getSelectedItem().toString();
        Instances result = null;
        if (this.m_simpleConfig.m_targetHeader != null) {
            ArrayList<Attribute> availableAtts = new ArrayList<Attribute>();
            int[] selectedTargets = this.m_simpleConfig.m_targetPanel.getSelectedAttributes();
            for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
                if (this.m_instances.attribute(i).isDate() || this.m_instances.attribute(i).name().equals(ppfn)) continue;
                if (this.m_simpleConfig.m_targetHeader.attribute(this.m_instances.attribute(i).name()) != null) {
                    int indexToCheck = this.m_simpleConfig.m_targetHeader.attribute(this.m_instances.attribute(i).name()).index();
                    boolean ok = true;
                    for (int selectedTarget : selectedTargets) {
                        if (indexToCheck != selectedTarget) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                    availableAtts.add(new Attribute(this.m_instances.attribute(i).name()));
                    continue;
                }
                availableAtts.add(new Attribute(this.m_instances.attribute(i).name()));
            }
            if (availableAtts.size() > 0) {
                result = new Instances("Overlay", availableAtts, 1);
            }
        }
        return result;
    }

    public void updateOutputPanel() {
        if (this.m_simpleConfig.m_targetHeader != null) {
            Vector<String> candidates = new Vector<String>();
            for (int i = 0; i < this.m_simpleConfig.m_targetHeader.numAttributes(); ++i) {
                candidates.add(this.m_simpleConfig.m_targetHeader.attribute(i).name());
            }
            this.m_graphTargetAtStepsCombo.setModel(new DefaultComboBoxModel(candidates));
            this.m_outputPredsCombo.setModel(new DefaultComboBoxModel(candidates));
        }
    }

    protected void updateDateDerivedPanel() {
        if (this.m_simpleConfig.m_timeStampCombo.getSelectedItem() == null) {
            return;
        }
        String selectedTimeStamp = this.m_simpleConfig.m_timeStampCombo.getSelectedItem().toString();
        if (selectedTimeStamp.equals("<None>") || selectedTimeStamp.equals("<Use and artificial time stamp>")) {
            this.m_customizeDateDerivedPeriodics.setSelected(false);
            this.m_customizeDateDerivedPeriodics.setEnabled(false);
            this.m_editCustomPeriodicBut.setEnabled(false);
            this.m_addCustomPeriodicBut.setEnabled(false);
            this.m_deleteCustomPeriodicBut.setEnabled(false);
            this.m_savePeriodicBut.setEnabled(false);
            this.m_loadPeriodicBut.setEnabled(false);
        } else if (this.m_instances != null) {
            Attribute timeStampAtt = this.m_instances.attribute(selectedTimeStamp);
            if (timeStampAtt != null && timeStampAtt.isDate()) {
                this.m_customizeDateDerivedPeriodics.setEnabled(true);
            } else {
                this.m_customizeDateDerivedPeriodics.setSelected(false);
                this.m_customizeDateDerivedPeriodics.setEnabled(false);
                this.m_editCustomPeriodicBut.setEnabled(false);
                this.m_addCustomPeriodicBut.setEnabled(false);
                this.m_deleteCustomPeriodicBut.setEnabled(false);
                this.m_savePeriodicBut.setEnabled(false);
                this.m_loadPeriodicBut.setEnabled(false);
            }
        } else {
            this.m_customizeDateDerivedPeriodics.setSelected(false);
            this.m_customizeDateDerivedPeriodics.setEnabled(false);
            this.m_editCustomPeriodicBut.setEnabled(false);
            this.m_addCustomPeriodicBut.setEnabled(false);
            this.m_deleteCustomPeriodicBut.setEnabled(false);
            this.m_savePeriodicBut.setEnabled(false);
            this.m_loadPeriodicBut.setEnabled(false);
        }
    }

    protected void updatePrimaryPeriodic() {
        Vector<String> entries = new Vector<String>();
        entries.add("<None>");
        if (this.m_instances != null) {
            for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
                if (!this.m_instances.attribute(i).isNominal()) continue;
                entries.add(this.m_instances.attribute(i).name());
            }
        }
        this.m_primaryPeriodicCombo.setModel(new DefaultComboBoxModel(entries));
    }

    protected void updateEvalAndOutputEnabledStatus() {
        boolean enable = this.m_trainingCheckBox.isSelected() || this.m_holdoutCheckBox.isSelected() || this.m_separateTestSetCheckBox.isSelected();
        this.m_outputPredsCheckBox.setEnabled(enable);
        this.m_graphPredsAtStepCheckBox.setEnabled(enable);
        this.m_graphTargetForStepsCheckBox.setEnabled(enable);
        if (!enable) {
            this.m_outputPredsCheckBox.setSelected(false);
            this.m_graphPredsAtStepCheckBox.setSelected(false);
            this.m_graphTargetForStepsCheckBox.setSelected(false);
        }
        boolean enabled = this.m_graphTargetForStepsCheckBox.isSelected();
        this.m_stepLab.setEnabled(enabled);
        this.m_stepRange.setEnabled(enabled);
        this.m_targetComboLabel.setEnabled(enabled);
        this.m_graphTargetAtStepsCombo.setEnabled(enabled);
        this.m_graphPredsAtStepSpinner.setEnabled(enabled);
        enabled = this.m_outputPredsCheckBox.isSelected();
        this.m_outputStepLabel.setEnabled(enabled);
        this.m_outputPredsCombo.setEnabled(enabled);
        this.m_outputPredsComboLabel.setEnabled(enable);
        this.m_outputStepSpinner.setEnabled(enabled);
        this.m_testSetBut.setEnabled(!this.m_holdoutCheckBox.isSelected());
        this.m_separateTestSetCheckBox.setEnabled(!this.m_holdoutCheckBox.isSelected());
        this.m_holdoutSize.setEnabled(this.m_holdoutCheckBox.isSelected());
        if (this.m_holdoutCheckBox.isSelected()) {
            this.m_separateTestSetCheckBox.setSelected(false);
        }
    }

    protected void layoutEvaluationPanel() {
        Instances modInsts;
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        JPanel base1 = new JPanel();
        base1.setLayout(new BorderLayout());
        base1.add((Component)this.m_evaluationMetrics, "Center");
        List<TSEvalModule> evalModulesL = TSEvalModule.getModuleList();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        int numMods = 0;
        for (TSEvalModule s : evalModulesL) {
            if (s.getEvalName().equals("Error")) continue;
            atts.add(new Attribute(s.toString()));
            ++numMods;
        }
        this.m_evaluationModsHeader = modInsts = new Instances("Eval modules", atts, 1);
        this.m_evaluationMetrics.setInstances(modInsts);
        boolean[] selected = new boolean[numMods];
        selected[0] = true;
        selected[2] = true;
        try {
            this.m_evaluationMetrics.setSelectedAttributes(selected);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.m_evaluationMetrics.setPreferredScrollableViewportSize(new Dimension(260, 80));
        this.m_evaluationMetrics.setBorder((Border)BorderFactory.createTitledBorder("Metrics"));
        JPanel temp1 = new JPanel();
        temp1.setLayout(new BorderLayout());
        temp1.setBorder(BorderFactory.createTitledBorder("Test options"));
        temp1.add((Component)this.m_trainingCheckBox, "North");
        this.m_trainingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedConfigPanel.this.updateEvalAndOutputEnabledStatus();
                if (AdvancedConfigPanel.this.m_simpleConfig != null) {
                    AdvancedConfigPanel.this.m_simpleConfig.m_performEvaluation.setSelected(AdvancedConfigPanel.this.m_trainingCheckBox.isSelected() || AdvancedConfigPanel.this.m_holdoutCheckBox.isSelected());
                }
            }
        });
        JPanel temp2 = new JPanel();
        temp2.setLayout(new BorderLayout());
        temp2.add((Component)this.m_holdoutCheckBox, "West");
        temp2.add((Component)this.m_holdoutSize, "East");
        this.m_holdoutSize.setEnabled(false);
        int width = this.m_minLagSpinner.getPreferredSize().width;
        int height = this.m_minLagSpinner.getPreferredSize().height;
        this.m_holdoutSize.setPreferredSize(new Dimension(width * 1, height));
        this.m_holdoutSize.setMinimumSize(new Dimension(width * 1, height));
        this.m_holdoutSize.setToolTipText("Number of instances (value >=1) or percentage (value < 1) to hold out from the end of the data");
        this.m_holdoutSize.setText("0.3");
        this.m_holdoutCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedConfigPanel.this.updateEvalAndOutputEnabledStatus();
                if (AdvancedConfigPanel.this.m_simpleConfig != null) {
                    AdvancedConfigPanel.this.m_simpleConfig.m_performEvaluation.setSelected(AdvancedConfigPanel.this.m_trainingCheckBox.isSelected() || AdvancedConfigPanel.this.m_holdoutCheckBox.isSelected());
                }
            }
        });
        temp1.add((Component)temp2, "Center");
        if (this.m_allowSeparateTestSet) {
            JPanel checkAndButHolder = new JPanel();
            checkAndButHolder.setLayout(new BorderLayout());
            checkAndButHolder.add((Component)this.m_separateTestSetCheckBox, "North");
            checkAndButHolder.add((Component)this.m_testSetBut, "South");
            temp1.add((Component)checkAndButHolder, "South");
            this.m_separateTestSetCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdvancedConfigPanel.this.updateEvalAndOutputEnabledStatus();
                }
            });
        }
        JPanel temp3 = new JPanel();
        temp3.setLayout(new BorderLayout());
        temp3.add((Component)temp1, "North");
        base1.add((Component)temp3, "East");
        basePanel.add((Component)base1, "North");
        this.m_testSetBut.setToolTipText("Evaluate on a separate test set");
        this.m_testSetBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.m_configHolder.addTab("Evaluation", null, basePanel, "Evaluation options");
    }

    protected void layoutOutputPanel() {
        JPanel outputOptsHolder = new JPanel();
        outputOptsHolder.setLayout(new GridLayout(1, 2));
        JPanel textOutHolder = new JPanel();
        textOutHolder.setLayout(new BorderLayout());
        textOutHolder.setBorder(BorderFactory.createTitledBorder("Output options"));
        SpinnerNumberModel snm = new SpinnerNumberModel();
        snm.setValue(1);
        snm.setMinimum(Integer.valueOf(1));
        this.m_outputStepSpinner = new JSpinner(snm);
        Dimension spinD = this.m_outputStepSpinner.getPreferredSize();
        spinD = new Dimension((int)(spinD.getWidth() * 1.5), (int)spinD.getHeight());
        this.m_outputStepSpinner.setPreferredSize(spinD);
        JPanel checkHolder = new JPanel();
        checkHolder.setLayout(new BorderLayout());
        checkHolder.add((Component)this.m_outputPredsCheckBox, "West");
        JPanel comboAndSpinnerHolder = new JPanel();
        comboAndSpinnerHolder.setLayout(new BorderLayout());
        JPanel combo1Holder = new JPanel();
        combo1Holder.setLayout(new BorderLayout());
        combo1Holder.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        combo1Holder.add((Component)this.m_outputPredsCombo, "East");
        combo1Holder.add((Component)this.m_outputPredsComboLabel, "Center");
        comboAndSpinnerHolder.add((Component)combo1Holder, "North");
        JPanel spinnerHolder1 = new JPanel();
        spinnerHolder1.setLayout(new BorderLayout());
        spinnerHolder1.add((Component)this.m_outputStepSpinner, "East");
        spinnerHolder1.add((Component)this.m_outputStepLabel, "Center");
        JPanel spinnerHolder2 = new JPanel();
        spinnerHolder2.setLayout(new BorderLayout());
        spinnerHolder2.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        spinnerHolder2.add((Component)spinnerHolder1, "North");
        comboAndSpinnerHolder.add((Component)spinnerHolder2, "Center");
        textOutHolder.add((Component)comboAndSpinnerHolder, "Center");
        textOutHolder.add((Component)checkHolder, "North");
        this.m_outputStepSpinner.setEnabled(false);
        this.m_outputStepLabel.setEnabled(false);
        this.m_outputPredsCombo.setEnabled(false);
        this.m_outputPredsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedConfigPanel.this.m_outputStepSpinner.setEnabled(AdvancedConfigPanel.this.m_outputPredsCheckBox.isSelected());
                AdvancedConfigPanel.this.m_outputStepLabel.setEnabled(AdvancedConfigPanel.this.m_outputPredsCheckBox.isSelected());
                AdvancedConfigPanel.this.m_outputPredsComboLabel.setEnabled(AdvancedConfigPanel.this.m_outputPredsCheckBox.isSelected());
                AdvancedConfigPanel.this.m_outputPredsCombo.setEnabled(AdvancedConfigPanel.this.m_outputPredsCheckBox.isSelected());
            }
        });
        JPanel temp1 = new JPanel();
        temp1.setLayout(new BorderLayout());
        temp1.add((Component)this.m_outputFutureCheckBox, "North");
        textOutHolder.add((Component)temp1, "South");
        outputOptsHolder.add(textOutHolder);
        this.m_outputFutureCheckBox.setSelected(true);
        JPanel graphOutputHolder = new JPanel();
        graphOutputHolder.setLayout(new BorderLayout());
        graphOutputHolder.setBorder(BorderFactory.createTitledBorder("Graphing options"));
        outputOptsHolder.add(graphOutputHolder);
        snm = new SpinnerNumberModel();
        snm.setValue(1);
        snm.setMinimum(Integer.valueOf(1));
        this.m_graphPredsAtStepSpinner = new JSpinner(snm);
        spinD = this.m_graphPredsAtStepSpinner.getPreferredSize();
        spinD = new Dimension((int)(spinD.getWidth() * 1.5), (int)spinD.getHeight());
        this.m_graphPredsAtStepSpinner.setPreferredSize(spinD);
        JPanel labAndSpinnerHolder = new JPanel();
        labAndSpinnerHolder.setLayout(new BorderLayout());
        labAndSpinnerHolder.add((Component)this.m_graphPredsAtStepCheckBox, "West");
        labAndSpinnerHolder.add((Component)this.m_graphPredsAtStepSpinner, "East");
        graphOutputHolder.add((Component)labAndSpinnerHolder, "North");
        this.m_graphPredsAtStepCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedConfigPanel.this.m_graphPredsAtStepSpinner.setEnabled(AdvancedConfigPanel.this.m_graphPredsAtStepCheckBox.isSelected());
            }
        });
        this.m_graphPredsAtStepSpinner.setEnabled(false);
        JPanel comboAndRangeHolder = new JPanel();
        comboAndRangeHolder.setLayout(new BorderLayout());
        comboAndRangeHolder.add((Component)this.m_graphTargetForStepsCheckBox, "North");
        JPanel temp2 = new JPanel();
        temp2.setLayout(new BorderLayout());
        temp2.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        temp2.add((Component)this.m_graphTargetAtStepsCombo, "East");
        temp2.add((Component)this.m_targetComboLabel, "Center");
        JPanel temp3 = new JPanel();
        temp3.setLayout(new BorderLayout());
        temp3.add((Component)temp2, "North");
        JPanel textHolder = new JPanel();
        textHolder.setLayout(new BorderLayout());
        textHolder.add((Component)this.m_stepRange, "East");
        this.m_stepRange.setPreferredSize(new Dimension((int)spinD.getWidth() * 2, (int)spinD.getHeight()));
        this.m_stepLab.setToolTipText("Comma separated list of step numbers to graph");
        this.m_stepRange.setToolTipText("Comma separated list of step numbers to graph");
        JPanel ll = new JPanel();
        ll.setLayout(new BorderLayout());
        ll.add((Component)this.m_stepLab, "East");
        textHolder.add((Component)ll, "Center");
        temp3.add((Component)textHolder, "Center");
        JPanel ll2 = new JPanel();
        ll2.setLayout(new BorderLayout());
        ll2.add((Component)temp3, "North");
        comboAndRangeHolder.add((Component)ll2, "Center");
        comboAndRangeHolder.add((Component)this.m_graphFutureCheckBox, "South");
        this.m_graphFutureCheckBox.setSelected(true);
        this.m_stepLab.setEnabled(false);
        this.m_stepRange.setEnabled(false);
        this.m_targetComboLabel.setEnabled(false);
        this.m_graphTargetAtStepsCombo.setEnabled(false);
        this.m_graphTargetForStepsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = AdvancedConfigPanel.this.m_graphTargetForStepsCheckBox.isSelected();
                AdvancedConfigPanel.this.m_stepLab.setEnabled(enabled);
                AdvancedConfigPanel.this.m_stepRange.setEnabled(enabled);
                AdvancedConfigPanel.this.m_targetComboLabel.setEnabled(enabled);
                AdvancedConfigPanel.this.m_graphTargetAtStepsCombo.setEnabled(enabled);
            }
        });
        graphOutputHolder.add((Component)comboAndRangeHolder, "Center");
        this.m_configHolder.addTab("Output", null, outputOptsHolder, "Configure output");
    }

    private Instances createDateDerivedPeriodicList() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("AM"));
        atts.add(new Attribute("DayOfWeek"));
        atts.add(new Attribute("DayOfMonth"));
        atts.add(new Attribute("NumDaysInMonth"));
        atts.add(new Attribute("Weekend"));
        atts.add(new Attribute("Month"));
        atts.add(new Attribute("Quarter"));
        for (String name : this.m_customPeriodics.keySet()) {
            atts.add(new Attribute("c_" + name));
        }
        Instances insts = new Instances("Periodics", atts, 1);
        return insts;
    }

    private String displayAddEditDialog(List<CustomPeriodicTest> testList, String fieldName) {
        int result;
        CustomPeriodicEditor ed = new CustomPeriodicEditor(testList);
        if (fieldName != null && fieldName.length() > 0) {
            ed.setFieldName(fieldName);
        }
        if ((result = JOptionPane.showConfirmDialog(this, ed, "Add/Edit custom periodic field", 2)) == 0) {
            if (testList.size() == 0) {
                return "";
            }
            return ed.getFieldName();
        }
        return "";
    }

    protected void layoutOverlayPanel() {
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        JPanel temp = new JPanel();
        temp.setLayout(new BorderLayout());
        JPanel checkHolder = new JPanel();
        checkHolder.setLayout(new BorderLayout());
        checkHolder.add((Component)this.m_useOverlayData, "North");
        this.m_useOverlayData.setEnabled(false);
        temp.add((Component)checkHolder, "East");
        temp.add((Component)((Object)this.m_overlaySelector), "Center");
        this.m_overlaySelector.setPreferredScrollableViewportSize(new Dimension(250, 70));
        JPanel botP = new JPanel();
        botP.setLayout(new BorderLayout());
        botP.setBorder(BorderFactory.createTitledBorder("Overlay data selection"));
        botP.add((Component)temp, "Center");
        this.m_useOverlayData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedConfigPanel.this.m_instances != null && AdvancedConfigPanel.this.m_useOverlayData.isSelected()) {
                    if (AdvancedConfigPanel.this.m_overlaySelector.getSelectionModel() != null) {
                        if (AdvancedConfigPanel.this.m_overlayHeader == null) {
                            AdvancedConfigPanel.this.m_overlayHeader = AdvancedConfigPanel.this.createAvailableOverlayList();
                        } else {
                            Instances newI = AdvancedConfigPanel.this.createAvailableOverlayList();
                            if (newI == null) {
                                AdvancedConfigPanel.this.m_overlaySelector.clearTableModel();
                                AdvancedConfigPanel.this.m_overlayHeader = null;
                                return;
                            }
                            if (!newI.equalHeaders(AdvancedConfigPanel.this.m_overlayHeader)) {
                                AdvancedConfigPanel.this.m_overlayHeader = newI;
                            }
                        }
                        AdvancedConfigPanel.this.m_overlaySelector.setInstances(AdvancedConfigPanel.this.m_overlayHeader);
                    }
                } else {
                    AdvancedConfigPanel.this.m_overlaySelector.clearTableModel();
                }
            }
        });
        basePanel.add((Component)botP, "North");
        this.m_configHolder.addTab("Overlay data", null, basePanel, "Specify attributes that are to be considered as \"overlay\" data");
    }

    protected void savePeriodicsToFile() throws IOException {
        int result;
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(new File(System.getProperty("user.home")));
            this.m_fileChooser.setFileSelectionMode(0);
            ExtensionFileFilter filter = new ExtensionFileFilter(".periodics", "Time series date-derived periodic attribute definitions (*periodics)");
            this.m_fileChooser.addChoosableFileFilter((FileFilter)filter);
        }
        if ((result = this.m_fileChooser.showSaveDialog(this)) == 0) {
            File saveFile = this.m_fileChooser.getSelectedFile();
            if (saveFile.toString().indexOf(".periodics") < 0) {
                saveFile = new File(saveFile.toString() + ".periodics");
            }
            PrintWriter br = new PrintWriter(new BufferedWriter(new FileWriter(saveFile)));
            br.print("time-series-periodics\n");
            int[] selected = this.m_dateDerivedPeriodicSelector.getSelectedAttributes();
            if (this.m_dateDerivedPeriodicsHeader != null) {
                for (int s : selected) {
                    String name = this.m_dateDerivedPeriodicsHeader.attribute(s).name();
                    if (s < 7) {
                        br.print("*pre-defined*:" + name + "\n");
                        continue;
                    }
                    name = name.replaceFirst("c_", "");
                    ArrayList<CustomPeriodicTest> selectedP = this.m_customPeriodics.get(name);
                    br.print("*custom*:" + name + "\n");
                    for (int j = 0; j < selectedP.size(); ++j) {
                        br.print(selectedP.get(j).toString() + "\n");
                    }
                }
            }
            br.flush();
            br.close();
        }
    }

    protected void loadPeriodicsFromFile() throws IOException {
        int result;
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(new File(System.getProperty("user.home")));
            this.m_fileChooser.setFileSelectionMode(0);
            ExtensionFileFilter filter = new ExtensionFileFilter(".periodics", "Time series date-derived periodic attribute definitions (*periodics)");
            this.m_fileChooser.addChoosableFileFilter((FileFilter)filter);
        }
        if ((result = this.m_fileChooser.showOpenDialog(this)) == 0) {
            File loadFile = this.m_fileChooser.getSelectedFile();
            BufferedReader br = new BufferedReader(new FileReader(loadFile));
            String identifierLine = br.readLine();
            boolean ok = false;
            if (identifierLine != null && identifierLine.equalsIgnoreCase("time-series-periodics")) {
                ok = true;
            }
            if (!ok) {
                JOptionPane.showConfirmDialog(this, "\"" + loadFile.toString() + "\" does not" + "\nappear to be a periodic attribute definition file", "Unrecognised file type", 0);
                return;
            }
            String line = null;
            boolean withinCustom = false;
            this.m_customPeriodics.clear();
            ArrayList<String> predefined = new ArrayList<String>();
            ArrayList<CustomPeriodicTest> testList = null;
            String currentCustomName = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("*pre-defined*:")) {
                    if (withinCustom) {
                        this.m_customPeriodics.put(currentCustomName, testList);
                    }
                    withinCustom = false;
                    line = line.substring(line.indexOf(":") + 1, line.length()).trim();
                    predefined.add(line);
                    continue;
                }
                if (line.startsWith("*custom*:")) {
                    if (withinCustom) {
                        this.m_customPeriodics.put(currentCustomName, testList);
                    }
                    testList = new ArrayList<CustomPeriodicTest>();
                    currentCustomName = line.substring(line.indexOf(":") + 1, line.length()).trim();
                    withinCustom = true;
                    continue;
                }
                if (!withinCustom) continue;
                try {
                    CustomPeriodicTest t = new CustomPeriodicTest(line);
                    testList.add(t);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                    JOptionPane.showConfirmDialog(this, "A problem occurred while parsing\nthe following custom periodic test:\n" + line, "Error parsing custom test", 0);
                    return;
                }
            }
            br.close();
            if (testList != null && testList.size() > 0) {
                this.m_customPeriodics.put(currentCustomName, testList);
            }
            this.m_dateDerivedPeriodicSelector.clearTableModel();
            Instances insts = this.createDateDerivedPeriodicList();
            this.m_dateDerivedPeriodicSelector.setInstances(insts);
            this.m_dateDerivedPeriodicsHeader = insts;
            boolean[] selected = new boolean[insts.numAttributes()];
            for (int i = 0; i < insts.numAttributes(); ++i) {
                if (i < 7) {
                    switch (i) {
                        case 0: {
                            if (!predefined.contains("AM")) break;
                            selected[i] = true;
                            break;
                        }
                        case 1: {
                            if (!predefined.contains("DayOfWeek")) break;
                            selected[i] = true;
                            break;
                        }
                        case 2: {
                            if (!predefined.contains("DayOfMonth")) break;
                            selected[i] = true;
                            break;
                        }
                        case 3: {
                            if (!predefined.contains("NumDaysInMonth")) break;
                            selected[i] = true;
                            break;
                        }
                        case 4: {
                            if (!predefined.contains("Weekend")) break;
                            selected[i] = true;
                            break;
                        }
                        case 5: {
                            if (!predefined.contains("Month")) break;
                            selected[i] = true;
                            break;
                        }
                        case 6: {
                            if (!predefined.contains("Quarter")) break;
                            selected[i] = true;
                        }
                    }
                    continue;
                }
                selected[i] = true;
            }
            try {
                this.m_dateDerivedPeriodicSelector.setSelectedAttributes(selected);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void layoutDateDerivedPeriodicPanel() {
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        JPanel temp = new JPanel();
        temp.setLayout(new BorderLayout());
        JPanel checkHolder = new JPanel();
        checkHolder.setLayout(new BorderLayout());
        checkHolder.add((Component)this.m_customizeDateDerivedPeriodics, "East");
        JPanel editButsP = new JPanel();
        editButsP.setLayout(new GridLayout(1, 5));
        editButsP.add(this.m_addCustomPeriodicBut);
        editButsP.add(this.m_deleteCustomPeriodicBut);
        editButsP.add(this.m_editCustomPeriodicBut);
        editButsP.add(this.m_savePeriodicBut);
        editButsP.add(this.m_loadPeriodicBut);
        this.m_loadPeriodicBut.setEnabled(false);
        this.m_savePeriodicBut.setEnabled(false);
        this.m_savePeriodicBut.setToolTipText("Save checked date-derived periodic definitions to a file");
        this.m_savePeriodicBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AdvancedConfigPanel.this.savePeriodicsToFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.m_loadPeriodicBut.setToolTipText("Load pre-saved date-derived periodic definitions from a file");
        this.m_loadPeriodicBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AdvancedConfigPanel.this.loadPeriodicsFromFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        checkHolder.add((Component)editButsP, "West");
        this.m_editCustomPeriodicBut.setEnabled(false);
        this.m_editCustomPeriodicBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getTable().getSelectedRow();
                if (selectedRow > 6) {
                    String fieldName = AdvancedConfigPanel.this.m_dateDerivedPeriodicsHeader.attribute(selectedRow).name();
                    ArrayList toEdit = AdvancedConfigPanel.this.m_customPeriodics.get(fieldName = fieldName.replaceFirst("c_", ""));
                    if (toEdit == null) {
                        System.err.println("Oh oh, couldn't find " + fieldName + " to edit!");
                    } else {
                        try {
                            SerializedObject so = new SerializedObject(toEdit);
                            toEdit = (ArrayList)so.getObject();
                            String newFieldName = AdvancedConfigPanel.this.displayAddEditDialog(toEdit, fieldName);
                            if (newFieldName.length() != 0) {
                                if (!newFieldName.equals(fieldName)) {
                                    AdvancedConfigPanel.this.m_customPeriodics.remove(fieldName);
                                    AdvancedConfigPanel.this.m_customPeriodics.put(newFieldName, toEdit);
                                    int[] selected = AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getSelectedAttributes();
                                    Instances insts = AdvancedConfigPanel.this.createDateDerivedPeriodicList();
                                    AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.setInstances(insts);
                                    AdvancedConfigPanel.this.m_dateDerivedPeriodicsHeader = insts;
                                    boolean[] newSelected = new boolean[insts.numAttributes()];
                                    for (int i = 0; i < selected.length; ++i) {
                                        newSelected[selected[i]] = true;
                                    }
                                    try {
                                        AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.setSelectedAttributes(newSelected);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                } else {
                                    AdvancedConfigPanel.this.m_customPeriodics.put(fieldName, toEdit);
                                }
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.m_deleteCustomPeriodicBut.setEnabled(false);
        this.m_deleteCustomPeriodicBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getTable().getSelectedRow();
                if (selectedRow > 6) {
                    String fieldName = AdvancedConfigPanel.this.m_dateDerivedPeriodicsHeader.attribute(selectedRow).name();
                    fieldName = fieldName.replaceFirst("c_", "");
                    int result = JOptionPane.showConfirmDialog(AdvancedConfigPanel.this, "Delete field " + fieldName + "?", "Delete custom periodic field", 0);
                    if (result == 1) {
                        return;
                    }
                    AdvancedConfigPanel.this.m_customPeriodics.remove(fieldName);
                    int[] selected = AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getSelectedAttributes();
                    Instances oldList = AdvancedConfigPanel.this.m_dateDerivedPeriodicsHeader;
                    Instances insts = AdvancedConfigPanel.this.createDateDerivedPeriodicList();
                    AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.setInstances(insts);
                    AdvancedConfigPanel.this.m_dateDerivedPeriodicsHeader = insts;
                    boolean[] newSelected = new boolean[insts.numAttributes()];
                    for (int element : selected) {
                        Attribute toFind = oldList.attribute(element);
                        Attribute toSet = insts.attribute(toFind.name());
                        if (toSet == null) continue;
                        newSelected[toSet.index()] = true;
                    }
                    try {
                        AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.setSelectedAttributes(newSelected);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.m_addCustomPeriodicBut.setEnabled(false);
        this.m_addCustomPeriodicBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList testList = new ArrayList();
                String fieldName = AdvancedConfigPanel.this.displayAddEditDialog(testList, null);
                if (fieldName.length() != 0) {
                    AdvancedConfigPanel.this.m_customPeriodics.put(fieldName, testList);
                    int[] selected = AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getSelectedAttributes();
                    Instances insts = AdvancedConfigPanel.this.createDateDerivedPeriodicList();
                    AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.setInstances(insts);
                    AdvancedConfigPanel.this.m_dateDerivedPeriodicsHeader = insts;
                    boolean[] newSelected = new boolean[insts.numAttributes()];
                    for (int i = 0; i < selected.length; ++i) {
                        newSelected[selected[i]] = true;
                    }
                    newSelected[newSelected.length - 1] = true;
                    try {
                        AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.setSelectedAttributes(newSelected);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        temp.add((Component)checkHolder, "North");
        temp.add((Component)((Object)this.m_dateDerivedPeriodicSelector), "Center");
        this.m_dateDerivedPeriodicSelector.setPreferredScrollableViewportSize(new Dimension(250, 80));
        JPanel botP = new JPanel();
        botP.setLayout(new BorderLayout());
        botP.setBorder(BorderFactory.createTitledBorder("Date-derived periodic creation"));
        botP.add((Component)temp, "Center");
        JPanel primaryPeriodicP = new JPanel();
        primaryPeriodicP.setLayout(new BorderLayout());
        primaryPeriodicP.add((Component)this.m_primaryPeriodicCombo, "North");
        JPanel topP = new JPanel();
        topP.setLayout(new BorderLayout());
        topP.setBorder(BorderFactory.createTitledBorder("Periodic attribute"));
        topP.add((Component)primaryPeriodicP, "East");
        JPanel temp2 = new JPanel();
        temp2.setLayout(new BorderLayout());
        temp2.add((Component)topP, "East");
        temp2.add((Component)botP, "Center");
        basePanel.add((Component)temp2, "North");
        this.m_customizeDateDerivedPeriodics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedConfigPanel.this.m_instances != null && AdvancedConfigPanel.this.m_customizeDateDerivedPeriodics.isSelected()) {
                    String selectedTimeStamp = AdvancedConfigPanel.this.m_simpleConfig.m_timeStampCombo.getSelectedItem().toString();
                    Attribute timeStampAtt = AdvancedConfigPanel.this.m_instances.attribute(selectedTimeStamp);
                    if (timeStampAtt != null && timeStampAtt.isDate() && AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getSelectionModel() != null) {
                        Instances insts = AdvancedConfigPanel.this.createDateDerivedPeriodicList();
                        AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.setInstances(insts);
                        AdvancedConfigPanel.this.m_dateDerivedPeriodicsHeader = insts;
                        AdvancedConfigPanel.this.m_addCustomPeriodicBut.setEnabled(true);
                        AdvancedConfigPanel.this.m_savePeriodicBut.setEnabled(true);
                        AdvancedConfigPanel.this.m_loadPeriodicBut.setEnabled(true);
                        AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                            @Override
                            public void valueChanged(ListSelectionEvent e) {
                                if (!e.getValueIsAdjusting()) {
                                    if (AdvancedConfigPanel.this.m_dateDerivedPeriodicSelector.getTable().getSelectedRow() > 6) {
                                        AdvancedConfigPanel.this.m_editCustomPeriodicBut.setEnabled(true);
                                        AdvancedConfigPanel.this.m_deleteCustomPeriodicBut.setEnabled(true);
                                    } else {
                                        AdvancedConfigPanel.this.m_editCustomPeriodicBut.setEnabled(false);
                                        AdvancedConfigPanel.this.m_deleteCustomPeriodicBut.setEnabled(false);
                                    }
                                }
                            }
                        });
                    }
                } else {
                    AdvancedConfigPanel.this.m_addCustomPeriodicBut.setEnabled(false);
                    AdvancedConfigPanel.this.m_loadPeriodicBut.setEnabled(false);
                    AdvancedConfigPanel.this.m_savePeriodicBut.setEnabled(false);
                }
            }
        });
        this.updatePrimaryPeriodic();
        this.m_configHolder.addTab("Periodic attributes", null, basePanel, "Specify/clustomize periodic attributes");
        this.updateDateDerivedPanel();
    }

    protected void layoutLearnerPanel() {
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        basePanel.setBorder(BorderFactory.createTitledBorder("Base learner configuration"));
        this.m_baseLearnerEditor.setClassType(Classifier.class);
        this.m_baseLearnerEditor.setValue((Object)new LinearRegression());
        Capabilities capabilities = new Capabilities(null);
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enableAllAttributeDependencies();
        capabilities.enableAllClassDependencies();
        this.m_baseLearnerEditor.setCapabilitiesFilter(capabilities);
        basePanel.add((Component)this.m_baseLearnerPanel, "North");
        this.m_configHolder.addTab("Base learner", null, basePanel, "Base learner configuration");
    }

    protected void layoutLagPanel() {
        JPanel lagPanel = new JPanel();
        lagPanel.setLayout(new GridLayout(1, 2));
        SpinnerNumberModel snm = new SpinnerNumberModel();
        snm.setValue(1);
        snm.setMinimum(Integer.valueOf(1));
        this.m_minLagSpinner = new JSpinner(snm);
        Dimension spinD = this.m_minLagSpinner.getPreferredSize();
        spinD = new Dimension((int)(spinD.getWidth() * 1.5), (int)spinD.getHeight());
        this.m_minLagSpinner.setPreferredSize(spinD);
        JPanel temp1 = new JPanel();
        temp1.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 5));
        temp1.setLayout(new BorderLayout());
        final JLabel minLagLab = new JLabel("Minimum lag", 4);
        temp1.add((Component)minLagLab, "Center");
        temp1.add((Component)this.m_minLagSpinner, "East");
        JPanel spinnerHolder = new JPanel();
        spinnerHolder.setLayout(new BorderLayout());
        spinnerHolder.setBorder(BorderFactory.createTitledBorder("Lag length"));
        JPanel minMaxHolder = new JPanel();
        minMaxHolder.setLayout(new BorderLayout());
        minMaxHolder.add((Component)temp1, "Center");
        this.m_powersOfTime.setSelected(true);
        this.m_timeLagProducts.setSelected(true);
        this.m_removeLeadingInstancesWithMissingLags.setToolTipText("Remove initial instances where the values of lagged variables are unknown (missing)");
        this.m_adjustForVarianceCheckBox.setSelected(false);
        JPanel checkHolder = new JPanel();
        checkHolder.setLayout(new BorderLayout());
        checkHolder.add((Component)this.m_useCustomLags, "East");
        minMaxHolder.add((Component)checkHolder, "North");
        spinnerHolder.add((Component)minMaxHolder, "North");
        JPanel moreOptsHolder = new JPanel();
        moreOptsHolder.setLayout(new BorderLayout());
        moreOptsHolder.add((Component)this.m_moreOptsBut, "East");
        spinnerHolder.add((Component)moreOptsHolder, "South");
        this.m_moreOptsBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedConfigPanel.this.m_moreOptsBut.setEnabled(false);
                JPanel moreOptsPanel = new JPanel();
                moreOptsPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
                moreOptsPanel.setLayout(new GridLayout(0, 1));
                moreOptsPanel.add(AdvancedConfigPanel.this.m_removeLeadingInstancesWithMissingLags);
                moreOptsPanel.add(AdvancedConfigPanel.this.m_powersOfTime);
                moreOptsPanel.add(AdvancedConfigPanel.this.m_timeLagProducts);
                moreOptsPanel.add(AdvancedConfigPanel.this.m_adjustForVarianceCheckBox);
                JPanel butHolder = new JPanel();
                butHolder.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                JButton oK = new JButton("OK");
                butHolder.add((Component)oK, "Center");
                JPanel allP = new JPanel();
                allP.setLayout(new BorderLayout());
                allP.add((Component)moreOptsPanel, "Center");
                allP.add((Component)butHolder, "South");
                final JDialog jd = new JDialog(PropertyDialog.getParentFrame((Container)AdvancedConfigPanel.this), "More options");
                jd.getContentPane().setLayout(new BorderLayout());
                jd.getContentPane().add((Component)allP, "Center");
                jd.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        jd.dispose();
                        AdvancedConfigPanel.this.m_moreOptsBut.setEnabled(true);
                    }
                });
                oK.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        AdvancedConfigPanel.this.m_moreOptsBut.setEnabled(true);
                        jd.dispose();
                    }
                });
                jd.pack();
                jd.setLocation(AdvancedConfigPanel.this.m_moreOptsBut.getLocationOnScreen());
                jd.setVisible(true);
            }
        });
        snm = new SpinnerNumberModel();
        snm.setValue(12);
        snm.setMinimum(Integer.valueOf(1));
        this.m_maxLagSpinner = new JSpinner(snm);
        this.m_maxLagSpinner.setPreferredSize(spinD);
        JPanel temp2 = new JPanel();
        temp2.setLayout(new BorderLayout());
        temp2.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        final JLabel maxLagLab = new JLabel("Maximum lag", 4);
        temp2.add((Component)maxLagLab, "Center");
        temp2.add((Component)this.m_maxLagSpinner, "East");
        minMaxHolder.add((Component)temp2, "East");
        final JLabel fineTuneLab = new JLabel("Fine tune lag selection", 4);
        JPanel fPanel = new JPanel();
        fPanel.setLayout(new BorderLayout());
        JPanel fineHolder = new JPanel();
        fineHolder.setLayout(new BorderLayout());
        fineHolder.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        fineHolder.add((Component)fineTuneLab, "Center");
        fineHolder.add((Component)this.m_fineTuneLagsField, "East");
        this.m_fineTuneLagsField.setPreferredSize(spinD);
        fineTuneLab.setEnabled(false);
        fineTuneLab.setToolTipText("Specify ranges to fine tune lags within minimum and maximum (e.g. 2,3,6-8)");
        this.m_fineTuneLagsField.setEnabled(false);
        this.m_fineTuneLagsField.setToolTipText("Specify ranges to fine tune lags within minimum and maximum (e.g. 2,3,6-8)");
        fPanel.add((Component)fineHolder, "South");
        spinnerHolder.add((Component)fPanel, "Center");
        this.m_useCustomLags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = AdvancedConfigPanel.this.m_useCustomLags.isSelected();
                AdvancedConfigPanel.this.m_minLagSpinner.setEnabled(enabled);
                AdvancedConfigPanel.this.m_maxLagSpinner.setEnabled(enabled);
                minLagLab.setEnabled(enabled);
                maxLagLab.setEnabled(enabled);
                fineTuneLab.setEnabled(enabled);
                AdvancedConfigPanel.this.m_fineTuneLagsField.setEnabled(enabled);
                AdvancedConfigPanel.this.m_averageLongLags.setEnabled(enabled);
                if (!enabled) {
                    AdvancedConfigPanel.this.m_averageLongLags.setSelected(false);
                }
            }
        });
        snm = new SpinnerNumberModel();
        snm.setValue(2);
        snm.setMinimum(Integer.valueOf(1));
        this.m_averageLagsAfter = new JSpinner(snm);
        this.m_averageLagsAfter.setPreferredSize(spinD);
        snm = new SpinnerNumberModel();
        snm.setValue(2);
        snm.setMinimum(Integer.valueOf(2));
        this.m_numConsecutiveToAverage = new JSpinner(snm);
        this.m_numConsecutiveToAverage.setPreferredSize(spinD);
        JPanel averageLagHolder = new JPanel();
        averageLagHolder.setBorder(BorderFactory.createTitledBorder("Averaging"));
        averageLagHolder.setLayout(new BorderLayout());
        JPanel avCheckHolder = new JPanel();
        avCheckHolder.setLayout(new BorderLayout());
        avCheckHolder.add((Component)this.m_averageLongLags, "East");
        averageLagHolder.add((Component)avCheckHolder, "North");
        JPanel temp3 = new JPanel();
        temp3.setLayout(new BorderLayout());
        temp3.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        final JLabel avLab = new JLabel("Average lags longer than", 4);
        temp3.add((Component)avLab, "Center");
        temp3.add((Component)this.m_averageLagsAfter, "East");
        JPanel aH = new JPanel();
        aH.setLayout(new BorderLayout());
        aH.add((Component)temp3, "North");
        JPanel temp4 = new JPanel();
        temp4.setLayout(new BorderLayout());
        temp4.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        final JLabel numConsLab = new JLabel("# consecutive lags to average", 4);
        temp4.add((Component)numConsLab, "Center");
        temp4.add((Component)this.m_numConsecutiveToAverage, "East");
        aH.add((Component)temp4, "South");
        averageLagHolder.add((Component)aH, "South");
        this.m_useCustomLags.setSelected(false);
        this.m_minLagSpinner.setEnabled(false);
        this.m_maxLagSpinner.setEnabled(false);
        minLagLab.setEnabled(false);
        maxLagLab.setEnabled(false);
        this.m_averageLongLags.setEnabled(false);
        avLab.setEnabled(false);
        this.m_averageLagsAfter.setEnabled(false);
        this.m_numConsecutiveToAverage.setEnabled(false);
        numConsLab.setEnabled(false);
        this.m_averageLongLags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedConfigPanel.this.m_useCustomLags.isSelected()) {
                    boolean enabled = AdvancedConfigPanel.this.m_averageLongLags.isSelected();
                    AdvancedConfigPanel.this.m_averageLagsAfter.setEnabled(enabled);
                    AdvancedConfigPanel.this.m_numConsecutiveToAverage.setEnabled(enabled);
                    avLab.setEnabled(enabled);
                    numConsLab.setEnabled(enabled);
                }
            }
        });
        lagPanel.add(spinnerHolder);
        lagPanel.add(averageLagHolder);
        JPanel tempP = new JPanel();
        tempP.setLayout(new BorderLayout());
        tempP.add((Component)lagPanel, "North");
        this.m_configHolder.addTab("Lag creation", null, tempP, "Customize lagged variables");
    }

    public void applyToForecaster(WekaForecaster forecaster) throws Exception {
        if (forecaster != null) {
            String ppfn;
            TSLagMaker lagMaker = forecaster.getTSLagMaker();
            lagMaker.setRemoveLeadingInstancesWithUnknownLagValues(this.m_removeLeadingInstancesWithMissingLags.isSelected());
            lagMaker.setIncludePowersOfTime(this.m_powersOfTime.isSelected());
            lagMaker.setIncludeTimeLagProducts(this.m_timeLagProducts.isSelected());
            lagMaker.setAdjustForVariance(this.m_adjustForVarianceCheckBox.isSelected());
            int minLag = ((SpinnerNumberModel)this.m_minLagSpinner.getModel()).getNumber().intValue();
            int maxLag = ((SpinnerNumberModel)this.m_maxLagSpinner.getModel()).getNumber().intValue();
            if (forecaster.getBaseForecaster() instanceof PrimingDataLearner && maxLag < ((PrimingDataLearner)forecaster.getBaseForecaster()).getMinRequiredTrainingPoints()) {
                maxLag = ((PrimingDataLearner)forecaster.getBaseForecaster()).getMinRequiredTrainingPoints();
                this.m_maxLagSpinner.setValue(maxLag);
                lagMaker.setMaxLag(maxLag);
            }
            if (this.m_useCustomLags.isSelected()) {
                if (maxLag < minLag) {
                    throw new Exception("Maximum lag value must be greater than or equal to the minimum lag value");
                }
                if (this.m_instances != null && maxLag > this.m_instances.numInstances()) {
                    throw new Exception("The maximum lag can't exceed the number instances (" + this.m_instances.numInstances() + ") in the data!");
                }
                lagMaker.setMinLag(minLag);
                lagMaker.setMaxLag(maxLag);
                if (this.m_fineTuneLagsField.getText() != null && this.m_fineTuneLagsField.getText().length() > 0) {
                    lagMaker.setLagRange(this.m_fineTuneLagsField.getText());
                } else {
                    lagMaker.setLagRange("");
                }
                if (this.m_averageLongLags.isSelected()) {
                    lagMaker.setAverageConsecutiveLongLags(true);
                    int avLagsAfter = ((SpinnerNumberModel)this.m_averageLagsAfter.getModel()).getNumber().intValue();
                    int numToAv = ((SpinnerNumberModel)this.m_numConsecutiveToAverage.getModel()).getNumber().intValue();
                    if (avLagsAfter < minLag || avLagsAfter > maxLag) {
                        throw new Exception("Point at which to start lag averaging must lie between the minimum and maximum lag value.");
                    }
                    lagMaker.setAverageLagsAfter(avLagsAfter);
                    lagMaker.setNumConsecutiveLongLagsToAverage(numToAv);
                } else {
                    lagMaker.setAverageConsecutiveLongLags(false);
                }
            } else {
                lagMaker.setAverageConsecutiveLongLags(false);
                lagMaker.setLagRange("");
            }
            if (this.getCustomizeDateDerivedPeriodics()) {
                lagMaker.setAddAMIndicator(false);
                lagMaker.setAddDayOfWeek(false);
                lagMaker.setAddMonthOfYear(false);
                lagMaker.setAddQuarterOfYear(false);
                lagMaker.setAddWeekendIndicator(false);
                lagMaker.setAddDayOfMonth(false);
                lagMaker.setAddNumDaysInMonth(false);
                int[] selected = this.m_dateDerivedPeriodicSelector.getSelectedAttributes();
                if (this.m_dateDerivedPeriodicsHeader != null) {
                    HashMap<String, ArrayList<CustomPeriodicTest>> custom = new HashMap<String, ArrayList<CustomPeriodicTest>>();
                    for (int s : selected) {
                        String name = this.m_dateDerivedPeriodicsHeader.attribute(s).name();
                        if (s < 7) {
                            if (name.equals("AM")) {
                                lagMaker.setAddAMIndicator(true);
                            }
                            if (name.equals("DayOfWeek")) {
                                lagMaker.setAddDayOfWeek(true);
                            }
                            if (name.equals("DayOfMonth")) {
                                lagMaker.setAddDayOfMonth(true);
                            }
                            if (name.equals("NumDaysInMonth")) {
                                lagMaker.setAddNumDaysInMonth(true);
                            }
                            if (name.equals("Weekend")) {
                                lagMaker.setAddWeekendIndicator(true);
                            }
                            if (name.equals("Month")) {
                                lagMaker.setAddMonthOfYear(true);
                            }
                            if (!name.equals("Quarter")) continue;
                            lagMaker.setAddQuarterOfYear(true);
                            continue;
                        }
                        name = name.replaceFirst("c_", "");
                        ArrayList<CustomPeriodicTest> selectedP = this.m_customPeriodics.get(name);
                        custom.put(name, selectedP);
                    }
                    lagMaker.clearCustomPeriodics();
                    if (custom.size() > 0) {
                        lagMaker.setCustomPeriodics(custom);
                    }
                }
            }
            if (!(ppfn = this.m_primaryPeriodicCombo.getSelectedItem().toString()).equals("<None>")) {
                lagMaker.setPrimaryPeriodicFieldName(ppfn);
            } else {
                lagMaker.setPrimaryPeriodicFieldName("");
            }
            if (this.m_useOverlayData.isSelected() && this.m_overlayHeader != null && forecaster instanceof OverlayForecaster) {
                int[] selected = this.m_overlaySelector.getSelectedAttributes();
                String overlayList = "";
                for (int element : selected) {
                    overlayList = overlayList + this.m_overlayHeader.attribute(element).name() + ",";
                }
                if (overlayList.length() > 0) {
                    overlayList = overlayList.substring(0, overlayList.lastIndexOf(44));
                    forecaster.setOverlayFields(overlayList);
                } else {
                    forecaster.setOverlayFields(null);
                }
            } else if (forecaster instanceof OverlayForecaster) {
                forecaster.setOverlayFields(null);
            }
        }
    }

    public void applyToEvaluation(TSEvaluation eval, WekaForecaster forecaster) throws Exception {
        int[] selected;
        eval.setEvaluateOnTrainingData(this.m_trainingCheckBox.isSelected());
        if (eval.getEvaluateOnTrainingData() || !eval.getEvaluateOnTestData()) {
            // empty if block
        }
        if ((selected = this.m_evaluationMetrics.getSelectedAttributes()).length == 0) {
            throw new Exception("Must select at least one evaluation metric.");
        }
        List<TSEvalModule> modsList = TSEvalModule.getModuleList();
        String modListS = "";
        for (int s : selected) {
            String name = this.m_evaluationModsHeader.attribute(s).name();
            for (TSEvalModule mod : modsList) {
                if (!name.equals(mod.toString())) continue;
                modListS = modListS + mod.getEvalName() + ",";
            }
        }
        modListS = modListS.substring(0, modListS.lastIndexOf(44));
        eval.setEvaluationModules(modListS);
    }

    static {
        GenericObjectEditor.registerEditors();
    }

    protected class AttributeSelectionPanelExtended
    extends AttributeSelectionPanel {
        private static final long serialVersionUID = -6863797282164060690L;

        public AttributeSelectionPanelExtended(boolean include, boolean remove, boolean invert, boolean pattern) {
            super(include, remove, invert, pattern);
        }

        public JTable getTable() {
            return this.m_Table;
        }

        public void clearTableModel() {
            this.m_Model = null;
            this.m_Table.setModel(new DefaultTableModel());
            this.m_Table.revalidate();
            this.m_Table.repaint();
        }
    }
}

