/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import weka.classifiers.timeseries.WekaForecaster;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.classifiers.timeseries.eval.TSEvaluation;
import weka.classifiers.timeseries.gui.AdvancedConfigPanel;
import weka.classifiers.timeseries.gui.ForecastingPanel;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AttributeSelectionPanel;

public class SimpleConfigPanel
extends JPanel {
    private static final long serialVersionUID = 4339062970124604791L;
    protected Instances m_instances;
    protected WekaForecaster m_forecaster;
    protected Instances m_targetHeader;
    protected JComboBox m_timeStampCombo = new JComboBox();
    protected JComboBox m_periodicityCombo = new JComboBox();
    protected AttributeSelectionPanel m_targetPanel = new AttributeSelectionPanel();
    protected JCheckBox m_computeConfidence = new JCheckBox();
    protected JSpinner m_horizonSpinner;
    protected JSpinner m_confidenceLevelSpinner;
    protected JCheckBox m_performEvaluation = new JCheckBox();
    protected AdvancedConfigPanel m_advancedConfig;
    protected JTextField m_skipText = new JTextField(18);
    protected ForecastingPanel m_parentPanel;

    public SimpleConfigPanel(ForecastingPanel parent) {
        this.m_parentPanel = parent;
        this.setLayout(new BorderLayout());
        JPanel colSelect = new JPanel();
        colSelect.setLayout(new BorderLayout());
        colSelect.setBorder(BorderFactory.createTitledBorder("Target Selection"));
        JPanel tempHolder1 = new JPanel();
        tempHolder1.setLayout(new BorderLayout());
        tempHolder1.add((Component)this.m_targetPanel, "North");
        colSelect.add((Component)tempHolder1, "North");
        this.m_targetPanel.setPreferredScrollableViewportSize(new Dimension(250, 80));
        SpinnerNumberModel snm = new SpinnerNumberModel();
        snm.setValue(1);
        snm.setMinimum(Integer.valueOf(1));
        this.m_horizonSpinner = new JSpinner(snm);
        Dimension spinD = this.m_horizonSpinner.getPreferredSize();
        spinD = new Dimension((int)(spinD.getWidth() * 1.5), (int)spinD.getHeight());
        this.m_horizonSpinner.setPreferredSize(spinD);
        JPanel spinnerHolder = new JPanel();
        spinnerHolder.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        spinnerHolder.setLayout(new BorderLayout());
        spinnerHolder.add((Component)this.m_horizonSpinner, "East");
        spinnerHolder.add((Component)new JLabel("Number of time units to forecast ", 2), "Center");
        this.add((Component)colSelect, "Center");
        Box comboHolder = new Box(3);
        comboHolder.add(spinnerHolder);
        JPanel timeHolder = new JPanel();
        timeHolder.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        timeHolder.setLayout(new BorderLayout());
        timeHolder.add((Component)new JLabel("Time stamp ", 4), "West");
        timeHolder.add((Component)this.m_timeStampCombo, "East");
        comboHolder.add(timeHolder);
        JPanel periodicityHolder = new JPanel();
        periodicityHolder.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        periodicityHolder.setLayout(new BorderLayout());
        periodicityHolder.add((Component)new JLabel("Periodicity", 4), "West");
        periodicityHolder.add((Component)this.m_periodicityCombo, "East");
        comboHolder.add(periodicityHolder);
        this.m_periodicityCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleConfigPanel.this.checkSkipEnabledStatus();
                SimpleConfigPanel.this.checkPeriodicity(null);
            }
        });
        JPanel skipPanel = new JPanel();
        skipPanel.setLayout(new BorderLayout());
        skipPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        String skipTipText = "<html>Set date time stamp values that should be 'skipped'<br>i.e. times that shouldn't count as a time step increment.<br><br>E.g. financial trading does not occur on the weekend, so the <br>difference between Friday and the following Monday is actually one<br>time step (not three).<br><br>Examples:<br><br>\"sat,weekend,aug,2011-01-11@yyyy-MM-dd\"</html>";
        JLabel skipLab = new JLabel("Skip list", 4);
        skipLab.setToolTipText(skipTipText);
        skipPanel.add((Component)skipLab, "West");
        skipPanel.add((Component)this.m_skipText, "East");
        this.m_skipText.setToolTipText(skipTipText);
        comboHolder.add(skipPanel);
        this.m_computeConfidence.setHorizontalTextPosition(2);
        JPanel confHolder = new JPanel();
        confHolder.setLayout(new BorderLayout());
        confHolder.add((Component)new JLabel("Confidence intervals", 4), "West");
        confHolder.add((Component)this.m_computeConfidence, "East");
        comboHolder.add(confHolder);
        JPanel confLevHolder = new JPanel();
        confLevHolder.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        confLevHolder.setLayout(new BorderLayout());
        final JLabel levelLab = new JLabel("Level (%) ", 4);
        levelLab.setEnabled(false);
        snm = new SpinnerNumberModel();
        snm.setValue(95);
        snm.setMinimum(Integer.valueOf(1));
        snm.setMaximum(Integer.valueOf(99));
        this.m_confidenceLevelSpinner = new JSpinner(snm);
        this.m_confidenceLevelSpinner.setEnabled(false);
        confLevHolder.add((Component)this.m_confidenceLevelSpinner, "East");
        confLevHolder.add((Component)levelLab, "Center");
        comboHolder.add(confLevHolder);
        this.m_computeConfidence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = SimpleConfigPanel.this.m_computeConfidence.isSelected();
                levelLab.setEnabled(enable);
                SimpleConfigPanel.this.m_confidenceLevelSpinner.setEnabled(enable);
            }
        });
        JPanel evalHolder = new JPanel();
        evalHolder.setLayout(new BorderLayout());
        evalHolder.add((Component)new JLabel("Perform evaluation", 4), "West");
        this.m_performEvaluation.setHorizontalAlignment(2);
        evalHolder.add((Component)this.m_performEvaluation, "East");
        comboHolder.add(evalHolder);
        this.m_performEvaluation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleConfigPanel.this.m_advancedConfig.m_trainingCheckBox.setSelected(SimpleConfigPanel.this.m_performEvaluation.isSelected());
                if (!SimpleConfigPanel.this.m_performEvaluation.isSelected()) {
                    SimpleConfigPanel.this.m_advancedConfig.m_holdoutCheckBox.setSelected(false);
                }
            }
        });
        JPanel temp = new JPanel();
        temp.setLayout(new BorderLayout());
        temp.setBorder(BorderFactory.createTitledBorder("Parameters"));
        temp.add((Component)comboHolder, "North");
        this.add((Component)temp, "East");
        this.m_timeStampCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleConfigPanel.this.m_advancedConfig != null) {
                    SimpleConfigPanel.this.m_advancedConfig.updateDateDerivedPanel();
                    SimpleConfigPanel.this.checkSkipEnabledStatus();
                }
            }
        });
    }

    private void checkSkipEnabledStatus() {
        String timeName;
        Attribute timeAtt;
        boolean enable = false;
        if (this.m_instances != null && this.m_timeStampCombo.getSelectedItem() != null && (timeAtt = this.m_instances.attribute(timeName = this.m_timeStampCombo.getSelectedItem().toString())) != null && this.m_periodicityCombo.getSelectedItem() != null) {
            String periodicity = this.m_periodicityCombo.getSelectedItem().toString();
            enable = timeAtt.isDate() && !periodicity.equals("<Unknown>") && !periodicity.equals("<Detect automatically>");
        }
        this.m_skipText.setEnabled(enable);
    }

    public String getTabTitle() {
        return "Basic configuration";
    }

    public String getTabTitleToolTip() {
        return "Basic configuration";
    }

    public int getHorizonValue() {
        SpinnerNumberModel snm = (SpinnerNumberModel)this.m_horizonSpinner.getModel();
        return snm.getNumber().intValue();
    }

    public void setAdvancedConfig(AdvancedConfigPanel adv) {
        this.m_advancedConfig = adv;
    }

    public void setForecaster(WekaForecaster forecaster) {
        this.m_forecaster = forecaster;
        if (this.m_instances != null) {
            if (!this.m_forecaster.getTSLagMaker().getAdjustForTrends()) {
                this.m_timeStampCombo.setSelectedItem("<None>");
                this.m_periodicityCombo.setSelectedIndex(0);
            } else if (this.m_forecaster.getTSLagMaker().isUsingAnArtificialTimeIndex()) {
                this.m_timeStampCombo.setSelectedItem("<Use an artificial time index>");
            } else if (this.m_forecaster.getTSLagMaker().getTimeStampField() != null && this.m_forecaster.getTSLagMaker().getTimeStampField().length() > 0) {
                this.m_timeStampCombo.setSelectedItem(this.m_forecaster.getTSLagMaker().getTimeStampField());
            }
            int maxLag = this.m_forecaster.getTSLagMaker().getMaxLag();
            if (maxLag == 24) {
                this.m_periodicityCombo.setSelectedItem("Hourly");
            }
            if (maxLag == 7) {
                this.m_periodicityCombo.setSelectedItem("Daily");
            }
            if (maxLag == 5) {
                this.m_periodicityCombo.setSelectedItem("Weekly");
            }
            if (maxLag == 12) {
                this.m_periodicityCombo.setSelectedItem("Monthly");
            }
            if (maxLag == 4) {
                this.m_periodicityCombo.setSelectedItem("Quarterly");
            }
            if (maxLag == 5) {
                this.m_periodicityCombo.setSelectedItem("Yearly");
            } else {
                this.m_periodicityCombo.setSelectedItem("<Unknown>");
            }
        }
    }

    public boolean isUsingANativeTimeStamp() {
        String selected = this.m_timeStampCombo.getSelectedItem().toString();
        return !selected.equals("<None>") && !selected.equals("<Use an artificial time index>");
    }

    public String getSelectedTimeStampField() {
        return this.m_timeStampCombo.getSelectedItem().toString();
    }

    public WekaForecaster getForecaster() {
        return this.m_forecaster;
    }

    public void setHorizon(int horizon) {
        this.m_horizonSpinner.setValue(horizon);
    }

    public int getHorizon() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.m_horizonSpinner.getModel();
        return model.getNumber().intValue();
    }

    public void setInstances(Instances insts) throws Exception {
        this.m_instances = insts;
        String removeList = "";
        for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
            if (!this.m_instances.attribute(i).isDate() && !this.m_instances.attribute(i).isNominal() && !this.m_instances.attribute(i).isString() && !this.m_instances.attribute(i).isRelationValued()) continue;
            removeList = removeList + (i + 1) + ",";
        }
        this.m_targetHeader = new Instances(this.m_instances, 0);
        if (removeList.length() > 0) {
            removeList = removeList.substring(0, removeList.lastIndexOf(","));
            Remove r = new Remove();
            r.setAttributeIndices(removeList);
            r.setInputFormat(this.m_instances);
            this.m_targetHeader = Filter.useFilter((Instances)this.m_instances, (Filter)r);
            this.m_targetHeader = new Instances(this.m_targetHeader, 0);
        }
        this.m_targetPanel.setInstances(this.m_targetHeader);
        if (this.m_targetHeader.numAttributes() == 1) {
            this.m_targetPanel.setSelectedAttributes(new boolean[]{true});
            if (this.m_parentPanel != null) {
                this.m_parentPanel.enableStartButton(true);
            }
        }
        this.setupTimeCombo();
        this.setupPeriodicityCombo();
    }

    protected void setupTimeCombo() {
        Vector<String> candidateNames = new Vector<String>();
        candidateNames.add("<Use an artificial time index>");
        candidateNames.add("<None>");
        String firstDateName = null;
        for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
            if (this.m_instances.attribute(i).isNumeric()) {
                candidateNames.add(this.m_instances.attribute(i).name());
            }
            if (!this.m_instances.attribute(i).isDate() || firstDateName != null) continue;
            firstDateName = this.m_instances.attribute(i).name();
        }
        this.m_timeStampCombo.setModel(new DefaultComboBoxModel(candidateNames));
        if (firstDateName != null) {
            this.m_timeStampCombo.setSelectedItem(firstDateName);
        }
    }

    protected void setupPeriodicityCombo() {
        Vector<String> candidateNames = new Vector<String>();
        candidateNames.add("<Unknown>");
        candidateNames.add("<Detect automatically>");
        candidateNames.add("Hourly");
        candidateNames.add("Daily");
        candidateNames.add("Weekly");
        candidateNames.add("Monthly");
        candidateNames.add("Quarterly");
        candidateNames.add("Yearly");
        this.m_periodicityCombo.setModel(new DefaultComboBoxModel(candidateNames));
        String timeSelected = (String)this.m_timeStampCombo.getSelectedItem();
        System.err.println("Selected " + timeSelected);
        if (timeSelected != null && timeSelected.length() > 0 && !timeSelected.equals("<None>") && !timeSelected.equals("<Use an artificial time index>") && this.m_instances.attribute(timeSelected).isDate()) {
            this.m_periodicityCombo.setSelectedItem("<Detect automatically>");
        }
    }

    protected void checkPeriodicity(WekaForecaster forecaster) {
        if (this.m_advancedConfig != null) {
            String timeStampSelected = this.m_timeStampCombo.getSelectedItem().toString();
            String selectedP = this.m_periodicityCombo.getSelectedItem().toString();
            if (selectedP.equals("<Detect automatically>") && !timeStampSelected.equals("<Use an artificial time index>") && !timeStampSelected.equals("<None>") && forecaster != null) {
                forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.UNKNOWN);
                TSLagMaker.PeriodicityHandler detected = TSLagMaker.determinePeriodicity(this.m_instances, forecaster.getTSLagMaker().getTimeStampField(), forecaster.getTSLagMaker().getPeriodicity());
                switch (detected.getPeriodicity()) {
                    case HOURLY: {
                        selectedP = "Hourly";
                        break;
                    }
                    case DAILY: {
                        selectedP = "Daily";
                        break;
                    }
                    case WEEKLY: {
                        selectedP = "Weekly";
                        break;
                    }
                    case MONTHLY: {
                        selectedP = "Monthly";
                        break;
                    }
                    case QUARTERLY: {
                        selectedP = "Quarterly";
                        break;
                    }
                    case YEARLY: {
                        selectedP = "Yearly";
                    }
                }
            }
            if (forecaster != null) {
                if (selectedP.equals("Hourly")) {
                    forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.HOURLY);
                } else if (selectedP.equals("Daily")) {
                    forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.DAILY);
                } else if (selectedP.equals("Weekly")) {
                    forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.WEEKLY);
                } else if (selectedP.equals("Monthly")) {
                    forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.MONTHLY);
                } else if (selectedP.equals("Quarterly")) {
                    forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.QUARTERLY);
                } else if (selectedP.equals("Yearly")) {
                    forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.YEARLY);
                } else {
                    forecaster.getTSLagMaker().setPeriodicity(TSLagMaker.Periodicity.UNKNOWN);
                }
                if (this.m_skipText.isEnabled() && this.m_skipText.getText() != null && this.m_skipText.getText().length() > 0) {
                    forecaster.getTSLagMaker().setSkipEntries(this.m_skipText.getText().trim());
                } else {
                    forecaster.getTSLagMaker().setSkipEntries("");
                }
            }
            if (!this.m_advancedConfig.isUsingCustomLags()) {
                if (forecaster != null) {
                    forecaster.getTSLagMaker().setMinLag(1);
                }
                this.m_advancedConfig.m_minLagSpinner.setValue(1);
                if (selectedP.equals("Hourly")) {
                    if (forecaster != null) {
                        forecaster.getTSLagMaker().setMaxLag(Math.min(this.m_instances.numInstances() / 2, 24));
                    }
                    this.m_advancedConfig.m_maxLagSpinner.setValue(Math.min(this.m_instances.numInstances() / 2, 24));
                } else if (selectedP.equals("Daily")) {
                    if (forecaster != null) {
                        forecaster.getTSLagMaker().setMaxLag(Math.min(this.m_instances.numInstances() / 2, 7));
                    }
                    this.m_advancedConfig.m_maxLagSpinner.setValue(Math.min(this.m_instances.numInstances() / 2, 7));
                } else if (selectedP.equals("Weekly")) {
                    if (forecaster != null) {
                        forecaster.getTSLagMaker().setMaxLag(Math.min(this.m_instances.numInstances() / 2, 52));
                    }
                    this.m_advancedConfig.m_maxLagSpinner.setValue(Math.min(this.m_instances.numInstances() / 2, 52));
                } else if (selectedP.equals("Monthly")) {
                    if (forecaster != null) {
                        forecaster.getTSLagMaker().setMaxLag(Math.min(this.m_instances.numInstances() / 2, 12));
                    }
                    this.m_advancedConfig.m_maxLagSpinner.setValue(Math.min(this.m_instances.numInstances() / 2, 12));
                } else if (selectedP.equals("Quarterly")) {
                    if (forecaster != null) {
                        forecaster.getTSLagMaker().setMaxLag(Math.min(this.m_instances.numInstances() / 2, 4));
                    }
                    this.m_advancedConfig.m_maxLagSpinner.setValue(Math.min(this.m_instances.numInstances() / 2, 4));
                } else if (selectedP.equals("Yearly")) {
                    if (forecaster != null) {
                        forecaster.getTSLagMaker().setMaxLag(Math.min(this.m_instances.numInstances() / 2, 5));
                    }
                    this.m_advancedConfig.m_maxLagSpinner.setValue(Math.min(this.m_instances.numInstances() / 2, 5));
                } else {
                    if (forecaster != null) {
                        forecaster.getTSLagMaker().setMaxLag(Math.min(this.m_instances.numInstances() / 2, 12));
                    }
                    this.m_advancedConfig.m_maxLagSpinner.setValue(Math.min(this.m_instances.numInstances() / 2, 12));
                }
            }
            if (!this.m_advancedConfig.getCustomizeDateDerivedPeriodics() && forecaster != null) {
                if (selectedP.equals("Hourly")) {
                    forecaster.getTSLagMaker().setAddAMIndicator(true);
                } else if (selectedP.equals("Daily")) {
                    forecaster.getTSLagMaker().setAddDayOfWeek(true);
                    forecaster.getTSLagMaker().setAddWeekendIndicator(true);
                } else if (selectedP.equals("Weekly")) {
                    forecaster.getTSLagMaker().setAddMonthOfYear(true);
                    forecaster.getTSLagMaker().setAddQuarterOfYear(true);
                } else if (selectedP.equals("Monthly")) {
                    forecaster.getTSLagMaker().setAddMonthOfYear(true);
                    forecaster.getTSLagMaker().setAddQuarterOfYear(true);
                }
            }
        }
    }

    public void applyToForecaster(WekaForecaster forecaster) throws Exception {
        if (forecaster != null) {
            TSLagMaker lagMaker = forecaster.getTSLagMaker();
            String selected = this.m_timeStampCombo.getSelectedItem().toString();
            if (!selected.equals("<Use an artificial time index>") && !selected.equals("<None>")) {
                lagMaker.setTimeStampField(selected);
            } else {
                lagMaker.setTimeStampField("");
            }
            if (selected.equals("<None>")) {
                lagMaker.setAdjustForTrends(false);
            } else {
                lagMaker.setAdjustForTrends(true);
            }
            if (this.m_periodicityCombo.getSelectedItem().toString().equals("<Detect automatically>") && selected.equals("<Use an artificial time index>") && !this.m_advancedConfig.isUsingCustomLags()) {
                throw new Exception("Cannot automatically detect periodicity when using an artificial time index.");
            }
            if (!(!this.m_periodicityCombo.getSelectedItem().toString().equals("<Detect automatically>") || selected.equals("<Use an artificial time index>") || selected.equals("<None>") || this.m_instances.attribute(selected).isDate() || this.m_advancedConfig.isUsingCustomLags())) {
                throw new Exception("Cannot automatically detect periodicity when using a non-date time stamp (select manually or use custom lags.");
            }
            lagMaker.setAddAMIndicator(false);
            lagMaker.setAddDayOfWeek(false);
            lagMaker.setAddMonthOfYear(false);
            lagMaker.setAddQuarterOfYear(false);
            lagMaker.setAddWeekendIndicator(false);
            if (!selected.equals("<None>")) {
                this.checkPeriodicity(forecaster);
            }
            if (this.m_computeConfidence.isSelected()) {
                forecaster.setCalculateConfIntervalsForForecasts(this.getHorizon());
                double confLevel = ((SpinnerNumberModel)this.m_confidenceLevelSpinner.getModel()).getNumber().doubleValue();
                forecaster.setConfidenceLevel(confLevel / 100.0);
            } else {
                forecaster.setCalculateConfIntervalsForForecasts(0);
            }
            int[] selectedTargets = this.m_targetPanel.getSelectedAttributes();
            StringBuffer targetBuf = new StringBuffer();
            for (int selectedTarget : selectedTargets) {
                targetBuf.append(this.m_targetHeader.attribute(selectedTarget).name()).append(",");
            }
            String temp = targetBuf.substring(0, targetBuf.lastIndexOf(","));
            if (temp.length() == 0) {
                throw new Exception("You must select some fields to forecast!");
            }
            forecaster.setFieldsToForecast(temp);
        }
    }

    public void applyToEvaluation(TSEvaluation eval, WekaForecaster forecaster) throws Exception {
        int horizon = ((SpinnerNumberModel)this.m_horizonSpinner.getModel()).getNumber().intValue();
        if (horizon < 1) {
            throw new Exception("Must specify a non-zero number of steps toforecast into the future");
        }
        eval.setHorizon(horizon);
        eval.setPrimeWindowSize(forecaster.getTSLagMaker().getMaxLag());
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            Instances i = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            SimpleConfigPanel scp = new SimpleConfigPanel(null);
            scp.setInstances(i);
            final JFrame jf = new JFrame("Simple Config Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)scp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

